/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.util.Log;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;

public class FastScrollerUtil {
    private static final String TAG = FastScrollerUtil.class.getSimpleName();
    private static boolean DEBUG = false;

    public static void enableDebugging(boolean debug) {
        DEBUG = debug;
    }

    public static void initHeaderScroller(RecyclerView rv) {
        RecyclerView.Adapter adapter = rv.getAdapter();
        if (adapter instanceof IHeaderAdapter) {
            ((IHeaderAdapter)adapter).initScrollManager(FastScrollerUtil.getSpanSize(rv));
            FastScrollerUtil.initSpanSizeLookup(rv, (IHeaderAdapter)adapter);
        }
    }

    public static Integer getSpanSize(RecyclerView rv) {
        RecyclerView.LayoutManager lm = rv.getLayoutManager();
        if (lm != null && lm instanceof GridLayoutManager) {
            return ((GridLayoutManager)lm).getSpanCount();
        }
        return 1;
    }

    public static boolean initSpanSizeLookup(final RecyclerView rv, final IHeaderAdapter adapter) {
        final RecyclerView.LayoutManager lm = rv.getLayoutManager();
        if (lm != null && lm instanceof GridLayoutManager) {
            ((GridLayoutManager)lm).setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (rv == null) {
                        return 1;
                    }
                    return adapter.isHeader(position) ? ((GridLayoutManager)lm).getSpanCount() : 1;
                }
            });
            return true;
        }
        return false;
    }

    public static class HeaderScrollManager {
        private int mSpan;
        private int mCount;
        private int mRows;
        private ArrayList<HeaderData> mHeaderData;
        private int mHeaderHeight;
        private int mRowHeight;
        private int mTotalHeight;

        public HeaderScrollManager(int span) {
            this.mSpan = span;
        }

        public int getSpan() {
            return this.mSpan;
        }

        public <T extends RecyclerView.Adapter> void calcData(T adapter) {
            int i;
            this.mHeaderData = new ArrayList();
            this.mCount = ((IHeaderAdapter)adapter).getItemCount();
            this.mHeaderHeight = ((IHeaderAdapter)adapter).getHeaderHeight();
            this.mRowHeight = ((IHeaderAdapter)adapter).getRowHeight();
            this.mRows = 0;
            int itemsAddedToHeaders = 0;
            for (i = 1; i < this.mCount; ++i) {
                if (!((IHeaderAdapter)adapter).isHeader(i) && i != this.mCount - 1) continue;
                int itemsUnderneathHeader = i - itemsAddedToHeaders;
                if (i != this.mCount - 1) {
                    --itemsUnderneathHeader;
                }
                HeaderData headerData = new HeaderData(itemsAddedToHeaders, itemsUnderneathHeader);
                this.mHeaderData.add(headerData);
                ++itemsAddedToHeaders;
                itemsAddedToHeaders += itemsUnderneathHeader;
                this.mRows += headerData.getRows(this.mSpan);
            }
            this.mTotalHeight = this.mHeaderData.size() * this.mHeaderHeight;
            for (i = 0; i < this.mHeaderData.size(); ++i) {
                this.mTotalHeight += (this.mHeaderData.get(i).getRows(this.mSpan) - 1) * this.mRowHeight;
            }
            if (DEBUG) {
                for (i = 0; i < this.mHeaderData.size(); ++i) {
                    Log.d((String)TAG, (String)("Header data " + i + ": headerIndex=" + this.mHeaderData.get(i).headerIndex + " | items=" + this.mHeaderData.get(i).items + " | rows=" + this.mHeaderData.get(i).getRows(this.mSpan)));
                }
                for (i = 0; i <= this.mCount; ++i) {
                    float progress = (float)i / (float)this.mCount;
                    this.getItemIndexForScroll(progress);
                }
                for (i = 0; i < this.mCount; ++i) {
                    this.getDepthForItem(i);
                }
            }
        }

        public int getTotalDepth() {
            return this.mTotalHeight;
        }

        public int getDepthForItem(int index) {
            int row = 0;
            int headersAbove = 0;
            for (int i = 0; i < this.mHeaderData.size(); ++i) {
                HeaderData headerData = this.mHeaderData.get(i);
                ++headersAbove;
                if (headerData.containsIndex(index)) {
                    int relRow = headerData.getRelativeRowIndex(this.mSpan, index);
                    row += relRow + 1;
                    if (relRow != 0) break;
                    --headersAbove;
                    break;
                }
                row += headerData.getRows(this.mSpan);
            }
            int totalOffset = headersAbove * this.mHeaderHeight + (row - headersAbove - 1) * this.mRowHeight;
            if (DEBUG) {
                Log.d((String)TAG, (String)("index => row=" + row + " of " + this.mRows + ", headersAbove=" + headersAbove + " (totalOffset=" + totalOffset + ")"));
            }
            return totalOffset;
        }

        public int getItemIndexForScroll(float scrollBarPos) {
            if (scrollBarPos < 0.0f) {
                scrollBarPos = 0.0f;
            } else if (scrollBarPos > 1.0f) {
                scrollBarPos = 1.0f;
            }
            int rowIndex = Math.round((float)(this.mRows - 1) * scrollBarPos);
            int row = rowIndex + 1;
            int rows = 0;
            for (int i = 0; i < this.mHeaderData.size(); ++i) {
                HeaderData headerData = this.mHeaderData.get(i);
                if (headerData.containsRow(rows, this.mSpan, row)) {
                    int index = headerData.getFirstItemIndex(rows, this.mSpan, row);
                    if (DEBUG) {
                        Log.d((String)TAG, (String)("scrollBarPos=" + scrollBarPos + " => row " + row + " of " + this.mRows + " (item " + (index + 1) + " of " + this.mCount + ")"));
                    }
                    return index;
                }
                rows += headerData.getRows(this.mSpan);
            }
            throw new RuntimeException("Could not find index for scroll position!");
        }
    }

    public static class HeaderData {
        private int headerIndex;
        private int items;

        public HeaderData(int headerIndex, int items) {
            this.items = items;
            this.headerIndex = headerIndex;
        }

        public boolean containsIndex(int index) {
            return index >= this.headerIndex && index <= this.headerIndex + this.items;
        }

        public boolean containsRow(int rowsBeforeThisHeader, int span, int row) {
            return row >= rowsBeforeThisHeader + 1 && row <= rowsBeforeThisHeader + this.getRows(span);
        }

        public int getFirstItemIndex(int rowsBeforeThisHeader, int span, int row) {
            int relativeRowIndex = row - rowsBeforeThisHeader - 1;
            if (relativeRowIndex == 0) {
                return this.headerIndex;
            }
            return this.headerIndex + relativeRowIndex * span - (span - 1);
        }

        public int getRows(int span) {
            return 1 + (int)Math.ceil((float)this.items / (float)span);
        }

        public int getRelativeRowIndex(int span, int index) {
            if (index - this.headerIndex == 0) {
                return 0;
            }
            return (int)Math.ceil((float)(index - this.headerIndex) / (float)span);
        }
    }

    public static interface IHeaderAdapter {
        public boolean isHeader(int var1);

        public int getItemCount();

        public void initScrollManager(int var1);

        public int getHeaderHeight();

        public int getRowHeight();
    }
}

