/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.turingtechnologies.materialscrollbar.LayoutWrapContentUpdater;
import com.turingtechnologies.materialscrollbar.MaterialScrollBar;
import com.turingtechnologies.materialscrollbar.R;
import com.turingtechnologies.materialscrollbar.Utils;

public abstract class Indicator<T, U extends Indicator>
extends RelativeLayout {
    protected TextView textView;
    protected Context context;
    private boolean addSpace;
    private MaterialScrollBar materialScrollBar;
    private boolean rtl;
    private int size;
    private Class<T> adapterClass;

    public Indicator(Context context, Class<T> adapter) {
        super(context);
        this.context = context;
        this.textView = new TextView(context);
        this.setVisibility(4);
        this.adapterClass = adapter;
    }

    void setSizeCustom(int size) {
        this.size = this.addSpace ? size + Utils.getDP(10, (View)this) : size;
        this.setLayoutParams((ViewGroup.LayoutParams)this.refreshMargins((RelativeLayout.LayoutParams)this.getLayoutParams()));
    }

    void setRTL(boolean rtl) {
        this.rtl = rtl;
    }

    void linkToScrollBar(MaterialScrollBar msb, boolean addSpace) {
        this.addSpace = addSpace;
        this.materialScrollBar = msb;
        this.size = addSpace ? Utils.getDP(15, (View)this) + this.materialScrollBar.handleThumb.getWidth() : Utils.getDP(2, (View)this) + this.materialScrollBar.handleThumb.getWidth();
        ViewCompat.setBackground((View)this, (Drawable)ContextCompat.getDrawable((Context)this.context, (int)(this.rtl ? R.drawable.indicator_ltr : R.drawable.indicator)));
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Utils.getDP(this.getIndicatorWidth(), (View)this), Utils.getDP(this.getIndicatorHeight(), (View)this));
        lp = this.refreshMargins(lp);
        this.textView.setTextSize(1, (float)this.getTextSize());
        RelativeLayout.LayoutParams tvlp = new RelativeLayout.LayoutParams(-2, -2);
        tvlp.addRule(13, -1);
        this.addView((View)this.textView, (ViewGroup.LayoutParams)tvlp);
        ((GradientDrawable)this.getBackground()).setColor(msb.handleColor);
        if (this.rtl) {
            lp.addRule(5, msb.getId());
        } else {
            lp.addRule(7, msb.getId());
        }
        ((ViewGroup)msb.getParent()).addView((View)this, (ViewGroup.LayoutParams)lp);
    }

    RelativeLayout.LayoutParams refreshMargins(RelativeLayout.LayoutParams lp) {
        if (this.rtl) {
            lp.setMargins(this.size, 0, 0, 0);
        } else {
            lp.setMargins(0, 0, this.size, 0);
        }
        return lp;
    }

    void setScroll(float y) {
        if (this.getVisibility() == 0) {
            if ((y -= 75.0f - this.materialScrollBar.getIndicatorOffset() + (float)Utils.getDP(this.getIndicatorHeight() / 2, (View)this)) < 5.0f) {
                y = 5.0f;
            }
            this.setY(y);
        }
    }

    void setText(int section) {
        String newText;
        try {
            RecyclerView.Adapter adapter = this.materialScrollBar.recyclerView.getAdapter();
            if (adapter == null) {
                Log.e((String)"MaterialScrollBarLib", (String)"The adapter for your recyclerView has not been set; skipping indicator layout.");
                return;
            }
            newText = this.getTextElement(section, adapter);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            newText = "Error";
        }
        if (!this.textView.getText().equals(newText)) {
            this.textView.setText((CharSequence)newText);
            LayoutWrapContentUpdater.wrapContentAgain((ViewGroup)this);
        }
    }

    void testAdapter(RecyclerView.Adapter adapter) {
        if (adapter == null) {
            Log.e((String)"MaterialScrollBarLib", (String)"The adapter for your recyclerView has not been set; skipping indicator layout.");
            return;
        }
        if (!this.adapterClass.isInstance(adapter)) {
            throw new IllegalArgumentException("In order to add this indicator, the adapter for your recyclerView, " + adapter.getClass().getName() + ", MUST implement " + Utils.getGenericName(this) + ".");
        }
    }

    public U setTypeface(Typeface typeface) {
        this.textView.setTypeface(typeface);
        return (U)((Object)this);
    }

    void setTextColor(@ColorInt int color2) {
        this.textView.setTextColor(color2);
    }

    protected abstract String getTextElement(Integer var1, T var2);

    protected abstract int getIndicatorHeight();

    protected abstract int getIndicatorWidth();

    protected abstract int getTextSize();
}

