/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.content.Context;
import android.os.Build;
import android.support.annotation.IdRes;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import java.lang.reflect.ParameterizedType;

class Utils {
    Utils() {
    }

    static int getDP(int dp, View v) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)v.getResources().getDisplayMetrics());
    }

    static int getDP(int dp, Context c) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)c.getResources().getDisplayMetrics());
    }

    static boolean isRightToLeft(Context c) {
        return Build.VERSION.SDK_INT >= 19 && c.getResources().getConfiguration().getLayoutDirection() == 1;
    }

    static <T> String getGenericName(T object) {
        return ((Class)((ParameterizedType)object.getClass().getGenericSuperclass()).getActualTypeArguments()[0]).getSimpleName();
    }

    static View findNearestNeighborWithID(@IdRes int id, View viewToStartFrom) {
        ViewGroup parent;
        if (viewToStartFrom == null) {
            return null;
        }
        try {
            parent = (ViewGroup)viewToStartFrom.getParent();
        }
        catch (ClassCastException e) {
            return null;
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View result;
            if (viewToStartFrom == parent.getChildAt(i) || (result = parent.getChildAt(i).findViewById(id)) == null) continue;
            return result;
        }
        return Utils.findNearestNeighborWithID(id, (View)parent);
    }
}

