/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.RelativeLayout;
import com.turingtechnologies.materialscrollbar.CustomExceptions;
import com.turingtechnologies.materialscrollbar.Handle;
import com.turingtechnologies.materialscrollbar.ICustomScroller;
import com.turingtechnologies.materialscrollbar.Indicator;
import com.turingtechnologies.materialscrollbar.R;
import com.turingtechnologies.materialscrollbar.ScrollingUtilities;
import com.turingtechnologies.materialscrollbar.Utils;

abstract class MaterialScrollBar<T>
extends RelativeLayout {
    private View handleTrack;
    Handle handleThumb;
    Indicator indicator;
    int handleColour;
    int handleOffColour = Color.parseColor((String)"#9c9c9c");
    protected boolean hidden = true;
    private int textColour = ContextCompat.getColor((Context)this.getContext(), (int)17170443);
    boolean lightOnTouch;
    private TypedArray a;
    private Boolean rtl = false;
    boolean hiddenByUser = false;
    RecyclerView recyclerView;
    private int seekId = 0;
    ScrollingUtilities scrollUtils = new ScrollingUtilities(this);
    SwipeRefreshLayout swipeRefreshLayout;
    private View.OnLayoutChangeListener indicatorLayoutListener;
    boolean sizeUnchecked = true;

    MaterialScrollBar(Context context, RecyclerView recyclerView, boolean lightOnTouch) {
        super(context);
        this.recyclerView = recyclerView;
        this.addView(this.setUpHandleTrack(context));
        this.addView(this.setUpHandle(context, lightOnTouch));
        this.setRightToLeft(Utils.isRightToLeft(context));
        this.generalSetup();
    }

    MaterialScrollBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    MaterialScrollBar(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
        this.setUpProps(context, attributeSet);
        this.addView(this.setUpHandleTrack(context));
        this.addView(this.setUpHandle(context, this.a.getBoolean(R.styleable.MaterialScrollBar_msb_lightOnTouch, true)));
        this.a.recycle();
        this.setRightToLeft(Utils.isRightToLeft(context));
    }

    void setUpProps(Context context, AttributeSet attrs) {
        this.a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MaterialScrollBar, 0, 0);
        if (!this.a.hasValue(R.styleable.MaterialScrollBar_msb_lightOnTouch)) {
            throw new CustomExceptions.MissingAttributesException(new String[]{"lightOnTouch"});
        }
        if (!this.isInEditMode()) {
            this.seekId = this.a.getResourceId(R.styleable.MaterialScrollBar_msb_recyclerView, 0);
        }
        this.implementPreferences();
    }

    View setUpHandleTrack(Context context) {
        this.handleTrack = new View(context);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Utils.getDP(12, (View)this), -1);
        lp.addRule(11);
        this.handleTrack.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.handleTrack.setBackgroundColor(ContextCompat.getColor((Context)context, (int)0x1060000));
        ViewCompat.setAlpha((View)this.handleTrack, (float)0.4f);
        return this.handleTrack;
    }

    Handle setUpHandle(Context context, Boolean lightOnTouch) {
        this.handleThumb = new Handle(context, this.getMode());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Utils.getDP(12, (View)this), Utils.getDP(72, (View)this));
        lp.addRule(11);
        this.handleThumb.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.lightOnTouch = lightOnTouch;
        this.handleColour = MaterialScrollBar.fetchAccentColour(context);
        int colourToSet = lightOnTouch != false ? Color.parseColor((String)"#9c9c9c") : this.handleColour;
        this.handleThumb.setBackgroundColor(colourToSet);
        return this.handleThumb;
    }

    void implementPreferences() {
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_barColour)) {
            this.setBarColour(this.a.getColor(R.styleable.MaterialScrollBar_msb_barColour, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_handleColour)) {
            this.setHandleColour(this.a.getColor(R.styleable.MaterialScrollBar_msb_handleColour, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_handleOffColour)) {
            this.setHandleOffColour(this.a.getColor(R.styleable.MaterialScrollBar_msb_handleOffColour, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_textColour)) {
            this.setTextColour(this.a.getColor(R.styleable.MaterialScrollBar_msb_textColour, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_barThickness)) {
            this.setBarThickness(this.a.getDimensionPixelSize(R.styleable.MaterialScrollBar_msb_barThickness, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_rightToLeft)) {
            this.setRightToLeft(this.a.getBoolean(R.styleable.MaterialScrollBar_msb_rightToLeft, false));
        }
        this.implementFlavourPreferences(this.a);
    }

    public T setRecyclerView(RecyclerView rv) {
        if (this.seekId != 0) {
            throw new RuntimeException("There is already a recyclerView set by XML.");
        }
        if (this.recyclerView != null) {
            throw new RuntimeException("There is already a recyclerView set.");
        }
        this.recyclerView = rv;
        this.generalSetup();
        return (T)((Object)this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.seekId != 0) {
            this.recyclerView = (RecyclerView)this.getRootView().findViewById(this.seekId);
            this.generalSetup();
        }
    }

    private void generalSetup() {
        this.recyclerView.setVerticalScrollBarEnabled(false);
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new scrollListener());
        this.setTouchIntercept();
        this.identifySwipeRefreshParents();
        this.checkCustomScrolling();
        TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, this.rtl != false ? -this.getHideRatio() : this.getHideRatio(), 2, 0.0f, 2, 0.0f);
        anim.setDuration(0L);
        anim.setFillAfter(true);
        this.hidden = true;
        this.startAnimation((Animation)anim);
    }

    void identifySwipeRefreshParents() {
        boolean cycle = true;
        ViewParent parent = this.getParent();
        if (parent != null) {
            while (cycle) {
                if (parent instanceof SwipeRefreshLayout) {
                    this.swipeRefreshLayout = (SwipeRefreshLayout)parent;
                    cycle = false;
                    continue;
                }
                if (parent.getParent() == null) {
                    cycle = false;
                    continue;
                }
                parent = parent.getParent();
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.recyclerView == null && !this.isInEditMode()) {
            throw new RuntimeException("You need to set a recyclerView for the scroll bar, either in the XML or using setRecyclerView().");
        }
        if (this.sizeUnchecked && !this.isInEditMode()) {
            this.scrollUtils.getCurScrollState();
            if (this.scrollUtils.getAvailableScrollHeight() <= 0) {
                this.handleTrack.setVisibility(8);
                this.handleThumb.setVisibility(8);
            } else {
                this.handleTrack.setVisibility(0);
                this.handleThumb.setVisibility(0);
                this.sizeUnchecked = false;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredWidth = Utils.getDP(12, (View)this);
        int desiredHeight = 100;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    abstract void setTouchIntercept();

    abstract int getMode();

    abstract float getHideRatio();

    abstract void onScroll();

    abstract boolean getHide();

    abstract void implementFlavourPreferences(TypedArray var1);

    abstract float getHandleOffset();

    abstract float getIndicatorOffset();

    private void checkCustomScrollingInterface() {
        if (this.recyclerView.getAdapter() instanceof ICustomScroller) {
            this.scrollUtils.customScroller = (ICustomScroller)this.recyclerView.getAdapter();
        }
    }

    private void checkCustomScrolling() {
        if (ViewCompat.isAttachedToWindow((View)this)) {
            this.checkCustomScrollingInterface();
        } else {
            this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    MaterialScrollBar.this.removeOnLayoutChangeListener(this);
                    MaterialScrollBar.this.checkCustomScrollingInterface();
                }
            });
        }
    }

    public T setHandleColour(String colour) {
        this.handleColour = Color.parseColor((String)colour);
        this.setHandleColour();
        return (T)((Object)this);
    }

    public T setHandleColour(@ColorInt int colour) {
        this.handleColour = colour;
        this.setHandleColour();
        return (T)((Object)this);
    }

    public T setHandleColourRes(@ColorRes int colourResId) {
        this.handleColour = ContextCompat.getColor((Context)this.getContext(), (int)colourResId);
        this.setHandleColour();
        return (T)((Object)this);
    }

    private void setHandleColour() {
        if (this.indicator != null) {
            ((GradientDrawable)this.indicator.getBackground()).setColor(this.handleColour);
        }
        if (!this.lightOnTouch) {
            this.handleThumb.setBackgroundColor(this.handleColour);
        }
    }

    public T setHandleOffColour(String colour) {
        this.handleOffColour = Color.parseColor((String)colour);
        if (this.lightOnTouch) {
            this.handleThumb.setBackgroundColor(this.handleOffColour);
        }
        return (T)((Object)this);
    }

    public T setHandleOffColour(@ColorInt int colour) {
        this.handleOffColour = colour;
        if (this.lightOnTouch) {
            this.handleThumb.setBackgroundColor(this.handleOffColour);
        }
        return (T)((Object)this);
    }

    public T setHandleOffColourRes(@ColorRes int colourResId) {
        this.handleOffColour = ContextCompat.getColor((Context)this.getContext(), (int)colourResId);
        if (this.lightOnTouch) {
            this.handleThumb.setBackgroundColor(this.handleOffColour);
        }
        return (T)((Object)this);
    }

    public T setBarColour(String colour) {
        this.handleTrack.setBackgroundColor(Color.parseColor((String)colour));
        return (T)((Object)this);
    }

    public T setBarColour(@ColorInt int colour) {
        this.handleTrack.setBackgroundColor(colour);
        return (T)((Object)this);
    }

    public T setBarColourRes(@ColorRes int colourResId) {
        this.handleTrack.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)colourResId));
        return (T)((Object)this);
    }

    public T setTextColour(@ColorInt int colour) {
        this.textColour = colour;
        if (this.indicator != null) {
            this.indicator.setTextColour(this.textColour);
        }
        return (T)((Object)this);
    }

    public T setTextColourRes(@ColorRes int colourResId) {
        this.textColour = ContextCompat.getColor((Context)this.getContext(), (int)colourResId);
        if (this.indicator != null) {
            this.indicator.setTextColour(this.textColour);
        }
        return (T)((Object)this);
    }

    public T setTextColour(String colour) {
        this.textColour = Color.parseColor((String)colour);
        if (this.indicator != null) {
            this.indicator.setTextColour(this.textColour);
        }
        return (T)((Object)this);
    }

    public T removeIndicator() {
        if (this.indicator != null) {
            this.indicator.removeAllViews();
        }
        this.indicator = null;
        return (T)((Object)this);
    }

    public T setIndicator(final Indicator indicator, final boolean addSpaceSide) {
        if (ViewCompat.isAttachedToWindow((View)this)) {
            this.setupIndicator(indicator, addSpaceSide);
        } else {
            this.removeOnLayoutChangeListener(this.indicatorLayoutListener);
            this.indicatorLayoutListener = new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    MaterialScrollBar.this.setupIndicator(indicator, addSpaceSide);
                    MaterialScrollBar.this.removeOnLayoutChangeListener(this);
                }
            };
            this.addOnLayoutChangeListener(this.indicatorLayoutListener);
        }
        return (T)((Object)this);
    }

    private void setupIndicator(Indicator indicator, boolean addSpaceSide) {
        this.indicator = indicator;
        indicator.testAdapter(this.recyclerView.getAdapter());
        indicator.setRTL(this.rtl);
        indicator.linkToScrollBar(this, addSpaceSide);
        indicator.setTextColour(this.textColour);
    }

    public T setBarThickness(int thickness) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.handleThumb.getLayoutParams();
        layoutParams.width = thickness;
        this.handleThumb.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = (RelativeLayout.LayoutParams)this.handleTrack.getLayoutParams();
        layoutParams.width = thickness;
        this.handleTrack.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.indicator != null) {
            this.indicator.setSizeCustom(thickness);
        }
        layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        layoutParams.width = thickness;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return (T)((Object)this);
    }

    public void setScrollBarHidden(boolean hidden) {
        this.hiddenByUser = hidden;
        if (this.hiddenByUser) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
        }
    }

    public void setRightToLeft(boolean rtl) {
        this.rtl = rtl;
        this.handleThumb.setRightToLeft(rtl);
        if (this.indicator != null) {
            this.indicator.setRTL(rtl);
            this.indicator.setLayoutParams((ViewGroup.LayoutParams)this.indicator.refreshMargins((RelativeLayout.LayoutParams)this.indicator.getLayoutParams()));
        }
    }

    static int fetchAccentColour(Context context) {
        TypedValue typedValue = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorAccent});
        int color2 = a.getColor(0, 0);
        a.recycle();
        return color2;
    }

    void fadeOut() {
        if (!this.hidden) {
            TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, this.rtl != false ? -this.getHideRatio() : this.getHideRatio(), 2, 0.0f, 2, 0.0f);
            anim.setDuration(150L);
            anim.setFillAfter(true);
            this.hidden = true;
            this.startAnimation((Animation)anim);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MaterialScrollBar.this.handleThumb.expandHandle();
                }
            }, anim.getDuration() / 3L);
        }
    }

    void fadeIn() {
        if (this.hidden && this.getHide() && !this.hiddenByUser) {
            this.hidden = false;
            TranslateAnimation anim = new TranslateAnimation(1, this.rtl != false ? -this.getHideRatio() : this.getHideRatio(), 1, 0.0f, 2, 0.0f, 2, 0.0f);
            anim.setDuration(150L);
            anim.setFillAfter(true);
            this.startAnimation((Animation)anim);
            this.handleThumb.collapseHandle();
        }
    }

    protected void onDown(MotionEvent event) {
        if (this.indicator != null && this.indicator.getVisibility() == 4) {
            this.indicator.setVisibility(0);
            if (Build.VERSION.SDK_INT >= 12) {
                this.indicator.setAlpha(0.0f);
                this.indicator.animate().alpha(1.0f).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    @TargetApi(value=11)
                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        MaterialScrollBar.this.indicator.setAlpha(1.0f);
                    }
                });
            }
        }
        int top = this.handleThumb.getHeight() / 2;
        int bottom = this.recyclerView.getHeight() - Utils.getDP(72, this.recyclerView.getContext());
        float boundedY = Math.max((float)top, Math.min((float)bottom, event.getY() - this.getHandleOffset()));
        this.scrollUtils.scrollToPositionAtProgress((boundedY - (float)top) / (float)(bottom - top));
        this.scrollUtils.scrollHandleAndIndicator();
        this.recyclerView.onScrolled(0, 0);
        if (this.lightOnTouch) {
            this.handleThumb.setBackgroundColor(this.handleColour);
        }
    }

    protected void onUp() {
        if (this.indicator != null && this.indicator.getVisibility() == 0) {
            if (Build.VERSION.SDK_INT <= 12) {
                this.indicator.clearAnimation();
            }
            if (Build.VERSION.SDK_INT >= 12) {
                this.indicator.animate().alpha(0.0f).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        MaterialScrollBar.this.indicator.setVisibility(4);
                    }
                });
            } else {
                this.indicator.setVisibility(4);
            }
        }
        if (this.lightOnTouch) {
            this.handleThumb.setBackgroundColor(this.handleOffColour);
        }
    }

    class scrollListener
    extends RecyclerView.OnScrollListener {
        scrollListener() {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            MaterialScrollBar.this.scrollUtils.scrollHandleAndIndicator();
            if (dy != 0) {
                MaterialScrollBar.this.onScroll();
            }
            if (MaterialScrollBar.this.swipeRefreshLayout != null && !MaterialScrollBar.this.swipeRefreshLayout.isRefreshing()) {
                if (((LinearLayoutManager)recyclerView.getLayoutManager()).findFirstCompletelyVisibleItemPosition() == 0) {
                    MaterialScrollBar.this.swipeRefreshLayout.setEnabled(true);
                } else {
                    MaterialScrollBar.this.swipeRefreshLayout.setEnabled(false);
                }
            }
        }
    }
}

