/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.format.DateFormat;
import com.turingtechnologies.materialscrollbar.IDateableAdapter;
import com.turingtechnologies.materialscrollbar.Indicator;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;

@SuppressLint(value={"ViewConstructor"})
public class DateAndTimeIndicator
extends Indicator<IDateableAdapter> {
    private String[] months = new DateFormatSymbols().getMonths();
    private Boolean includeYear;
    private Boolean includeMonth;
    private Boolean includeDay;
    private Boolean includeTime;
    private Context context;

    public DateAndTimeIndicator(Context c, boolean includeYear, boolean includeMonth, boolean includeDay, boolean includeTime) {
        super(c);
        this.context = c;
        this.includeYear = includeYear;
        this.includeMonth = includeMonth;
        this.includeDay = includeDay;
        this.includeTime = includeTime;
    }

    @Override
    protected String getTextElement(Integer currentSection, IDateableAdapter adapter) {
        Date date = adapter.getDateForElement(currentSection);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String text = "";
        if (this.includeTime.booleanValue()) {
            text = text + DateFormat.getTimeFormat((Context)this.context).format(date);
        }
        if (this.includeMonth.booleanValue()) {
            text = text + " " + this.months[calendar.get(2)].substring(0, 3);
        }
        if (this.includeDay.booleanValue()) {
            int day = calendar.get(5);
            text = String.valueOf(day).length() == 1 ? text + " 0" + day : text + " " + day;
        }
        if (this.includeYear.booleanValue()) {
            if (this.includeDay.booleanValue()) {
                text = text + ",";
            }
            text = text + " " + calendar.get(1);
        }
        return text.trim();
    }

    @Override
    protected int getIndicatorHeight() {
        return 75;
    }

    @Override
    protected int getIndicatorWidth() {
        int width = 62;
        if (this.includeYear.booleanValue()) {
            if (this.includeDay.booleanValue()) {
                width += 14;
            }
            width += 56;
        }
        if (this.includeMonth.booleanValue()) {
            width += 43;
        }
        if (this.includeDay.booleanValue()) {
            width += 28;
        }
        if (this.includeTime.booleanValue()) {
            width = DateFormat.is24HourFormat((Context)this.context) ? (width += 70) : (width += 115);
        }
        return width;
    }

    @Override
    protected int getTextSize() {
        return 28;
    }
}

