/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

class CustomExceptions {
    CustomExceptions() {
    }

    static class AdapterNotSetupForCustomScrollingException
    extends RuntimeException {
        AdapterNotSetupForCustomScrollingException(Class aClass) {
            super("In order to use custom scrolling, the adapter for your recyclerView, " + aClass.getName() + ", MUST implement ICustomScroller.");
        }
    }

    static class UnsupportedParentException
    extends RuntimeException {
        UnsupportedParentException() {
            super("The recyclerView which is associated with a programmatically added scroll bar must be the child of a relative layout.");
        }
    }

    static class MissingAttributesException
    extends RuntimeException {
        MissingAttributesException(String[] missing) {
            super(MissingAttributesException.makeMessage(missing));
        }

        static String makeMessage(String[] missing) {
            String error = "You are missing the following required attributes from a scroll bar in your XML: ";
            for (String attribute : missing) {
                error = error + attribute + ", ";
            }
            return error + ".";
        }
    }

    static class AdapterNotSetupForIndicatorException
    extends RuntimeException {
        AdapterNotSetupForIndicatorException(Class aClass, String shouldExtend) {
            super("In order to add this indicator, the adapter for your recyclerView, " + aClass.getName() + ", MUST implement " + shouldExtend + ".");
        }
    }
}

