/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Paint;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.turingtechnologies.materialscrollbar.CustomExceptions;
import com.turingtechnologies.materialscrollbar.ICustomAdapter;
import com.turingtechnologies.materialscrollbar.Indicator;
import com.turingtechnologies.materialscrollbar.Utils;

@SuppressLint(value={"ViewConstructor"})
public class CustomIndicator
extends Indicator {
    private int textSize = 25;

    public CustomIndicator(Context context) {
        super(context);
    }

    @Override
    protected String getTextElement(Integer currentSection, RecyclerView.Adapter adapter) {
        String text = ((ICustomAdapter)adapter).getCustomStringForElement(currentSection);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        if (layoutParams == null) {
            return "";
        }
        Paint paint = new Paint();
        paint.setTextSize((float)this.textSize);
        int width = Utils.getDP((int)paint.measureText(text), this.context) + Utils.getDP(30, this.context);
        if (width < Utils.getDP(75, this.context)) {
            width = Utils.getDP(75, this.context);
        }
        layoutParams.width = width;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return text;
    }

    @Override
    protected int getIndicatorHeight() {
        return 75;
    }

    @Override
    protected int getIndicatorWidth() {
        return 0;
    }

    @Override
    protected void testAdapter(RecyclerView.Adapter adapter) {
        if (!(adapter instanceof ICustomAdapter)) {
            throw new CustomExceptions.AdapterNotSetupForIndicatorException(adapter.getClass(), "ICustomAdapter");
        }
    }

    @Override
    protected int getTextSize() {
        return this.textSize;
    }

    public CustomIndicator setTextSize(int textSize) {
        this.textSize = textSize;
        return this;
    }
}

