/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.view.View;
import android.view.ViewGroup;

public class LayoutWrapContentUpdater {
    public static final String TAG = LayoutWrapContentUpdater.class.getName();

    public static void wrapContentAgain(ViewGroup subTreeRoot) {
        LayoutWrapContentUpdater.wrapContentAgain(subTreeRoot, false, 0, 0);
    }

    public static void wrapContentAgain(ViewGroup subTreeRoot, boolean relayoutAllNodes) {
        LayoutWrapContentUpdater.wrapContentAgain(subTreeRoot, relayoutAllNodes, 0, 0);
    }

    public static void wrapContentAgain(ViewGroup subTreeRoot, boolean relayoutAllNodes, int subTreeRootWidthMeasureSpec, int subTreeRootHeightMeasureSpec) {
        assert ("main".equals(Thread.currentThread().getName()));
        if (subTreeRoot == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = subTreeRoot.getLayoutParams();
        int widthMeasureSpec = subTreeRootWidthMeasureSpec;
        if (layoutParams.width != -2 && subTreeRoot.getWidth() > 0) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)subTreeRoot.getWidth(), (int)0x40000000);
        }
        int heightMeasureSpec = subTreeRootHeightMeasureSpec;
        if (layoutParams.height != -2 && subTreeRoot.getHeight() > 0) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)subTreeRoot.getHeight(), (int)0x40000000);
        }
        subTreeRoot.measure(widthMeasureSpec, heightMeasureSpec);
        LayoutWrapContentUpdater.recurseWrapContent((View)subTreeRoot, relayoutAllNodes);
        subTreeRoot.requestLayout();
    }

    private static void recurseWrapContent(View nodeView, boolean relayoutAllNodes) {
        boolean isWrapHeight;
        if (nodeView.getVisibility() == 8) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = nodeView.getLayoutParams();
        boolean isWrapWidth = layoutParams.width == -2 || relayoutAllNodes;
        boolean bl = isWrapHeight = layoutParams.height == -2 || relayoutAllNodes;
        if (isWrapWidth || isWrapHeight) {
            boolean changed = false;
            int right = nodeView.getRight();
            int bottom = nodeView.getBottom();
            if (isWrapWidth && nodeView.getMeasuredWidth() > 0) {
                right = nodeView.getLeft() + nodeView.getMeasuredWidth();
                changed = true;
            }
            if (isWrapHeight && nodeView.getMeasuredHeight() > 0) {
                bottom = nodeView.getTop() + nodeView.getMeasuredHeight();
                changed = true;
            }
            if (changed) {
                nodeView.layout(nodeView.getLeft(), nodeView.getTop(), right, bottom);
            }
        }
        if (nodeView instanceof ViewGroup) {
            ViewGroup nodeGroup = (ViewGroup)nodeView;
            for (int i = 0; i < nodeGroup.getChildCount(); ++i) {
                LayoutWrapContentUpdater.recurseWrapContent(nodeGroup.getChildAt(i), relayoutAllNodes);
            }
        }
    }
}

