/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.turingtechnologies.materialscrollbar.LayoutWrapContentUpdater;
import com.turingtechnologies.materialscrollbar.MaterialScrollBar;
import com.turingtechnologies.materialscrollbar.R;
import com.turingtechnologies.materialscrollbar.Utils;

abstract class Indicator
extends RelativeLayout {
    protected TextView textView;
    protected Context context;
    private boolean addSpace;
    private MaterialScrollBar materialScrollBar;
    private boolean rtl;
    private int size;

    public Indicator(Context context) {
        super(context);
        this.context = context;
        this.textView = new TextView(context);
        this.setVisibility(4);
    }

    public void setSizeCustom(int size) {
        this.size = this.addSpace ? size + Utils.getDP(10, (View)this) : size;
        this.setLayoutParams((ViewGroup.LayoutParams)this.refreshMargins((RelativeLayout.LayoutParams)this.getLayoutParams()));
    }

    void setRTL(boolean rtl) {
        this.rtl = rtl;
    }

    void linkToScrollBar(MaterialScrollBar msb, boolean addSpace) {
        this.addSpace = addSpace;
        this.materialScrollBar = msb;
        this.size = addSpace ? Utils.getDP(15, (View)this) + this.materialScrollBar.handleThumb.getWidth() : Utils.getDP(2, (View)this) + this.materialScrollBar.handleThumb.getWidth();
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(ContextCompat.getDrawable((Context)this.context, (int)(this.rtl ? R.drawable.indicator_ltr : R.drawable.indicator)));
        } else {
            this.setBackgroundDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.indicator));
        }
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Utils.getDP(this.getIndicatorWidth(), (View)this), Utils.getDP(this.getIndicatorHeight(), (View)this));
        lp = this.refreshMargins(lp);
        this.textView.setTextSize(1, (float)this.getTextSize());
        RelativeLayout.LayoutParams tvlp = new RelativeLayout.LayoutParams(-2, -2);
        tvlp.addRule(13, -1);
        this.addView((View)this.textView, (ViewGroup.LayoutParams)tvlp);
        ((GradientDrawable)this.getBackground()).setColor(msb.handleColour);
        if (this.rtl) {
            lp.addRule(5, msb.getId());
        } else {
            lp.addRule(7, msb.getId());
        }
        ((ViewGroup)msb.getParent()).addView((View)this, (ViewGroup.LayoutParams)lp);
    }

    RelativeLayout.LayoutParams refreshMargins(RelativeLayout.LayoutParams lp) {
        if (this.rtl) {
            lp.setMargins(this.size, 0, 0, 0);
        } else {
            lp.setMargins(0, 0, this.size, 0);
        }
        return lp;
    }

    void setScroll(float y) {
        if (this.getVisibility() == 0) {
            if ((y -= 75.0f - this.materialScrollBar.getIndicatorOffset() + (float)Utils.getDP(this.getIndicatorHeight() / 2, (View)this)) < 5.0f) {
                y = 5.0f;
            }
            ViewCompat.setY((View)this, (float)y);
        }
    }

    void setText(int section) {
        String newText;
        try {
            newText = this.getTextElement(section, this.materialScrollBar.recyclerView.getAdapter());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            newText = "Error";
        }
        if (!this.textView.getText().equals(newText)) {
            this.textView.setText((CharSequence)newText);
            LayoutWrapContentUpdater.wrapContentAgain((ViewGroup)this);
        }
    }

    void setTextColour(int colour) {
        this.textView.setTextColor(colour);
    }

    abstract String getTextElement(Integer var1, RecyclerView.Adapter var2);

    abstract int getIndicatorHeight();

    abstract int getIndicatorWidth();

    abstract void testAdapter(RecyclerView.Adapter var1);

    abstract int getTextSize();
}

