/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.View;
import com.turingtechnologies.materialscrollbar.Utils;

public class Handle
extends View {
    RectF rectF;
    Paint p = new Paint();
    Integer mode;
    boolean expanded = false;
    Context context;
    Boolean rtl = false;

    public Handle(Context c, int m) {
        super(c);
        this.context = c;
        this.mode = m;
        this.p.setFlags(1);
    }

    void setRightToLeft(boolean rtl) {
        this.rtl = rtl;
    }

    public void setBackgroundColor(int color2) {
        super.setBackgroundColor(color2);
        this.p.setColor(color2);
    }

    public void collapseHandle() {
        this.expanded = true;
        this.rectF = new RectF(new Rect(this.getRight(), this.getTop(), this.getRight(), this.getBottom()));
        this.invalidate();
    }

    protected void onAnimationEnd() {
        super.onAnimationEnd();
    }

    public void expandHandle() {
        this.expanded = false;
        this.rectF = this.makeRect();
        this.invalidate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mode == 0) {
            this.rectF = this.makeRect();
        }
    }

    private RectF makeRect() {
        if (this.rtl.booleanValue()) {
            return new RectF(new Rect(this.getRight() - Utils.getDP(6, this.context), this.getTop(), this.getRight() + Utils.getDP(4, this.context), this.getBottom()));
        }
        return new RectF(new Rect(this.getLeft() - Utils.getDP(4, this.context), this.getTop(), this.getLeft() + Utils.getDP(6, this.context), this.getBottom()));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mode == 0 && !this.expanded) {
            Rect newRect = canvas.getClipBounds();
            newRect.inset(-Utils.getDP(30, this.context), 0);
            canvas.clipRect(newRect, Region.Op.REPLACE);
            canvas.drawArc(this.rectF, this.rtl != false ? 270.0f : 90.0f, 180.0f, false, this.p);
        }
    }
}

