/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.turingtechnologies.materialscrollbar.Handle;
import com.turingtechnologies.materialscrollbar.MaterialScrollBar;
import com.turingtechnologies.materialscrollbar.Utils;

public class DragScrollBar
extends MaterialScrollBar<DragScrollBar> {
    Boolean draggableFromAnywhere = false;
    float handleOffset = 0.0f;
    float indicatorOffset = 0.0f;
    boolean held = false;

    public DragScrollBar(Context context, RecyclerView recyclerView, boolean lightOnTouch) {
        super(context, recyclerView, lightOnTouch);
    }

    public DragScrollBar(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
    }

    public DragScrollBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public DragScrollBar setDraggableFromAnywhere(boolean draggableFromAnywhere) {
        this.draggableFromAnywhere = draggableFromAnywhere;
        return this;
    }

    private boolean validTouch(MotionEvent event) {
        return this.draggableFromAnywhere != false || event.getY() >= ViewCompat.getY((View)this.handle) - (float)Utils.getDP(20, this.recyclerView.getContext()) && event.getY() <= ViewCompat.getY((View)this.handle) + (float)this.handle.getHeight();
    }

    @Override
    void setTouchIntercept() {
        final Handle handle = this.handle;
        View.OnTouchListener otl = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!DragScrollBar.this.hiddenByUser) {
                    if (event.getAction() == 0 && DragScrollBar.this.validTouch(event)) {
                        DragScrollBar.this.held = true;
                        DragScrollBar.this.indicatorOffset = event.getY() - handle.getY() - (float)(handle.getLayoutParams().height / 2);
                        float offset2 = event.getY() - handle.getY();
                        float balance = handle.getY() / (float)DragScrollBar.this.scrollUtils.getAvailableScrollBarHeight();
                        DragScrollBar.this.handleOffset = offset2 * balance + DragScrollBar.this.indicatorOffset * (1.0f - balance);
                    }
                    if ((event.getAction() == 2 || event.getAction() == 0) && DragScrollBar.this.held) {
                        DragScrollBar.this.onDown(event);
                        DragScrollBar.this.fadeIn();
                    } else {
                        DragScrollBar.this.onUp();
                        DragScrollBar.this.held = false;
                        DragScrollBar.this.fadeOut();
                    }
                    return true;
                }
                return false;
            }
        };
        this.setOnTouchListener(otl);
    }

    @Override
    int getMode() {
        return 0;
    }

    @Override
    float getHideRatio() {
        if (this.programmatic) {
            return 0.35f;
        }
        return 0.65f;
    }

    @Override
    void onScroll() {
    }

    @Override
    boolean getHide() {
        return true;
    }

    @Override
    void implementFlavourPreferences(TypedArray a) {
    }

    @Override
    float getHandleOffset() {
        return this.draggableFromAnywhere != false ? 0.0f : this.handleOffset;
    }

    @Override
    float getIndicatorOffset() {
        return this.draggableFromAnywhere != false ? 0.0f : this.indicatorOffset;
    }
}

