/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.RelativeLayout;
import com.turingtechnologies.materialscrollbar.CustomExceptions;
import com.turingtechnologies.materialscrollbar.Handle;
import com.turingtechnologies.materialscrollbar.ICustomScroller;
import com.turingtechnologies.materialscrollbar.Indicator;
import com.turingtechnologies.materialscrollbar.R;
import com.turingtechnologies.materialscrollbar.ScrollingUtilities;
import com.turingtechnologies.materialscrollbar.Utils;
import java.util.ArrayList;

abstract class MaterialScrollBar<T>
extends RelativeLayout {
    private View background;
    Handle handle;
    int handleColour;
    int handleOffColour = Color.parseColor((String)"#9c9c9c");
    protected boolean hidden = true;
    RecyclerView recyclerView;
    Indicator indicator;
    private int textColour = ContextCompat.getColor((Context)this.getContext(), (int)17170443);
    boolean lightOnTouch;
    boolean hiddenByUser = false;
    private TypedArray a;
    private int seekId = 0;
    boolean programmatic;
    ScrollingUtilities scrollUtils = new ScrollingUtilities(this);
    SwipeRefreshLayout swipeRefreshLayout;
    private boolean customScroll = false;
    boolean sizeUnchecked = true;

    MaterialScrollBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    MaterialScrollBar(Context context, AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
        this.programmatic = false;
        this.addView(this.setUpBackground(context));
        this.setUpProps(context, attributeSet);
        this.addView(this.setUpHandle(context, this.a.getBoolean(R.styleable.MaterialScrollBar_msb_lightOnTouch, true)));
        if (!this.isInEditMode()) {
            this.seekId = this.a.getResourceId(R.styleable.MaterialScrollBar_msb_recyclerView, 0);
        }
        this.implementPreferences();
        this.a.recycle();
    }

    MaterialScrollBar(Context context, RecyclerView recyclerView, boolean lightOnTouch) {
        super(context);
        this.programmatic = true;
        if (!(recyclerView.getParent() instanceof RelativeLayout)) {
            throw new CustomExceptions.UnsupportedParentException();
        }
        this.setId(R.id.reservedNamedId);
        this.addView(this.setUpBackground(context));
        this.addView(this.setUpHandle(context, lightOnTouch));
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(Utils.getDP(20, (View)this), -1);
        layoutParams.addRule(7, recyclerView.getId());
        layoutParams.addRule(6, recyclerView.getId());
        layoutParams.addRule(8, recyclerView.getId());
        ((ViewGroup)recyclerView.getParent()).addView((View)this, (ViewGroup.LayoutParams)layoutParams);
        this.recyclerView = recyclerView;
        this.generalSetup();
    }

    void setUpProps(Context context, AttributeSet attrs) {
        this.a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MaterialScrollBar, 0, 0);
        ArrayList<String> missing = new ArrayList<String>();
        if (!this.a.hasValue(R.styleable.MaterialScrollBar_msb_lightOnTouch)) {
            missing.add("lightOnTouch");
        }
        if (missing.size() != 0) {
            throw new CustomExceptions.MissingAttributesException(missing);
        }
    }

    View setUpBackground(Context context) {
        this.background = new View(context);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Utils.getDP(12, (View)this), -1);
        lp.addRule(11);
        this.background.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.background.setBackgroundColor(ContextCompat.getColor((Context)context, (int)0x1060000));
        ViewCompat.setAlpha((View)this.background, (float)0.4f);
        return this.background;
    }

    Handle setUpHandle(Context context, Boolean lightOnTouch) {
        this.handle = new Handle(context, this.getMode(), this.programmatic);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(Utils.getDP(12, (View)this), Utils.getDP(72, (View)this));
        lp.addRule(11);
        this.handle.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.lightOnTouch = lightOnTouch;
        this.handleColour = Build.VERSION.SDK_INT >= 21 ? this.fetchAccentColour(context) : Color.parseColor((String)"#9c9c9c");
        int colourToSet = lightOnTouch != false ? Color.parseColor((String)"#9c9c9c") : this.handleColour;
        this.handle.setBackgroundColor(colourToSet);
        return this.handle;
    }

    void implementPreferences() {
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_barColour)) {
            this.setBarColour(this.a.getColor(R.styleable.MaterialScrollBar_msb_barColour, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_handleColour)) {
            this.setHandleColour(this.a.getColor(R.styleable.MaterialScrollBar_msb_handleColour, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_handleOffColour)) {
            this.setHandleOffColour(this.a.getColor(R.styleable.MaterialScrollBar_msb_handleOffColour, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_textColour)) {
            this.setTextColour(this.a.getColor(R.styleable.MaterialScrollBar_msb_textColour, 0));
        }
        if (this.a.hasValue(R.styleable.MaterialScrollBar_msb_barThickness)) {
            this.setBarThickness(this.a.getDimensionPixelSize(R.styleable.MaterialScrollBar_msb_barThickness, 0));
        }
        this.implementFlavourPreferences(this.a);
    }

    public T setRecyclerView(RecyclerView rv) {
        if (this.seekId != 0) {
            throw new RuntimeException("There is already a recyclerView set by XML.");
        }
        if (this.recyclerView != null) {
            throw new RuntimeException("There is already a recyclerView set.");
        }
        this.recyclerView = rv;
        this.generalSetup();
        return (T)((Object)this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.seekId != 0) {
            this.recyclerView = (RecyclerView)this.getRootView().findViewById(this.seekId);
            this.generalSetup();
        }
    }

    private void generalSetup() {
        this.recyclerView.setVerticalScrollBarEnabled(false);
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new scrollListener());
        this.setTouchIntercept();
        this.identifySwipeRefreshParents();
        TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, this.getHideRatio(), 2, 0.0f, 2, 0.0f);
        anim.setDuration(0L);
        anim.setFillAfter(true);
        this.hidden = true;
        this.startAnimation((Animation)anim);
    }

    void identifySwipeRefreshParents() {
        boolean cycle = true;
        ViewParent parent = this.getParent();
        while (cycle) {
            if (parent instanceof SwipeRefreshLayout) {
                this.swipeRefreshLayout = (SwipeRefreshLayout)parent;
                cycle = false;
                continue;
            }
            if (parent.getParent() == null) {
                cycle = false;
                continue;
            }
            parent = parent.getParent();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.recyclerView == null) {
            throw new RuntimeException("You need to set a recyclerView for the scroll bar, either in the XML or using setRecyclerView().");
        }
        if (this.sizeUnchecked && !this.isInEditMode()) {
            this.scrollUtils.getCurScrollState();
            if (this.scrollUtils.getAvailableScrollHeight() <= 0) {
                this.background.setVisibility(8);
                this.handle.setVisibility(8);
            } else {
                this.background.setVisibility(0);
                this.handle.setVisibility(0);
                this.sizeUnchecked = false;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredWidth = Utils.getDP(12, (View)this);
        int desiredHeight = 100;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    abstract void setTouchIntercept();

    abstract int getMode();

    abstract float getHideRatio();

    abstract void onScroll();

    abstract boolean getHide();

    abstract void implementFlavourPreferences(TypedArray var1);

    abstract float getHandleOffset();

    abstract float getIndicatorOffset();

    private void checkCustomScrollingInterface() {
        if (!(this.recyclerView.getAdapter() instanceof ICustomScroller)) {
            throw new CustomExceptions.AdapterNotSetupForCustomScrollingException(this.recyclerView.getAdapter().getClass());
        }
        this.scrollUtils.customScroller = (ICustomScroller)this.recyclerView.getAdapter();
    }

    public T useCustomScrolling() {
        this.customScroll = true;
        if (ViewCompat.isAttachedToWindow((View)this)) {
            this.checkCustomScrollingInterface();
        } else {
            this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    MaterialScrollBar.this.removeOnLayoutChangeListener(this);
                    MaterialScrollBar.this.checkCustomScrollingInterface();
                }
            });
        }
        return (T)((Object)this);
    }

    public T setHandleColour(String colour) {
        this.handleColour = Color.parseColor((String)colour);
        this.setHandleColour();
        return (T)((Object)this);
    }

    public T setHandleColour(@ColorInt int colour) {
        this.handleColour = colour;
        this.setHandleColour();
        return (T)((Object)this);
    }

    public T setHandleColourRes(@ColorRes int colourResId) {
        this.handleColour = ContextCompat.getColor((Context)this.getContext(), (int)colourResId);
        this.setHandleColour();
        return (T)((Object)this);
    }

    private void setHandleColour() {
        if (this.indicator != null) {
            ((GradientDrawable)this.indicator.getBackground()).setColor(this.handleColour);
        }
        if (!this.lightOnTouch) {
            this.handle.setBackgroundColor(this.handleColour);
        }
    }

    public T setHandleOffColour(String colour) {
        this.handleOffColour = Color.parseColor((String)colour);
        if (this.lightOnTouch) {
            this.handle.setBackgroundColor(this.handleOffColour);
        }
        return (T)((Object)this);
    }

    public T setHandleOffColour(@ColorInt int colour) {
        this.handleOffColour = colour;
        if (this.lightOnTouch) {
            this.handle.setBackgroundColor(this.handleOffColour);
        }
        return (T)((Object)this);
    }

    public T setHandleOffColourRes(@ColorRes int colourResId) {
        this.handleOffColour = ContextCompat.getColor((Context)this.getContext(), (int)colourResId);
        if (this.lightOnTouch) {
            this.handle.setBackgroundColor(this.handleOffColour);
        }
        return (T)((Object)this);
    }

    public T setBarColour(String colour) {
        this.background.setBackgroundColor(Color.parseColor((String)colour));
        return (T)((Object)this);
    }

    public T setBarColour(@ColorInt int colour) {
        this.background.setBackgroundColor(colour);
        return (T)((Object)this);
    }

    public T setBarColourRes(@ColorRes int colourResId) {
        this.background.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)colourResId));
        return (T)((Object)this);
    }

    public T setTextColour(@ColorInt int colour) {
        this.textColour = colour;
        if (this.indicator != null) {
            this.indicator.setTextColour(this.textColour);
        }
        return (T)((Object)this);
    }

    public T setTextColourRes(@ColorRes int colourResId) {
        this.textColour = ContextCompat.getColor((Context)this.getContext(), (int)colourResId);
        if (this.indicator != null) {
            this.indicator.setTextColour(this.textColour);
        }
        return (T)((Object)this);
    }

    public T setTextColour(String colour) {
        this.textColour = Color.parseColor((String)colour);
        if (this.indicator != null) {
            this.indicator.setTextColour(this.textColour);
        }
        return (T)((Object)this);
    }

    public T removeIndicator() {
        this.indicator = null;
        return (T)((Object)this);
    }

    public T addIndicator(final Indicator indicator, final boolean addSpace) {
        if (ViewCompat.isAttachedToWindow((View)this)) {
            this.indicator = indicator;
            indicator.testAdapter(this.recyclerView.getAdapter());
            indicator.linkToScrollBar(this, addSpace);
            indicator.setTextColour(this.textColour);
        } else {
            this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    MaterialScrollBar.this.indicator = indicator;
                    indicator.testAdapter(MaterialScrollBar.this.recyclerView.getAdapter());
                    indicator.linkToScrollBar(MaterialScrollBar.this, addSpace);
                    indicator.setTextColour(MaterialScrollBar.this.textColour);
                    MaterialScrollBar.this.removeOnLayoutChangeListener(this);
                }
            });
        }
        return (T)((Object)this);
    }

    public T setBarThickness(int thickness) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.handle.getLayoutParams();
        layoutParams.width = thickness;
        this.handle.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = (RelativeLayout.LayoutParams)this.background.getLayoutParams();
        layoutParams.width = thickness;
        this.background.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.indicator != null) {
            this.indicator.setSizeCustom(thickness);
        }
        layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        layoutParams.width = thickness;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return (T)((Object)this);
    }

    public void setScrollBarHidden(boolean hidden) {
        this.hiddenByUser = hidden;
        this.fadeOut();
    }

    @TargetApi(value=21)
    private int fetchAccentColour(Context context) {
        TypedValue typedValue = new TypedValue();
        TypedArray b = context.obtainStyledAttributes(typedValue.data, new int[]{16843829});
        int colour = b.getColor(0, 0);
        b.recycle();
        return colour;
    }

    void fadeOut() {
        if (!this.hidden) {
            TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, this.getHideRatio(), 2, 0.0f, 2, 0.0f);
            anim.setDuration(150L);
            anim.setFillAfter(true);
            this.hidden = true;
            this.startAnimation((Animation)anim);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MaterialScrollBar.this.handle.expandHandle();
                }
            }, anim.getDuration() / 3L);
        }
    }

    void fadeIn() {
        if (this.hidden && this.getHide() && !this.hiddenByUser) {
            this.hidden = false;
            TranslateAnimation anim = new TranslateAnimation(1, this.getHideRatio(), 1, 0.0f, 2, 0.0f, 2, 0.0f);
            anim.setDuration(150L);
            anim.setFillAfter(true);
            this.startAnimation((Animation)anim);
            this.handle.collapseHandle();
        }
    }

    protected void onDown(MotionEvent event) {
        if (this.indicator != null && this.indicator.getVisibility() == 4) {
            this.indicator.setVisibility(0);
            if (Build.VERSION.SDK_INT >= 12) {
                this.indicator.setAlpha(0.0f);
                this.indicator.animate().alpha(1.0f).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    @TargetApi(value=11)
                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        MaterialScrollBar.this.indicator.setAlpha(1.0f);
                    }
                });
            }
        }
        int top = this.handle.getHeight() / 2;
        int bottom = this.recyclerView.getHeight() - Utils.getDP(72, this.recyclerView.getContext());
        float boundedY = Math.max((float)top, Math.min((float)bottom, event.getY() - this.getHandleOffset()));
        this.scrollUtils.scrollToPositionAtProgress((boundedY - (float)top) / (float)(bottom - top));
        this.scrollUtils.scrollHandleAndIndicator();
        this.recyclerView.onScrolled(0, 0);
        if (this.lightOnTouch) {
            this.handle.setBackgroundColor(this.handleColour);
        }
    }

    protected void onUp() {
        if (this.indicator != null && this.indicator.getVisibility() == 0) {
            if (Build.VERSION.SDK_INT <= 12) {
                this.indicator.clearAnimation();
            }
            if (Build.VERSION.SDK_INT >= 12) {
                this.indicator.animate().alpha(0.0f).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        MaterialScrollBar.this.indicator.setVisibility(4);
                    }
                });
            } else {
                this.indicator.setVisibility(4);
            }
        }
        if (this.lightOnTouch) {
            this.handle.setBackgroundColor(this.handleOffColour);
        }
    }

    class scrollListener
    extends RecyclerView.OnScrollListener {
        scrollListener() {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            MaterialScrollBar.this.scrollUtils.scrollHandleAndIndicator();
            if (dy != 0) {
                MaterialScrollBar.this.onScroll();
            }
            if (MaterialScrollBar.this.swipeRefreshLayout != null) {
                if (((LinearLayoutManager)recyclerView.getLayoutManager()).findFirstCompletelyVisibleItemPosition() == 0) {
                    MaterialScrollBar.this.swipeRefreshLayout.setEnabled(true);
                } else {
                    MaterialScrollBar.this.swipeRefreshLayout.setEnabled(false);
                }
            }
        }
    }
}

