/*
 * Decompiled with CFR 0.152.
 */
package com.turingtechnologies.materialscrollbar;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Build;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.RelativeLayout;
import com.nineoldandroids.view.ViewHelper;
import com.turingtechnologies.materialscrollbar.R;

public class MaterialScrollBar
extends RelativeLayout {
    private View background;
    private View handle;
    protected Activity a;
    private ScrollListener scrollListener = new ScrollListener(this);
    private boolean hidden = true;
    private int hideDuration = 2500;
    private boolean hide = true;
    private RecyclerView recyclerView;
    BarFade fade;

    public MaterialScrollBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        if (!this.isInEditMode()) {
            this.a = (Activity)context;
        }
        this.background = new View(context);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams((int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()), -1);
        lp.addRule(11);
        this.background.setLayoutParams((ViewGroup.LayoutParams)lp);
        TypedArray attributes = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.MaterialScrollBar, 0, 0);
        this.background.setBackgroundColor(attributes.getColor(R.styleable.MaterialScrollBar_barColor, this.getResources().getColor(0x1060000)));
        ViewHelper.setAlpha((View)this.background, (float)0.4f);
        this.handle = new View(context);
        lp = new RelativeLayout.LayoutParams((int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()), (int)TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        lp.addRule(11);
        this.handle.setLayoutParams((ViewGroup.LayoutParams)lp);
        if (Build.VERSION.SDK_INT >= 21) {
            this.handle.setBackgroundColor(attributes.getColor(R.styleable.MaterialScrollBar_handleColor, this.fetchAccentColor(context)));
        } else {
            this.handle.setBackgroundColor(attributes.getColor(R.styleable.MaterialScrollBar_handleColor, Color.parseColor((String)"#9c9c9c")));
        }
        this.addView(this.background);
        this.addView(this.handle);
        this.setTouchIntercept();
        this.fade = new BarFade(this);
        this.fade.start();
        TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, 1.0f, 2, 0.0f, 2, 0.0f);
        anim.setFillAfter(true);
        this.startAnimation((Animation)anim);
    }

    public MaterialScrollBar setRecyclerView(RecyclerView rv) {
        this.recyclerView = rv;
        rv.addOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        return this;
    }

    private void setTouchIntercept() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                MaterialScrollBar.this.recyclerView.scrollToPosition((int)((float)MaterialScrollBar.this.recyclerView.getAdapter().getItemCount() * (event.getY() / (float)(MaterialScrollBar.this.getHeight() - MaterialScrollBar.this.handle.getHeight()))));
                if (MaterialScrollBar.this.hide) {
                    MaterialScrollBar.this.fade.run = true;
                    MaterialScrollBar.this.fade.time = System.currentTimeMillis() + (long)MaterialScrollBar.this.hideDuration;
                    if (MaterialScrollBar.this.hidden) {
                        MaterialScrollBar.this.hidden = false;
                        TranslateAnimation anim = new TranslateAnimation(1, 1.0f, 1, 0.0f, 2, 0.0f, 2, 0.0f);
                        anim.setDuration(500L);
                        anim.setFillAfter(true);
                        MaterialScrollBar.this.startAnimation((Animation)anim);
                    }
                }
                return true;
            }
        });
    }

    public MaterialScrollBar setHideDuration(int duration) {
        this.hideDuration = duration;
        return this;
    }

    public MaterialScrollBar setHandleColour(String colour) {
        this.handle.setBackgroundColor(Color.parseColor((String)colour));
        return this;
    }

    public MaterialScrollBar setHandleColour(int colour) {
        this.handle.setBackgroundColor(colour);
        return this;
    }

    public MaterialScrollBar setBarColour(String colour) {
        this.background.setBackgroundColor(Color.parseColor((String)colour));
        return this;
    }

    public MaterialScrollBar setBarColour(int colour) {
        this.background.setBackgroundColor(colour);
        return this;
    }

    public MaterialScrollBar setAutoHide(Boolean hide) {
        if (!hide.booleanValue()) {
            this.fade.interrupt();
            TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, 0.0f, 2, 0.0f, 2, 0.0f);
            anim.setFillAfter(true);
            this.startAnimation((Animation)anim);
        } else if (!this.hide) {
            this.fade.start();
        }
        this.hide = hide;
        return this;
    }

    @TargetApi(value=21)
    private int fetchAccentColor(Context context) {
        TypedValue typedValue = new TypedValue();
        TypedArray a = context.obtainStyledAttributes(typedValue.data, new int[]{16843829});
        int color2 = a.getColor(0, 0);
        a.recycle();
        return color2;
    }

    private class ScrollListener
    extends RecyclerView.OnScrollListener {
        MaterialScrollBar materialScrollBar;

        protected ScrollListener(MaterialScrollBar msb) {
            this.materialScrollBar = msb;
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            ViewHelper.setY((View)MaterialScrollBar.this.handle, (float)(this.calculateScrollProgress(recyclerView) * (float)(this.materialScrollBar.getHeight() - MaterialScrollBar.this.handle.getHeight())));
        }

        public float calculateScrollProgress(RecyclerView recyclerView) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
            int lastFullyVisiblePosition = layoutManager.findLastCompletelyVisibleItemPosition();
            View visibleChild = recyclerView.getChildAt(0);
            if (visibleChild == null) {
                return 0.0f;
            }
            RecyclerView.ViewHolder holder = recyclerView.getChildViewHolder(visibleChild);
            int itemHeight = holder.itemView.getHeight();
            int recyclerHeight = recyclerView.getHeight();
            int itemsInWindow = recyclerHeight / itemHeight;
            int numItemsInList = recyclerView.getAdapter().getItemCount();
            int numScrollableSectionsInList = numItemsInList - itemsInWindow;
            int indexOfLastFullyVisibleItemInFirstSection = numItemsInList - numScrollableSectionsInList - 1;
            int currentSection = lastFullyVisiblePosition - indexOfLastFullyVisibleItemInFirstSection;
            return (float)currentSection / (float)numScrollableSectionsInList;
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            if (MaterialScrollBar.this.hide) {
                if (newState == 0) {
                    MaterialScrollBar.this.fade.time = System.currentTimeMillis() + (long)MaterialScrollBar.this.hideDuration;
                    MaterialScrollBar.this.fade.run = true;
                } else if (newState == 1) {
                    MaterialScrollBar.this.fade.run = false;
                    if (MaterialScrollBar.this.hidden) {
                        MaterialScrollBar.this.hidden = false;
                        TranslateAnimation anim = new TranslateAnimation(1, 1.0f, 1, 0.0f, 2, 0.0f, 2, 0.0f);
                        anim.setDuration(500L);
                        anim.setFillAfter(true);
                        this.materialScrollBar.startAnimation((Animation)anim);
                    }
                }
            }
        }
    }

    class BarFade
    extends Thread {
        MaterialScrollBar materialScrollBar;
        long time = 0L;
        boolean run = false;

        BarFade(MaterialScrollBar msb) {
            this.materialScrollBar = msb;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (this.time <= System.currentTimeMillis() && this.run) {
                        this.run = false;
                        this.materialScrollBar.a.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                TranslateAnimation anim = new TranslateAnimation(2, 0.0f, 1, 1.0f, 2, 0.0f, 2, 0.0f);
                                anim.setDuration(500L);
                                anim.setFillAfter(true);
                                MaterialScrollBar.this.hidden = true;
                                BarFade.this.materialScrollBar.startAnimation((Animation)anim);
                            }
                        });
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

