/*
 * Decompiled with CFR 0.152.
 */
package com.sharejoys.crashlib.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.util.Log;
import android.widget.Toast;
import com.sharejoys.crashlib.CrashManager;
import com.sharejoys.crashlib.util.CrashFileHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class CrashHelper {
    private static String defaultDir;
    private static String versionName;
    private static int versionCode;
    private static final String FILE_SEP;
    @SuppressLint(value={"SimpleDateFormat"})
    private static final Format FORMAT;
    private static final String LOG_ZIP_FILE_PATH;

    public static void init() {
        defaultDir = CrashHelper.getDefaultCrashDir();
    }

    private CrashHelper() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String buildCrashInfo(Throwable e) {
        StringBuilder sb = new StringBuilder();
        String time = FORMAT.format(new Date(System.currentTimeMillis()));
        String head = "************* Log Head ****************\nTime Of Crash      : " + time + "\nDevice Manufacturer: " + Build.MANUFACTURER + "\nDevice Model       : " + Build.MODEL + "\nAndroid Version    : " + Build.VERSION.RELEASE + "\nAndroid SDK        : " + Build.VERSION.SDK_INT + "\nApp VersionName    : " + versionName + "\nApp VersionCode    : " + versionCode + "\n************* Log Head ****************\n\n";
        sb.append(head);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(pw);
        }
        pw.flush();
        sb.append(sw.toString());
        return sb.toString();
    }

    public static void saveCrashLogToLocal(String crashInfo) {
        String time = FORMAT.format(new Date(System.currentTimeMillis()));
        String fullPath = defaultDir + time + ".txt";
        if (CrashHelper.createOrExistsFile(fullPath)) {
            CrashHelper.input2File(crashInfo, fullPath);
        } else {
            Log.e((String)"CrashHelper", (String)("create " + fullPath + " failed!"));
        }
    }

    private static String getDefaultCrashDir() {
        if ("mounted".equals(Environment.getExternalStorageState()) && CrashManager.getInstance().getApplication().getExternalCacheDir() != null) {
            return CrashManager.getInstance().getApplication().getExternalCacheDir() + FILE_SEP + "crash_log" + FILE_SEP;
        }
        return CrashManager.getInstance().getApplication().getCacheDir() + FILE_SEP + "crash_log" + FILE_SEP;
    }

    private static void input2File(final String input, final String filePath) {
        Future<Boolean> submit = Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                BufferedWriter bw = null;
                try {
                    bw = new BufferedWriter(new FileWriter(filePath, true));
                    bw.write(input);
                    CrashHelper.onClearFile();
                    Boolean bl = true;
                    return bl;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        try {
            if (submit.get().booleanValue()) {
                return;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        Log.e((String)"CrashHelper", (String)("write crash info to " + filePath + " failed!"));
    }

    private static boolean createOrExistsFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.isFile();
        }
        if (!CrashHelper.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static void onClearFile() {
        File file;
        if (Environment.getExternalStorageState().equals("mounted") && (file = new File(CrashHelper.getDefaultCrashDir())).exists() && file.listFiles().length > 3) {
            int index = 0;
            for (File temp : file.listFiles()) {
                long time = System.currentTimeMillis() - temp.lastModified();
                if (time / 1000L > 172800L) {
                    temp.delete();
                    ++index;
                }
                if (index >= file.listFiles().length - 3) break;
            }
        }
    }

    public static void shareCrashFile(Activity activity) {
        File logPath = new File(CrashHelper.getDefaultCrashDir());
        if (!logPath.exists() || logPath.listFiles() == null || logPath.listFiles().length == 0) {
            Toast.makeText((Context)activity, (CharSequence)"\u6ca1\u6709\u5d29\u6e83\u65e5\u5fd7\u53ef\u4ee5\u53cd\u9988", (int)0).show();
            return;
        }
        if (logPath.listFiles().length == 1) {
            Uri uri = CrashFileHelper.getUri((Context)activity, logPath.listFiles()[0]);
            CrashHelper.shareFile(activity, uri, "text/plain");
        } else {
            CrashFileHelper.zipFiles(logPath.listFiles(), LOG_ZIP_FILE_PATH);
            Uri uri = CrashFileHelper.getUri((Context)activity, new File(LOG_ZIP_FILE_PATH));
            CrashHelper.shareFile(activity, uri, "application/zip");
        }
    }

    private static void shareFile(Activity activity, Uri fileUri, String fileType) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.addFlags(0x10000000);
        intent.addFlags(1);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)fileUri);
        intent.setType(fileType);
        try {
            activity.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        FILE_SEP = System.getProperty("file.separator");
        FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss");
        try {
            PackageInfo pi = CrashManager.getInstance().getApplication().getPackageManager().getPackageInfo(CrashManager.getInstance().getApplication().getPackageName(), 0);
            if (pi != null) {
                versionName = pi.versionName;
                versionCode = pi.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        LOG_ZIP_FILE_PATH = CrashHelper.getDefaultCrashDir() + File.separator + "crash_log.zip";
    }
}

