/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.filters;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.filter.BaseFilter;
import com.otaliastudios.cameraview.filter.OneParameterFilter;
import com.otaliastudios.opengl.core.Egloo;

public class SharpnessFilter
extends BaseFilter
implements OneParameterFilter {
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nuniform float scale;\nuniform float stepsizeX;\nuniform float stepsizeY;\nvarying vec2 vTextureCoord;\nvoid main() {\n  vec3 nbr_color = vec3(0.0, 0.0, 0.0);\n  vec2 coord;\n  vec4 color = texture2D(sTexture, vTextureCoord);\n  coord.x = vTextureCoord.x - 0.5 * stepsizeX;\n  coord.y = vTextureCoord.y - stepsizeY;\n  nbr_color += texture2D(sTexture, coord).rgb - color.rgb;\n  coord.x = vTextureCoord.x - stepsizeX;\n  coord.y = vTextureCoord.y + 0.5 * stepsizeY;\n  nbr_color += texture2D(sTexture, coord).rgb - color.rgb;\n  coord.x = vTextureCoord.x + stepsizeX;\n  coord.y = vTextureCoord.y - 0.5 * stepsizeY;\n  nbr_color += texture2D(sTexture, coord).rgb - color.rgb;\n  coord.x = vTextureCoord.x + stepsizeX;\n  coord.y = vTextureCoord.y + 0.5 * stepsizeY;\n  nbr_color += texture2D(sTexture, coord).rgb - color.rgb;\n  gl_FragColor = vec4(color.rgb - 2.0 * scale * nbr_color, color.a);\n}\n";
    private float scale = 0.5f;
    private int width = 1;
    private int height = 1;
    private int scaleLocation = -1;
    private int stepSizeXLocation = -1;
    private int stepSizeYLocation = -1;

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.width = width;
        this.height = height;
    }

    public void setSharpness(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        this.scale = value;
    }

    public float getSharpness() {
        return this.scale;
    }

    @Override
    public void setParameter1(float value) {
        this.setSharpness(value);
    }

    @Override
    public float getParameter1() {
        return this.getSharpness();
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    public void onCreate(int programHandle) {
        super.onCreate(programHandle);
        this.scaleLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"scale");
        Egloo.checkGlProgramLocation((int)this.scaleLocation, (String)"scale");
        this.stepSizeXLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"stepsizeX");
        Egloo.checkGlProgramLocation((int)this.stepSizeXLocation, (String)"stepsizeX");
        this.stepSizeYLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"stepsizeY");
        Egloo.checkGlProgramLocation((int)this.stepSizeYLocation, (String)"stepsizeY");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.scaleLocation = -1;
        this.stepSizeXLocation = -1;
        this.stepSizeYLocation = -1;
    }

    @Override
    protected void onPreDraw(long timestampUs, @NonNull float[] transformMatrix) {
        super.onPreDraw(timestampUs, transformMatrix);
        GLES20.glUniform1f((int)this.scaleLocation, (float)this.scale);
        Egloo.checkGlError((String)"glUniform1f");
        GLES20.glUniform1f((int)this.stepSizeXLocation, (float)(1.0f / (float)this.width));
        Egloo.checkGlError((String)"glUniform1f");
        GLES20.glUniform1f((int)this.stepSizeYLocation, (float)(1.0f / (float)this.height));
        Egloo.checkGlError((String)"glUniform1f");
    }
}

