/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.options;

import android.hardware.Camera;
import android.media.CamcorderProfile;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.controls.Flash;
import com.otaliastudios.cameraview.controls.Hdr;
import com.otaliastudios.cameraview.controls.PictureFormat;
import com.otaliastudios.cameraview.engine.mappers.Camera1Mapper;
import com.otaliastudios.cameraview.internal.CamcorderProfiles;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.Size;
import java.util.List;

public class Camera1Options
extends CameraOptions {
    public Camera1Options(@NonNull Camera.Parameters params, int cameraId, boolean flipSizes) {
        Object value;
        Camera1Mapper mapper = Camera1Mapper.get();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            value = mapper.unmapFacing(cameraInfo.facing);
            if (value == null) continue;
            this.supportedFacing.add(value);
        }
        List strings = params.getSupportedWhiteBalance();
        if (strings != null) {
            for (String string : strings) {
                value = mapper.unmapWhiteBalance(string);
                if (value == null) continue;
                this.supportedWhiteBalance.add(value);
            }
        }
        this.supportedFlash.add(Flash.OFF);
        strings = params.getSupportedFlashModes();
        if (strings != null) {
            for (String string : strings) {
                value = mapper.unmapFlash(string);
                if (value == null) continue;
                this.supportedFlash.add(value);
            }
        }
        this.supportedHdr.add(Hdr.OFF);
        strings = params.getSupportedSceneModes();
        if (strings != null) {
            for (String string : strings) {
                value = mapper.unmapHdr(string);
                if (value == null) continue;
                this.supportedHdr.add(value);
            }
        }
        this.zoomSupported = params.isZoomSupported();
        this.autoFocusSupported = params.getSupportedFocusModes().contains("auto");
        float step = params.getExposureCompensationStep();
        this.exposureCorrectionMinValue = (float)params.getMinExposureCompensation() * step;
        this.exposureCorrectionMaxValue = (float)params.getMaxExposureCompensation() * step;
        this.exposureCorrectionSupported = params.getMinExposureCompensation() != 0 || params.getMaxExposureCompensation() != 0;
        List sizes = params.getSupportedPictureSizes();
        for (Camera.Size size : sizes) {
            int width = flipSizes ? size.height : size.width;
            int height = flipSizes ? size.width : size.height;
            this.supportedPictureSizes.add(new Size(width, height));
            this.supportedPictureAspectRatio.add(AspectRatio.of(width, height));
        }
        CamcorderProfile profile = CamcorderProfiles.get(cameraId, new Size(Integer.MAX_VALUE, Integer.MAX_VALUE));
        Size videoMaxSize = new Size(profile.videoFrameWidth, profile.videoFrameHeight);
        List vsizes = params.getSupportedVideoSizes();
        if (vsizes != null) {
            for (Camera.Size size : vsizes) {
                if (size.width > videoMaxSize.getWidth() || size.height > videoMaxSize.getHeight()) continue;
                int width = flipSizes ? size.height : size.width;
                int height = flipSizes ? size.width : size.height;
                this.supportedVideoSizes.add(new Size(width, height));
                this.supportedVideoAspectRatio.add(AspectRatio.of(width, height));
            }
        } else {
            List fallback = params.getSupportedPreviewSizes();
            for (Camera.Size size : fallback) {
                if (size.width > videoMaxSize.getWidth() || size.height > videoMaxSize.getHeight()) continue;
                int width = flipSizes ? size.height : size.width;
                int height = flipSizes ? size.width : size.height;
                this.supportedVideoSizes.add(new Size(width, height));
                this.supportedVideoAspectRatio.add(AspectRatio.of(width, height));
            }
        }
        this.previewFrameRateMinValue = Float.MAX_VALUE;
        this.previewFrameRateMaxValue = -3.4028235E38f;
        List fpsRanges = params.getSupportedPreviewFpsRange();
        for (int[] fpsRange : fpsRanges) {
            float lower = (float)fpsRange[0] / 1000.0f;
            float upper = (float)fpsRange[1] / 1000.0f;
            this.previewFrameRateMinValue = Math.min(this.previewFrameRateMinValue, lower);
            this.previewFrameRateMaxValue = Math.max(this.previewFrameRateMaxValue, upper);
        }
        this.supportedPictureFormats.add(PictureFormat.JPEG);
        this.supportedFrameProcessingFormats.add(17);
    }
}

