/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.offset;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.engine.offset.Axis;
import com.otaliastudios.cameraview.engine.offset.Reference;

public class Angles {
    private static final String TAG = Angles.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private Facing mSensorFacing;
    @VisibleForTesting
    int mSensorOffset = 0;
    @VisibleForTesting
    int mDisplayOffset = 0;
    @VisibleForTesting
    int mDeviceOrientation = 0;

    public void setSensorOffset(@NonNull Facing sensorFacing, int sensorOffset) {
        this.sanitizeInput(sensorOffset);
        this.mSensorFacing = sensorFacing;
        this.mSensorOffset = sensorOffset;
        if (this.mSensorFacing == Facing.FRONT) {
            this.mSensorOffset = this.sanitizeOutput(360 - this.mSensorOffset);
        }
        this.print();
    }

    public void setDisplayOffset(int displayOffset) {
        this.sanitizeInput(displayOffset);
        this.mDisplayOffset = displayOffset;
        this.print();
    }

    public void setDeviceOrientation(int deviceOrientation) {
        this.sanitizeInput(deviceOrientation);
        this.mDeviceOrientation = deviceOrientation;
        this.print();
    }

    private void print() {
        LOG.i("Angles changed:", "sensorOffset:", this.mSensorOffset, "displayOffset:", this.mDisplayOffset, "deviceOrientation:", this.mDeviceOrientation);
    }

    public int offset(@NonNull Reference from, @NonNull Reference to, @NonNull Axis axis) {
        int offset = this.absoluteOffset(from, to);
        if (axis == Axis.RELATIVE_TO_SENSOR && this.mSensorFacing == Facing.FRONT) {
            offset = this.sanitizeOutput(360 - offset);
        }
        return offset;
    }

    private int absoluteOffset(@NonNull Reference from, @NonNull Reference to) {
        if (from == to) {
            return 0;
        }
        if (to == Reference.BASE) {
            return this.sanitizeOutput(360 - this.absoluteOffset(to, from));
        }
        if (from == Reference.BASE) {
            switch (to) {
                case VIEW: {
                    return this.sanitizeOutput(360 - this.mDisplayOffset);
                }
                case OUTPUT: {
                    return this.sanitizeOutput(this.mDeviceOrientation);
                }
                case SENSOR: {
                    return this.sanitizeOutput(360 - this.mSensorOffset);
                }
            }
            throw new RuntimeException("Unknown reference: " + (Object)((Object)to));
        }
        return this.sanitizeOutput(this.absoluteOffset(Reference.BASE, to) - this.absoluteOffset(Reference.BASE, from));
    }

    public boolean flip(@NonNull Reference from, @NonNull Reference to) {
        return this.offset(from, to, Axis.ABSOLUTE) % 180 != 0;
    }

    private void sanitizeInput(int value) {
        if (value != 0 && value != 90 && value != 180 && value != 270) {
            throw new IllegalStateException("This value is not sanitized: " + value);
        }
    }

    private int sanitizeOutput(int value) {
        return (value + 360) % 360;
    }
}

