/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class CameraLogger {
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_ERROR = 3;
    @VisibleForTesting
    static String lastMessage;
    @VisibleForTesting
    static String lastTag;
    private static int sLevel;
    private static Set<Logger> sLoggers;
    @VisibleForTesting
    static Logger sAndroidLogger;
    @NonNull
    private String mTag;

    public static CameraLogger create(@NonNull String tag) {
        return new CameraLogger(tag);
    }

    public static void setLogLevel(int logLevel) {
        sLevel = logLevel;
    }

    public static void registerLogger(@NonNull Logger logger) {
        sLoggers.add(logger);
    }

    public static void unregisterLogger(@NonNull Logger logger) {
        sLoggers.remove(logger);
    }

    private CameraLogger(@NonNull String tag) {
        this.mTag = tag;
    }

    private boolean should(int messageLevel) {
        return sLevel <= messageLevel && sLoggers.size() > 0;
    }

    @Nullable
    public String v(Object ... data) {
        return this.log(0, data);
    }

    @Nullable
    public String i(Object ... data) {
        return this.log(1, data);
    }

    @Nullable
    public String w(Object ... data) {
        return this.log(2, data);
    }

    @Nullable
    public String e(Object ... data) {
        return this.log(3, data);
    }

    @Nullable
    private String log(int level, Object ... data) {
        if (!this.should(level)) {
            return null;
        }
        StringBuilder message = new StringBuilder();
        Throwable throwable = null;
        for (Object object : data) {
            if (object instanceof Throwable) {
                throwable = (Throwable)object;
            }
            message.append(String.valueOf(object));
            message.append(" ");
        }
        String string = message.toString().trim();
        for (Logger logger : sLoggers) {
            logger.log(level, this.mTag, string, throwable);
        }
        lastMessage = string;
        lastTag = this.mTag;
        return string;
    }

    static {
        sLoggers = new CopyOnWriteArraySet<Logger>();
        sAndroidLogger = new Logger(){

            @Override
            public void log(int level, @NonNull String tag, @NonNull String message, @Nullable Throwable throwable) {
                switch (level) {
                    case 0: {
                        Log.v((String)tag, (String)message, (Throwable)throwable);
                        break;
                    }
                    case 1: {
                        Log.i((String)tag, (String)message, (Throwable)throwable);
                        break;
                    }
                    case 2: {
                        Log.w((String)tag, (String)message, (Throwable)throwable);
                        break;
                    }
                    case 3: {
                        Log.e((String)tag, (String)message, (Throwable)throwable);
                    }
                }
            }
        };
        CameraLogger.setLogLevel(3);
        sLoggers.add(sAndroidLogger);
    }

    public static interface Logger {
        public void log(int var1, @NonNull String var2, @NonNull String var3, @Nullable Throwable var4);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogLevel {
    }
}

