/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.stats;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import java.util.concurrent.atomic.AtomicLong;

public class TrafficStats {
    public static final TrafficStatHandler tcp = new TrafficStatHandler();
    public static final TrafficStatHandler udp = new TrafficStatHandler();

    @ChannelHandler.Sharable
    static class TrafficStatHandler
    extends ChannelDuplexHandler {
        private AtomicLong outSize = new AtomicLong();
        private AtomicLong inSize = new AtomicLong();
        private AtomicLong outPackets = new AtomicLong();
        private AtomicLong inPackets = new AtomicLong();

        TrafficStatHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.inPackets.incrementAndGet();
            if (msg instanceof ByteBuf) {
                this.inSize.addAndGet(((ByteBuf)msg).readableBytes());
            } else if (msg instanceof DatagramPacket) {
                this.inSize.addAndGet(((ByteBuf)((DatagramPacket)msg).content()).readableBytes());
            }
            super.channelRead(ctx, msg);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            this.outPackets.incrementAndGet();
            if (msg instanceof ByteBuf) {
                this.outSize.addAndGet(((ByteBuf)msg).readableBytes());
            } else if (msg instanceof DatagramPacket) {
                this.outSize.addAndGet(((ByteBuf)((DatagramPacket)msg).content()).readableBytes());
            }
            super.write(ctx, msg, promise);
        }

        public AtomicLong getOutSize() {
            return this.outSize;
        }

        public AtomicLong getInSize() {
            return this.inSize;
        }

        public AtomicLong getOutPackets() {
            return this.outPackets;
        }

        public AtomicLong getInPackets() {
            return this.inPackets;
        }
    }
}

