/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.example;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.tron.p2p.P2pConfig;
import org.tron.p2p.P2pEventHandler;
import org.tron.p2p.P2pService;
import org.tron.p2p.connection.Channel;
import org.tron.p2p.discover.Node;
import org.tron.p2p.exception.P2pException;
import org.tron.p2p.stats.P2pStats;
import org.tron.p2p.utils.ByteArray;

public class ImportUsing {
    private P2pService p2pService = new P2pService();
    private Map<InetSocketAddress, Channel> channels = new ConcurrentHashMap<InetSocketAddress, Channel>();

    public void startP2pService() {
        P2pConfig config = new P2pConfig();
        this.initConfig(config);
        MyP2pEventHandler myP2pEventHandler = new MyP2pEventHandler();
        try {
            this.p2pService.register(myP2pEventHandler);
        }
        catch (P2pException p2pException) {
            // empty catch block
        }
        this.p2pService.start(config);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        TestMessage testMessage = new TestMessage(ByteArray.fromString("hello"));
        for (Channel channel : this.channels.values()) {
            channel.send(ByteArray.fromObject(testMessage));
        }
        for (Channel channel : this.channels.values()) {
            channel.close();
        }
    }

    public void closeP2pService() {
        this.p2pService.close();
    }

    public void connect(InetSocketAddress address) {
        this.p2pService.connect(address);
    }

    public P2pStats getP2pStats() {
        return this.p2pService.getP2pStats();
    }

    public List<Node> getAllNodes() {
        return this.p2pService.getAllNodes();
    }

    public List<Node> getTableNodes() {
        return this.p2pService.getTableNodes();
    }

    public List<Node> getConnectableNodes() {
        return this.p2pService.getConnectableNodes();
    }

    private void initConfig(P2pConfig config) {
        config.setNetworkId(11111);
        config.setPort(18888);
        config.setDiscoverEnable(true);
        ArrayList<InetSocketAddress> seedNodeList = new ArrayList<InetSocketAddress>();
        seedNodeList.add(new InetSocketAddress("13.124.62.58", 18888));
        seedNodeList.add(new InetSocketAddress("2600:1f13:908:1b00:e1fd:5a84:251c:a32a", 18888));
        seedNodeList.add(new InetSocketAddress("127.0.0.4", 18888));
        config.setSeedNodes(seedNodeList);
        ArrayList<InetSocketAddress> activeNodeList = new ArrayList<InetSocketAddress>();
        activeNodeList.add(new InetSocketAddress("127.0.0.2", 18888));
        activeNodeList.add(new InetSocketAddress("127.0.0.3", 18888));
        config.setActiveNodes(activeNodeList);
        ArrayList<InetAddress> trustNodeList = new ArrayList<InetAddress>();
        trustNodeList.add(new InetSocketAddress("127.0.0.2", 18888).getAddress());
        config.setTrustNodes(trustNodeList);
        config.setMinConnections(8);
        config.setMinActiveConnections(2);
        config.setMaxConnections(30);
        config.setMaxConnectionsWithSameIp(2);
    }

    private static class TestMessage {
        protected MessageTypes type = MessageTypes.TEST;
        protected byte[] data;

        public TestMessage(byte[] data) {
            this.data = data;
        }
    }

    private static enum MessageTypes {
        FIRST(0),
        TEST(1),
        LAST(-113);

        private final byte type;
        private static final Map<Byte, MessageTypes> map;

        private MessageTypes(byte type) {
            this.type = type;
        }

        public byte getType() {
            return this.type;
        }

        public static MessageTypes fromByte(byte type) {
            return map.get(type);
        }

        static {
            map = new HashMap<Byte, MessageTypes>();
            for (MessageTypes value : MessageTypes.values()) {
                map.put(value.type, value);
            }
        }
    }

    private class MyP2pEventHandler
    extends P2pEventHandler {
        public MyP2pEventHandler() {
            this.messageTypes = new HashSet();
            this.messageTypes.add(MessageTypes.TEST.getType());
        }

        @Override
        public void onConnect(Channel channel) {
            ImportUsing.this.channels.put(channel.getInetSocketAddress(), channel);
        }

        @Override
        public void onDisconnect(Channel channel) {
            ImportUsing.this.channels.remove(channel.getInetSocketAddress());
        }

        @Override
        public void onMessage(Channel channel, byte[] data) {
            byte type = data[0];
            byte[] messageData = ArrayUtils.subarray((byte[])data, (int)1, (int)data.length);
            switch (MessageTypes.fromByte(type)) {
                case TEST: {
                    TestMessage message = new TestMessage(messageData);
                    break;
                }
            }
        }
    }
}

