/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.update;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.dns.DnsNode;
import org.tron.p2p.dns.tree.LinkEntry;
import org.tron.p2p.dns.tree.NodesEntry;
import org.tron.p2p.dns.tree.RootEntry;
import org.tron.p2p.dns.tree.Tree;
import org.tron.p2p.dns.update.Publish;
import org.tron.p2p.exception.DnsException;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.Route53ClientBuilder;
import software.amazon.awssdk.services.route53.model.Change;
import software.amazon.awssdk.services.route53.model.ChangeAction;
import software.amazon.awssdk.services.route53.model.ChangeBatch;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ChangeStatus;
import software.amazon.awssdk.services.route53.model.GetChangeRequest;
import software.amazon.awssdk.services.route53.model.GetChangeResponse;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.ResourceRecord;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;

public class AwsClient
implements Publish {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    public static final int route53ChangeSizeLimit = 32000;
    public static final int route53ChangeCountLimit = 1000;
    public static final int maxRetryLimit = 60;
    private int lastSeq = 0;
    private Route53Client route53Client;
    private String zoneId;
    private Set<DnsNode> serverNodes;
    private static final String symbol = "\"";
    private static final String postfix = ".";
    private double changeThreshold;

    public AwsClient(final String accessKey, final String accessKeySecret, String zoneId, String region, double changeThreshold) throws DnsException {
        if (StringUtils.isEmpty((CharSequence)accessKey) || StringUtils.isEmpty((CharSequence)accessKeySecret)) {
            throw new DnsException(DnsException.TypeEnum.DEPLOY_DOMAIN_FAILED, "Need Route53 Access Key ID and secret to proceed");
        }
        StaticCredentialsProvider staticCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)new AwsCredentials(){

            public String accessKeyId() {
                return accessKey;
            }

            public String secretAccessKey() {
                return accessKeySecret;
            }
        });
        this.route53Client = (Route53Client)((Route53ClientBuilder)((Route53ClientBuilder)Route53Client.builder().credentialsProvider((AwsCredentialsProvider)staticCredentialsProvider)).region(Region.of((String)region))).build();
        this.zoneId = zoneId;
        this.serverNodes = new HashSet<DnsNode>();
        this.changeThreshold = changeThreshold;
    }

    private void checkZone(String domain) {
        if (StringUtils.isEmpty((CharSequence)this.zoneId)) {
            this.zoneId = this.findZoneID(domain);
        }
    }

    private String findZoneID(String domain) {
        log.info("Finding Route53 Zone ID for {}", (Object)domain);
        ListHostedZonesByNameRequest.Builder request = ListHostedZonesByNameRequest.builder();
        while (true) {
            ListHostedZonesByNameResponse response = this.route53Client.listHostedZonesByName((ListHostedZonesByNameRequest)request.build());
            for (HostedZone hostedZone : response.hostedZones()) {
                if (!AwsClient.isSubdomain(domain, hostedZone.name())) continue;
                return hostedZone.id().split("/")[2];
            }
            if (Boolean.FALSE.equals(response.isTruncated())) break;
            request.dnsName(response.dnsName());
            request.hostedZoneId(response.nextHostedZoneId());
        }
        return null;
    }

    @Override
    public void testConnect() throws Exception {
        ListHostedZonesByNameResponse response;
        ListHostedZonesByNameRequest.Builder request = ListHostedZonesByNameRequest.builder();
        while (!Boolean.FALSE.equals((response = this.route53Client.listHostedZonesByName((ListHostedZonesByNameRequest)request.build())).isTruncated())) {
            request.dnsName(response.dnsName());
            request.hostedZoneId(response.nextHostedZoneId());
        }
    }

    @Override
    public void deploy(String domain, Tree tree) throws Exception {
        this.checkZone(domain);
        Map<String, RecordSet> existing = this.collectRecords(domain);
        log.info("Find {} TXT records, {} nodes for {}", new Object[]{existing.size(), this.serverNodes.size(), domain});
        String represent = LinkEntry.buildRepresent(tree.getBase32PublicKey(), domain);
        log.info("Trying to publish {}", (Object)represent);
        tree.setSeq(this.lastSeq + 1);
        tree.sign();
        Map<String, String> records = tree.toTXT(domain);
        List<Change> changes = this.computeChanges(domain, records, existing);
        HashSet<DnsNode> treeNodes = new HashSet<DnsNode>(tree.getDnsNodes());
        treeNodes.removeAll(this.serverNodes);
        int addNodeSize = treeNodes.size();
        HashSet<DnsNode> set1 = new HashSet<DnsNode>(this.serverNodes);
        treeNodes = new HashSet<DnsNode>(tree.getDnsNodes());
        set1.removeAll(treeNodes);
        int deleteNodeSize = set1.size();
        if (this.serverNodes.isEmpty() || (double)(addNodeSize + deleteNodeSize) / (double)this.serverNodes.size() >= this.changeThreshold) {
            String comment = String.format("Tree update of %s at seq %d", domain, tree.getSeq());
            log.info(comment);
            this.submitChanges(changes, comment);
        } else {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(4);
            double changePercent = (double)(addNodeSize + deleteNodeSize) / (double)this.serverNodes.size();
            log.info("Sum of node add & delete percent {} is below changeThreshold {}, skip this changes", (Object)nf.format(changePercent), (Object)this.changeThreshold);
        }
        this.serverNodes.clear();
    }

    @Override
    public boolean deleteDomain(String rootDomain) throws Exception {
        this.checkZone(rootDomain);
        Map<String, RecordSet> existing = this.collectRecords(rootDomain);
        log.info("Find {} TXT records for {}", (Object)existing.size(), (Object)rootDomain);
        List<Change> changes = this.makeDeletionChanges(new HashMap<String, String>(), existing);
        String comment = String.format("delete entree of %s", rootDomain);
        this.submitChanges(changes, comment);
        return true;
    }

    public Map<String, RecordSet> collectRecords(String rootDomain) throws Exception {
        HashMap<String, RecordSet> existing = new HashMap<String, RecordSet>();
        ListResourceRecordSetsRequest.Builder request = ListResourceRecordSetsRequest.builder();
        request.hostedZoneId(this.zoneId);
        int page = 0;
        String rootContent = null;
        HashSet<DnsNode> collectServerNodes = new HashSet<DnsNode>();
        while (true) {
            log.info("Loading existing TXT records from name:{} zoneId:{} page:{}", new Object[]{rootDomain, this.zoneId, page});
            ListResourceRecordSetsResponse response = this.route53Client.listResourceRecordSets((ListResourceRecordSetsRequest)request.build());
            List recordSetList = response.resourceRecordSets();
            for (ResourceRecordSet resourceRecordSet : recordSetList) {
                if (!AwsClient.isSubdomain(resourceRecordSet.name(), rootDomain) || resourceRecordSet.type() != RRType.TXT) continue;
                ArrayList<String> values = new ArrayList<String>();
                for (ResourceRecord resourceRecord : resourceRecordSet.resourceRecords()) {
                    values.add(resourceRecord.value());
                }
                RecordSet recordSet = new RecordSet(values.toArray(new String[0]), resourceRecordSet.ttl());
                String name = StringUtils.stripEnd((String)resourceRecordSet.name(), (String)postfix);
                existing.put(name, recordSet);
                String content = StringUtils.join(values, (String)"");
                content = StringUtils.strip((String)content, (String)symbol);
                if (rootDomain.equalsIgnoreCase(name)) {
                    rootContent = content;
                }
                if (content.startsWith("nodes:")) {
                    try {
                        NodesEntry nodesEntry = NodesEntry.parseEntry(content);
                        List<DnsNode> dnsNodes = nodesEntry.getNodes();
                        collectServerNodes.addAll(dnsNodes);
                    }
                    catch (DnsException e) {
                        log.error("Parse nodeEntry failed: {}", (Object)e.getMessage());
                    }
                }
                log.info("Find name: {}", (Object)name);
            }
            if (Boolean.FALSE.equals(response.isTruncated())) break;
            request.startRecordIdentifier(response.nextRecordIdentifier());
            request.startRecordName(response.nextRecordName());
            request.startRecordType(response.nextRecordType());
            ++page;
        }
        if (rootContent != null) {
            RootEntry rootEntry = RootEntry.parseEntry(rootContent);
            this.lastSeq = rootEntry.getSeq();
        }
        this.serverNodes = collectServerNodes;
        return existing;
    }

    public void submitChanges(List<Change> changes, String comment) {
        if (changes.isEmpty()) {
            log.info("No DNS changes needed");
            return;
        }
        List<List<Change>> batchChanges = AwsClient.splitChanges(changes, 32000, 1000);
        ChangeResourceRecordSetsResponse[] responses = new ChangeResourceRecordSetsResponse[batchChanges.size()];
        for (int i = 0; i < batchChanges.size(); ++i) {
            log.info("Submit {}/{} changes to Route53", (Object)(i + 1), (Object)batchChanges.size());
            ChangeBatch.Builder builder = ChangeBatch.builder();
            builder.changes((Collection)batchChanges.get(i));
            builder.comment(comment + String.format(" (%d/%d)", i + 1, batchChanges.size()));
            ChangeResourceRecordSetsRequest.Builder request = ChangeResourceRecordSetsRequest.builder();
            request.changeBatch((ChangeBatch)builder.build());
            request.hostedZoneId(this.zoneId);
            responses[i] = this.route53Client.changeResourceRecordSets((ChangeResourceRecordSetsRequest)request.build());
        }
        for (ChangeResourceRecordSetsResponse response : responses) {
            GetChangeResponse changeResponse;
            log.info("Waiting for change request {}", (Object)response.changeInfo().id());
            GetChangeRequest.Builder request = GetChangeRequest.builder();
            request.id(response.changeInfo().id());
            int count = 0;
            while ((changeResponse = this.route53Client.getChange((GetChangeRequest)request.build())).changeInfo().status() != ChangeStatus.INSYNC && ++count < 60) {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        log.info("Submit {} changes complete", (Object)changes.size());
    }

    public List<Change> computeChanges(String domain, Map<String, String> records, Map<String, RecordSet> existing) {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Map.Entry<String, String> entry : records.entrySet()) {
            long ttl;
            String path = entry.getKey();
            String value = entry.getValue();
            String newValue = this.splitTxt(value);
            long l = ttl = path.equalsIgnoreCase(domain) ? 600L : 604800L;
            if (!existing.containsKey(path)) {
                log.info("Create {} = {}", (Object)path, (Object)value);
                Change change = this.newTXTChange(ChangeAction.CREATE, path, ttl, newValue);
                changes.add(change);
                continue;
            }
            RecordSet recordSet = existing.get(path);
            String preValue = StringUtils.join((Object[])recordSet.values, (String)"");
            if (preValue.equalsIgnoreCase(newValue) && recordSet.ttl == ttl) continue;
            log.info("Updating {} from [{}] to [{}]", new Object[]{path, preValue, newValue});
            if (path.equalsIgnoreCase(domain)) {
                try {
                    RootEntry oldRoot = RootEntry.parseEntry(StringUtils.strip((String)preValue, (String)symbol));
                    RootEntry newRoot = RootEntry.parseEntry(StringUtils.strip((String)newValue, (String)symbol));
                    log.info("Updating root from [{}] to [{}]", (Object)oldRoot.getDnsRoot(), (Object)newRoot.getDnsRoot());
                }
                catch (DnsException oldRoot) {
                    // empty catch block
                }
            }
            Change change = this.newTXTChange(ChangeAction.UPSERT, path, ttl, newValue);
            changes.add(change);
        }
        List<Change> deleteChanges = this.makeDeletionChanges(records, existing);
        changes.addAll(deleteChanges);
        AwsClient.sortChanges(changes);
        return changes;
    }

    public List<Change> makeDeletionChanges(Map<String, String> keeps, Map<String, RecordSet> existing) {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Map.Entry<String, RecordSet> entry : existing.entrySet()) {
            String path = entry.getKey();
            RecordSet recordSet = entry.getValue();
            if (keeps.containsKey(path)) continue;
            log.info("Delete {} = {}", (Object)path, (Object)StringUtils.join((Object[])existing.get((Object)path).values, (String)""));
            Change change = this.newTXTChange(ChangeAction.DELETE, path, recordSet.ttl, recordSet.values);
            changes.add(change);
        }
        return changes;
    }

    public static void sortChanges(List<Change> changes) {
        changes.sort((o1, o2) -> {
            if (AwsClient.getChangeOrder(o1) == AwsClient.getChangeOrder(o2)) {
                return o1.resourceRecordSet().name().compareTo(o2.resourceRecordSet().name());
            }
            return AwsClient.getChangeOrder(o1) - AwsClient.getChangeOrder(o2);
        });
    }

    private static int getChangeOrder(Change change) {
        switch (change.action()) {
            case CREATE: {
                return 1;
            }
            case UPSERT: {
                return 2;
            }
            case DELETE: {
                return 3;
            }
        }
        return 4;
    }

    private static List<List<Change>> splitChanges(List<Change> changes, int sizeLimit, int countLimit) {
        ArrayList<List<Change>> batchChanges = new ArrayList<List<Change>>();
        ArrayList<Change> subChanges = new ArrayList<Change>();
        int batchSize = 0;
        int batchCount = 0;
        for (Change change : changes) {
            int changeCount = AwsClient.getChangeCount(change);
            int changeSize = AwsClient.getChangeSize(change) * changeCount;
            if (batchCount + changeCount <= countLimit && batchSize + changeSize <= sizeLimit) {
                subChanges.add(change);
                batchCount += changeCount;
                batchSize += changeSize;
                continue;
            }
            batchChanges.add(subChanges);
            subChanges = new ArrayList();
            subChanges.add(change);
            batchSize = changeSize;
            batchCount = changeCount;
        }
        if (!subChanges.isEmpty()) {
            batchChanges.add(subChanges);
        }
        return batchChanges;
    }

    private static int getChangeSize(Change change) {
        int dataSize = 0;
        for (ResourceRecord resourceRecord : change.resourceRecordSet().resourceRecords()) {
            dataSize += resourceRecord.value().length();
        }
        return dataSize;
    }

    private static int getChangeCount(Change change) {
        if (change.action() == ChangeAction.UPSERT) {
            return 2;
        }
        return 1;
    }

    public static boolean isSameChange(Change c1, Change c2) {
        boolean isSame;
        boolean bl = isSame = c1.action().equals((Object)c2.action()) && c1.resourceRecordSet().ttl().longValue() == c2.resourceRecordSet().ttl().longValue() && c1.resourceRecordSet().name().equals(c2.resourceRecordSet().name()) && c1.resourceRecordSet().resourceRecords().size() == c2.resourceRecordSet().resourceRecords().size();
        if (!isSame) {
            return false;
        }
        List list1 = c1.resourceRecordSet().resourceRecords();
        List list2 = c2.resourceRecordSet().resourceRecords();
        for (int i = 0; i < list1.size(); ++i) {
            if (((ResourceRecord)list1.get(i)).equalsBySdkFields(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public Change newTXTChange(ChangeAction action, String key, long ttl, String ... values) {
        ResourceRecordSet.Builder builder = ResourceRecordSet.builder().name(key).type(RRType.TXT).ttl(Long.valueOf(ttl));
        ArrayList<Object> resourceRecords = new ArrayList<Object>();
        for (String value : values) {
            ResourceRecord.Builder builder1 = ResourceRecord.builder();
            builder1.value(value);
            resourceRecords.add(builder1.build());
        }
        builder.resourceRecords(resourceRecords);
        Change.Builder builder2 = Change.builder();
        builder2.action(action);
        builder2.resourceRecordSet((ResourceRecordSet)builder.build());
        return (Change)builder2.build();
    }

    private String splitTxt(String value) {
        StringBuilder sb = new StringBuilder();
        while (value.length() > 253) {
            sb.append(symbol).append(value, 0, 253).append(symbol);
            value = value.substring(253);
        }
        if (value.length() > 0) {
            sb.append(symbol).append(value).append(symbol);
        }
        return sb.toString();
    }

    public static boolean isSubdomain(String sub, String root) {
        String subNoSuffix = postfix + StringUtils.strip((String)sub, (String)postfix);
        String rootNoSuffix = postfix + StringUtils.strip((String)root, (String)postfix);
        return subNoSuffix.endsWith(rootNoSuffix);
    }

    public static class RecordSet {
        String[] values;
        long ttl;

        public RecordSet(String[] values, long ttl) {
            this.values = values;
            this.ttl = ttl;
        }
    }
}

