/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.update;

import com.aliyun.alidns20150109.Client;
import com.aliyun.alidns20150109.models.AddDomainRecordRequest;
import com.aliyun.alidns20150109.models.AddDomainRecordResponse;
import com.aliyun.alidns20150109.models.DeleteDomainRecordRequest;
import com.aliyun.alidns20150109.models.DeleteDomainRecordResponse;
import com.aliyun.alidns20150109.models.DeleteSubDomainRecordsRequest;
import com.aliyun.alidns20150109.models.DeleteSubDomainRecordsResponse;
import com.aliyun.alidns20150109.models.DescribeDomainRecordsRequest;
import com.aliyun.alidns20150109.models.DescribeDomainRecordsResponse;
import com.aliyun.alidns20150109.models.DescribeDomainRecordsResponseBody;
import com.aliyun.alidns20150109.models.UpdateDomainRecordRequest;
import com.aliyun.alidns20150109.models.UpdateDomainRecordResponse;
import com.aliyun.teaopenapi.models.Config;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.dns.DnsNode;
import org.tron.p2p.dns.tree.LinkEntry;
import org.tron.p2p.dns.tree.NodesEntry;
import org.tron.p2p.dns.tree.RootEntry;
import org.tron.p2p.dns.tree.Tree;
import org.tron.p2p.dns.update.Publish;
import org.tron.p2p.exception.DnsException;

public class AliClient
implements Publish {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private final Long domainRecordsPageSize = 20L;
    private final int maxRetryCount = 3;
    private final int successCode = 200;
    private final long retryWaitTime = 30L;
    private final int treeNodeTTL = 86400;
    private int lastSeq = 0;
    private Set<DnsNode> serverNodes;
    private final Client aliDnsClient;
    private double changeThreshold;
    public static final String aliyunRoot = "@";

    public AliClient(String endpoint, String accessKeyId, String accessKeySecret, double changeThreshold) throws Exception {
        Config config = new Config();
        config.accessKeyId = accessKeyId;
        config.accessKeySecret = accessKeySecret;
        config.endpoint = endpoint;
        this.changeThreshold = changeThreshold;
        this.serverNodes = new HashSet<DnsNode>();
        this.aliDnsClient = new Client(config);
    }

    @Override
    public void testConnect() throws Exception {
    }

    @Override
    public void deploy(String domainName, Tree t) throws DnsException {
        try {
            Map<String, DescribeDomainRecordsResponseBody.DescribeDomainRecordsResponseBodyDomainRecordsRecord> existing = this.collectRecords(domainName);
            log.info("Find {} TXT records, {} nodes for {}", new Object[]{existing.size(), this.serverNodes.size(), domainName});
            String represent = LinkEntry.buildRepresent(t.getBase32PublicKey(), domainName);
            log.info("Trying to publish {}", (Object)represent);
            t.setSeq(this.lastSeq + 1);
            t.sign();
            Map<String, String> records = t.toTXT(null);
            HashSet<DnsNode> treeNodes = new HashSet<DnsNode>(t.getDnsNodes());
            treeNodes.removeAll(this.serverNodes);
            int addNodeSize = treeNodes.size();
            HashSet<DnsNode> set1 = new HashSet<DnsNode>(this.serverNodes);
            treeNodes = new HashSet<DnsNode>(t.getDnsNodes());
            set1.removeAll(treeNodes);
            int deleteNodeSize = set1.size();
            if (this.serverNodes.isEmpty() || (double)(addNodeSize + deleteNodeSize) / (double)this.serverNodes.size() >= this.changeThreshold) {
                String comment = String.format("Tree update of %s at seq %d", domainName, t.getSeq());
                log.info(comment);
                this.submitChanges(domainName, records, existing);
            } else {
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.setMaximumFractionDigits(4);
                double changePercent = (double)(addNodeSize + deleteNodeSize) / (double)this.serverNodes.size();
                log.info("Sum of node add & delete percent {} is below changeThreshold {}, skip this changes", (Object)nf.format(changePercent), (Object)this.changeThreshold);
            }
            this.serverNodes.clear();
        }
        catch (Exception e) {
            throw new DnsException(DnsException.TypeEnum.DEPLOY_DOMAIN_FAILED, (Throwable)e);
        }
    }

    @Override
    public boolean deleteDomain(String domainName) throws Exception {
        DeleteSubDomainRecordsRequest request = new DeleteSubDomainRecordsRequest();
        request.setDomainName(domainName);
        DeleteSubDomainRecordsResponse response = this.aliDnsClient.deleteSubDomainRecords(request);
        return response.statusCode == 200;
    }

    public Map<String, DescribeDomainRecordsResponseBody.DescribeDomainRecordsResponseBodyDomainRecordsRecord> collectRecords(String domain) throws Exception {
        HashSet<DnsNode> collectServerNodes;
        String rootContent;
        HashMap<String, DescribeDomainRecordsResponseBody.DescribeDomainRecordsResponseBodyDomainRecordsRecord> records;
        block9: {
            records = new HashMap<String, DescribeDomainRecordsResponseBody.DescribeDomainRecordsResponseBodyDomainRecordsRecord>();
            rootContent = null;
            collectServerNodes = new HashSet<DnsNode>();
            try {
                DescribeDomainRecordsRequest request = new DescribeDomainRecordsRequest();
                request.setDomainName(domain);
                request.setType("TXT");
                request.setPageSize(this.domainRecordsPageSize);
                Long currentPageNum = 1L;
                while (true) {
                    request.setPageNumber(currentPageNum);
                    DescribeDomainRecordsResponse response = this.aliDnsClient.describeDomainRecords(request);
                    if (response.statusCode != 200) break;
                    for (DescribeDomainRecordsResponseBody.DescribeDomainRecordsResponseBodyDomainRecordsRecord r : response.getBody().getDomainRecords().getRecord()) {
                        String name = StringUtils.stripEnd((String)r.getRR(), (String)".");
                        records.put(name, r);
                        if (aliyunRoot.equalsIgnoreCase(name)) {
                            rootContent = r.value;
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)r.value) || !r.value.startsWith("nodes:")) continue;
                        try {
                            NodesEntry nodesEntry = NodesEntry.parseEntry(r.value);
                            List<DnsNode> dnsNodes = nodesEntry.getNodes();
                            collectServerNodes.addAll(dnsNodes);
                        }
                        catch (DnsException e) {
                            log.error("Parse nodeEntry failed: {}", (Object)e.getMessage());
                        }
                    }
                    if (currentPageNum * this.domainRecordsPageSize < response.getBody().getTotalCount()) {
                        Long l = currentPageNum;
                        Long l2 = currentPageNum = Long.valueOf(currentPageNum + 1L);
                        continue;
                    }
                    break block9;
                    break;
                }
                throw new Exception("Failed to request domain records");
            }
            catch (Exception e) {
                log.warn("Failed to collect domain records, error msg: {}", (Object)e.getMessage());
                throw e;
            }
        }
        if (rootContent != null) {
            RootEntry rootEntry = RootEntry.parseEntry(rootContent);
            this.lastSeq = rootEntry.getSeq();
        }
        this.serverNodes = collectServerNodes;
        return records;
    }

    private void submitChanges(String domainName, Map<String, String> records, Map<String, DescribeDomainRecordsResponseBody.DescribeDomainRecordsResponseBodyDomainRecordsRecord> existing) throws Exception {
        long addCount = 0L;
        long updateCount = 0L;
        long deleteCount = 0L;
        for (Map.Entry<String, String> entry : records.entrySet()) {
            boolean result = true;
            long ttl = 86400L;
            if (entry.getKey().equals(aliyunRoot)) {
                ttl = 600L;
            }
            if (!existing.containsKey(entry.getKey())) {
                result = this.addRecord(domainName, entry.getKey(), entry.getValue(), ttl);
                ++addCount;
            } else if (!entry.getValue().equals(existing.get(entry.getKey()).getValue()) || existing.get(entry.getKey()).getTTL() != ttl) {
                result = this.updateRecord(existing.get(entry.getKey()).getRecordId(), entry.getKey(), entry.getValue(), ttl);
                ++updateCount;
            }
            if (result) continue;
            throw new Exception("Adding or updating record failed");
        }
        for (String key : existing.keySet()) {
            if (records.containsKey(key)) continue;
            this.deleteRecord(existing.get(key).getRecordId());
            ++deleteCount;
        }
        log.info("Published successfully, add count:{}, update count:{}, delete count:{}", new Object[]{addCount, updateCount, deleteCount});
    }

    public boolean addRecord(String domainName, String RR, String value, long ttl) throws Exception {
        block1: {
            AddDomainRecordRequest request = new AddDomainRecordRequest();
            request.setDomainName(domainName);
            request.setRR(RR);
            request.setType("TXT");
            request.setValue(value);
            request.setTTL(Long.valueOf(ttl));
            int retryCount = 0;
            while (true) {
                AddDomainRecordResponse response = this.aliDnsClient.addDomainRecord(request);
                if (response.statusCode == 200) break block1;
                if (retryCount >= 3) break;
                ++retryCount;
                Thread.sleep(30L);
            }
            return false;
        }
        return true;
    }

    public boolean updateRecord(String recId, String RR, String value, long ttl) throws Exception {
        block1: {
            UpdateDomainRecordRequest request = new UpdateDomainRecordRequest();
            request.setRecordId(recId);
            request.setRR(RR);
            request.setType("TXT");
            request.setValue(value);
            request.setTTL(Long.valueOf(ttl));
            int retryCount = 0;
            while (true) {
                UpdateDomainRecordResponse response = this.aliDnsClient.updateDomainRecord(request);
                if (response.statusCode == 200) break block1;
                if (retryCount >= 3) break;
                ++retryCount;
                Thread.sleep(30L);
            }
            return false;
        }
        return true;
    }

    public boolean deleteRecord(String recId) throws Exception {
        block1: {
            DeleteDomainRecordRequest request = new DeleteDomainRecordRequest();
            request.setRecordId(recId);
            int retryCount = 0;
            while (true) {
                DeleteDomainRecordResponse response = this.aliDnsClient.deleteDomainRecord(request);
                if (response.statusCode == 200) break block1;
                if (retryCount >= 3) break;
                ++retryCount;
                Thread.sleep(30L);
            }
            return false;
        }
        return true;
    }

    public String getRecId(String domainName, String RR) {
        String recId;
        block3: {
            recId = null;
            try {
                DescribeDomainRecordsRequest request = new DescribeDomainRecordsRequest();
                request.setDomainName(domainName);
                request.setRRKeyWord(RR);
                DescribeDomainRecordsResponse response = this.aliDnsClient.describeDomainRecords(request);
                if (response.getBody().getTotalCount() <= 0L) break block3;
                List recs = response.getBody().getDomainRecords().getRecord();
                for (DescribeDomainRecordsResponseBody.DescribeDomainRecordsResponseBodyDomainRecordsRecord rec : recs) {
                    if (!rec.getRR().equalsIgnoreCase(RR)) continue;
                    recId = rec.getRecordId();
                    break;
                }
            }
            catch (Exception e) {
                log.warn("Failed to get record id, error msg: {}", (Object)e.getMessage());
            }
        }
        return recId;
    }

    public String update(String DomainName, String RR, String value, long ttl) {
        String type = "TXT";
        String recId = null;
        try {
            String existRecId = this.getRecId(DomainName, RR);
            if (existRecId == null || existRecId.isEmpty()) {
                AddDomainRecordRequest request = new AddDomainRecordRequest();
                request.setDomainName(DomainName);
                request.setRR(RR);
                request.setType(type);
                request.setValue(value);
                request.setTTL(Long.valueOf(ttl));
                AddDomainRecordResponse response = this.aliDnsClient.addDomainRecord(request);
                recId = response.getBody().getRecordId();
            } else {
                UpdateDomainRecordRequest request = new UpdateDomainRecordRequest();
                request.setRecordId(existRecId);
                request.setRR(RR);
                request.setType(type);
                request.setValue(value);
                request.setTTL(Long.valueOf(ttl));
                UpdateDomainRecordResponse response = this.aliDnsClient.updateDomainRecord(request);
                recId = response.getBody().getRecordId();
            }
        }
        catch (Exception e) {
            log.warn("Failed to update or add domain record, error mag: {}", (Object)e.getMessage());
        }
        return recId;
    }

    public boolean deleteByRR(String domainName, String RR) {
        try {
            String recId = this.getRecId(domainName, RR);
            if (recId != null && !recId.isEmpty()) {
                DeleteDomainRecordRequest request = new DeleteDomainRecordRequest();
                request.setRecordId(recId);
                DeleteDomainRecordResponse response = this.aliDnsClient.deleteDomainRecord(request);
                if (response.statusCode != 200) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to delete domain record, domain name: {}, RR: {}, error msg: {}", new Object[]{domainName, RR, e.getMessage()});
            return false;
        }
        return true;
    }
}

