/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.sync;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.dns.DnsNode;
import org.tron.p2p.dns.sync.Client;
import org.tron.p2p.dns.sync.ClientTree;
import org.tron.p2p.dns.sync.LinkCache;
import org.tron.p2p.dns.tree.LinkEntry;
import org.tron.p2p.exception.DnsException;

public class RandomIterator
implements Iterator<DnsNode> {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private final Client client;
    private Map<String, ClientTree> clientTrees;
    private DnsNode cur;
    private final LinkCache linkCache;
    private final Random random;

    public RandomIterator(Client client) {
        this.client = client;
        this.clientTrees = new ConcurrentHashMap<String, ClientTree>();
        this.linkCache = new LinkCache();
        this.random = new Random();
    }

    @Override
    public DnsNode next() {
        for (int i = 0; i < 10; ++i) {
            ClientTree clientTree = this.pickTree();
            if (clientTree == null) {
                log.error("clientTree is null");
                return null;
            }
            log.info("Choose clientTree:{} from {} ClientTree", (Object)clientTree.getLinkEntry().getRepresent(), (Object)this.clientTrees.size());
            try {
                DnsNode dnsNode = clientTree.syncRandom();
                continue;
            }
            catch (Exception e) {
                log.warn("Error in DNS random node sync, tree:{}, cause:[{}]", (Object)clientTree.getLinkEntry().getDomain(), (Object)e.getMessage());
                continue;
            }
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        this.cur = this.next();
        return this.cur != null;
    }

    public void addTree(String url) throws DnsException {
        LinkEntry linkEntry = LinkEntry.parseEntry(url);
        this.linkCache.addLink("", linkEntry.getRepresent());
    }

    private ClientTree pickTree() {
        if (this.clientTrees == null) {
            log.info("clientTrees is null");
            return null;
        }
        if (this.linkCache.isChanged()) {
            this.rebuildTrees();
            this.linkCache.setChanged(false);
        }
        int size = this.clientTrees.size();
        ArrayList<ClientTree> allTrees = new ArrayList<ClientTree>(this.clientTrees.values());
        return (ClientTree)allTrees.get(this.random.nextInt(size));
    }

    private void rebuildTrees() {
        log.info("rebuildTrees...");
        Iterator<Map.Entry<String, ClientTree>> it = this.clientTrees.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ClientTree> entry = it.next();
            String urlScheme = entry.getKey();
            if (this.linkCache.isContainInOtherLink(urlScheme)) continue;
            log.info("remove tree from trees:{}", (Object)urlScheme);
            it.remove();
        }
        for (Map.Entry<String, Set<String>> entry : this.linkCache.backrefs.entrySet()) {
            String urlScheme = entry.getKey();
            if (this.clientTrees.containsKey(urlScheme)) continue;
            try {
                LinkEntry linkEntry = LinkEntry.parseEntry(urlScheme);
                this.clientTrees.put(urlScheme, new ClientTree(this.client, this.linkCache, linkEntry));
                log.info("add tree to clientTrees:{}", (Object)urlScheme);
            }
            catch (DnsException e) {
                log.error("Parse LinkEntry failed", (Throwable)e);
            }
        }
        log.info("Exist clientTrees: {}", (Object)StringUtils.join(this.clientTrees.keySet(), (String)","));
    }

    public void close() {
        this.clientTrees = null;
    }

    public DnsNode getCur() {
        return this.cur;
    }
}

