/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.sync;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.UnknownHostException;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.base.Parameter;
import org.tron.p2p.dns.lookup.LookUpTxt;
import org.tron.p2p.dns.sync.ClientTree;
import org.tron.p2p.dns.sync.RandomIterator;
import org.tron.p2p.dns.tree.Algorithm;
import org.tron.p2p.dns.tree.BranchEntry;
import org.tron.p2p.dns.tree.Entry;
import org.tron.p2p.dns.tree.LinkEntry;
import org.tron.p2p.dns.tree.NodesEntry;
import org.tron.p2p.dns.tree.RootEntry;
import org.tron.p2p.dns.tree.Tree;
import org.tron.p2p.exception.DnsException;
import org.tron.p2p.utils.ByteArray;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public class Client {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    public static final int recheckInterval = 3600;
    public static final int cacheLimit = 2000;
    public static final int randomRetryTimes = 10;
    private Cache<String, Entry> cache;
    private final Map<String, Tree> trees = new ConcurrentHashMap<String, Tree>();
    private final Map<String, ClientTree> clientTrees = new HashMap<String, ClientTree>();
    private final ScheduledExecutorService syncer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("dnsSyncer").build());

    public Client() {
        this.cache = CacheBuilder.newBuilder().maximumSize(2000L).recordStats().build();
    }

    public void init() {
        if (!Parameter.p2pConfig.getTreeUrls().isEmpty()) {
            this.syncer.scheduleWithFixedDelay(this::startSync, 5L, 3600L, TimeUnit.SECONDS);
        }
    }

    public void startSync() {
        for (String urlScheme : Parameter.p2pConfig.getTreeUrls()) {
            ClientTree clientTree = this.clientTrees.getOrDefault(urlScheme, new ClientTree(this));
            Tree tree = this.trees.getOrDefault(urlScheme, new Tree());
            this.trees.put(urlScheme, tree);
            this.clientTrees.put(urlScheme, clientTree);
            try {
                this.syncTree(urlScheme, clientTree, tree);
            }
            catch (Exception e) {
                log.error("SyncTree failed, url:" + urlScheme, (Throwable)e);
            }
        }
    }

    public void syncTree(String urlScheme, ClientTree clientTree, Tree tree) throws Exception {
        LinkEntry loc = LinkEntry.parseEntry(urlScheme);
        if (clientTree == null) {
            clientTree = new ClientTree(this);
        }
        if (clientTree.getLinkEntry() == null) {
            clientTree.setLinkEntry(loc);
        }
        if (tree.getEntries().isEmpty()) {
            clientTree.syncAll(tree.getEntries());
        } else {
            HashMap<String, Entry> tmpEntries = new HashMap<String, Entry>();
            boolean[] isRootUpdate = clientTree.syncAll(tmpEntries);
            if (!isRootUpdate[0]) {
                tmpEntries.putAll(tree.getLinksMap());
            }
            if (!isRootUpdate[1]) {
                tmpEntries.putAll(tree.getNodesMap());
            }
            tree.setEntries(tmpEntries);
        }
        tree.setRootEntry(clientTree.getRoot());
        log.info("SyncTree {} complete, LinkEntry size:{}, NodesEntry size:{}, node size:{}", new Object[]{urlScheme, tree.getLinksEntry().size(), tree.getNodesEntry().size(), tree.getDnsNodes().size()});
    }

    public RootEntry resolveRoot(LinkEntry linkEntry) throws TextParseException, DnsException, SignatureException, UnknownHostException {
        TXTRecord txtRecord = LookUpTxt.lookUpTxt(linkEntry.getDomain());
        if (txtRecord == null) {
            throw new DnsException(DnsException.TypeEnum.LOOK_UP_ROOT_FAILED, "domain: " + linkEntry.getDomain());
        }
        for (String txt : txtRecord.getStrings()) {
            if (!txt.startsWith("tree-root-v1:")) continue;
            return RootEntry.parseEntry(txt, linkEntry.getUnCompressHexPublicKey(), linkEntry.getDomain());
        }
        throw new DnsException(DnsException.TypeEnum.NO_ROOT_FOUND, "domain: " + linkEntry.getDomain());
    }

    public Entry resolveEntry(String domain, String hash) throws DnsException, TextParseException, UnknownHostException {
        Entry entry = (Entry)this.cache.getIfPresent((Object)hash);
        if (entry != null) {
            return entry;
        }
        entry = this.doResolveEntry(domain, hash);
        if (entry != null) {
            this.cache.put((Object)hash, (Object)entry);
        }
        return entry;
    }

    private Entry doResolveEntry(String domain, String hash) throws DnsException, TextParseException, UnknownHostException {
        try {
            ByteArray.toHexString(Algorithm.decode32(hash));
        }
        catch (Exception e) {
            throw new DnsException(DnsException.TypeEnum.OTHER_ERROR, "invalid base32 hash: " + hash);
        }
        TXTRecord txtRecord = LookUpTxt.lookUpTxt(hash, domain);
        if (txtRecord == null) {
            return null;
        }
        String txt = LookUpTxt.joinTXTRecord(txtRecord);
        Entry entry = null;
        if (txt.startsWith("tree-branch:")) {
            entry = BranchEntry.parseEntry(txt);
        } else if (txt.startsWith("tree://")) {
            entry = LinkEntry.parseEntry(txt);
        } else if (txt.startsWith("nodes:")) {
            entry = NodesEntry.parseEntry(txt);
        }
        if (entry == null) {
            throw new DnsException(DnsException.TypeEnum.NO_ENTRY_FOUND, String.format("hash:%s, domain:%s, txt:%s", hash, domain, txt));
        }
        String wantHash = Algorithm.encode32AndTruncate(((Object)entry).toString());
        if (!wantHash.equals(hash)) {
            throw new DnsException(DnsException.TypeEnum.HASH_MISS_MATCH, String.format("hash mismatch, want: [%s], really: [%s], content: [%s]", wantHash, hash, entry));
        }
        return entry;
    }

    public RandomIterator newIterator() {
        RandomIterator randomIterator = new RandomIterator(this);
        for (String urlScheme : Parameter.p2pConfig.getTreeUrls()) {
            try {
                randomIterator.addTree(urlScheme);
            }
            catch (DnsException e) {
                log.error("AddTree failed " + urlScheme, (Throwable)e);
            }
        }
        return randomIterator;
    }

    public void close() {
        if (this.syncer != null) {
            this.syncer.shutdown();
        }
    }

    public Map<String, Tree> getTrees() {
        return this.trees;
    }
}

