/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.discover.Node;
import org.tron.p2p.dns.DnsNode;
import org.tron.p2p.dns.sync.Client;
import org.tron.p2p.dns.sync.RandomIterator;
import org.tron.p2p.dns.tree.Tree;
import org.tron.p2p.dns.update.PublishService;
import org.tron.p2p.utils.NetUtil;

public class DnsManager {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private static PublishService publishService;
    private static Client syncClient;
    private static RandomIterator randomIterator;
    private static Set<String> localIpSet;

    public static void init() {
        publishService = new PublishService();
        syncClient = new Client();
        publishService.init();
        syncClient.init();
        randomIterator = syncClient.newIterator();
        localIpSet = NetUtil.getAllLocalAddress();
    }

    public static void close() {
        if (publishService != null) {
            publishService.close();
        }
        if (syncClient != null) {
            syncClient.close();
        }
        if (randomIterator != null) {
            randomIterator.close();
        }
    }

    public static List<DnsNode> getDnsNodes() {
        HashSet nodes = new HashSet();
        for (Map.Entry<String, Tree> entry : syncClient.getTrees().entrySet()) {
            Tree tree = entry.getValue();
            int v4Size = 0;
            int v6Size = 0;
            List<DnsNode> dnsNodes = tree.getDnsNodes();
            ArrayList<DnsNode> ipv6Nodes = new ArrayList<DnsNode>();
            for (DnsNode dnsNode : dnsNodes) {
                if (dnsNode.getInetSocketAddressV4() != null) {
                    ++v4Size;
                }
                if (dnsNode.getInetSocketAddressV6() == null) continue;
                ++v6Size;
                ipv6Nodes.add(dnsNode);
            }
            List connectAbleNodes = dnsNodes.stream().filter(node -> node.getPreferInetSocketAddress() != null).filter(node -> !localIpSet.contains(node.getPreferInetSocketAddress().getAddress().getHostAddress())).collect(Collectors.toList());
            log.debug("Tree {} node size:{}, v4 node size:{}, v6 node size:{}, connectable size:{}", new Object[]{entry.getKey(), dnsNodes.size(), v4Size, v6Size, connectAbleNodes.size()});
            nodes.addAll(connectAbleNodes);
        }
        return new ArrayList<DnsNode>(nodes);
    }

    public static Node getRandomNodes() {
        return randomIterator.next();
    }
}

