/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.discover.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.base.Parameter;
import org.tron.p2p.discover.socket.EventHandler;
import org.tron.p2p.discover.socket.MessageHandler;
import org.tron.p2p.discover.socket.P2pPacketDecoder;
import org.tron.p2p.stats.TrafficStats;

public class DiscoverServer {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private Channel channel;
    private EventHandler eventHandler;
    private final int SERVER_RESTART_WAIT = 5000;
    private final int SERVER_CLOSE_WAIT = 10;
    private final int port = Parameter.p2pConfig.getPort();
    private volatile boolean shutdown = false;

    public void init(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
        new Thread(() -> {
            try {
                this.start();
            }
            catch (Exception e) {
                log.error("Discovery server start failed", (Throwable)e);
            }
        }, "DiscoverServer").start();
    }

    public void close() {
        log.info("Closing discovery server...");
        this.shutdown = true;
        if (this.channel != null) {
            try {
                this.channel.close().await(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                log.error("Closing discovery server failed", (Throwable)e);
            }
        }
    }

    private void start() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("discoverServer").build());
        try {
            while (!this.shutdown) {
                Bootstrap b = new Bootstrap();
                ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

                    public void initChannel(NioDatagramChannel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{TrafficStats.udp});
                        ch.pipeline().addLast(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
                        ch.pipeline().addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder()});
                        ch.pipeline().addLast(new ChannelHandler[]{new P2pPacketDecoder()});
                        MessageHandler messageHandler = new MessageHandler(ch, DiscoverServer.this.eventHandler);
                        DiscoverServer.this.eventHandler.setMessageSender(messageHandler);
                        ch.pipeline().addLast(new ChannelHandler[]{messageHandler});
                    }
                });
                this.channel = b.bind(this.port).sync().channel();
                log.info("Discovery server started, bind port {}", (Object)this.port);
                this.channel.closeFuture().sync();
                if (this.shutdown) {
                    log.info("Shutdown discovery server");
                    break;
                }
                log.warn("Restart discovery server after 5 sec pause...");
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException e) {
            log.warn("Discover server interrupted");
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("Start discovery server with port {} failed", (Object)this.port, (Object)e);
        }
        finally {
            group.shutdownGracefully().sync();
        }
    }
}

