/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.discover.protocol.kad;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.base.Parameter;
import org.tron.p2p.discover.Node;
import org.tron.p2p.discover.message.Message;
import org.tron.p2p.discover.message.kad.FindNodeMessage;
import org.tron.p2p.discover.message.kad.NeighborsMessage;
import org.tron.p2p.discover.message.kad.PingMessage;
import org.tron.p2p.discover.message.kad.PongMessage;
import org.tron.p2p.discover.protocol.kad.KadService;
import org.tron.p2p.discover.socket.UdpEvent;

public class NodeHandler {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private Node node;
    private volatile State state;
    private KadService kadService;
    private NodeHandler replaceCandidate;
    private AtomicInteger pingTrials = new AtomicInteger(3);
    private volatile boolean waitForPong = false;
    private volatile boolean waitForNeighbors = false;

    public NodeHandler(Node node, KadService kadService) {
        this.node = node;
        this.kadService = kadService;
        if (node.getPreferInetSocketAddress() != null) {
            this.changeState(State.DISCOVERED);
        }
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public State getState() {
        return this.state;
    }

    private void challengeWith(NodeHandler replaceCandidate) {
        this.replaceCandidate = replaceCandidate;
        this.changeState(State.EVICTCANDIDATE);
    }

    public void changeState(State newState) {
        State oldState = this.state;
        if (newState == State.DISCOVERED) {
            this.sendPing();
        }
        if (newState == State.ALIVE) {
            Node evictCandidate = this.kadService.getTable().addNode(this.node);
            if (evictCandidate == null) {
                newState = State.ACTIVE;
            } else {
                NodeHandler evictHandler = this.kadService.getNodeHandler(evictCandidate);
                if (evictHandler.state != State.EVICTCANDIDATE) {
                    evictHandler.challengeWith(this);
                }
            }
        }
        if (newState == State.ACTIVE) {
            if (oldState == State.ALIVE) {
                this.kadService.getTable().addNode(this.node);
            } else if (oldState == State.EVICTCANDIDATE) {
                // empty if block
            }
        }
        if (newState == State.DEAD) {
            if (oldState == State.EVICTCANDIDATE) {
                this.kadService.getTable().dropNode(this.node);
                this.replaceCandidate.changeState(State.ACTIVE);
            } else if (oldState == State.ALIVE) {
                // empty if block
            }
        }
        if (newState == State.EVICTCANDIDATE) {
            this.sendPing();
        }
        this.state = newState;
    }

    public void handlePing(PingMessage msg) {
        if (!this.kadService.getTable().getNode().equals(this.node)) {
            this.sendPong();
        }
        this.node.setP2pVersion(msg.getNetworkId());
        if (!this.node.isConnectible(Parameter.p2pConfig.getNetworkId())) {
            this.changeState(State.DEAD);
        } else if (this.state.equals((Object)State.DEAD)) {
            this.changeState(State.DISCOVERED);
        }
    }

    public void handlePong(PongMessage msg) {
        if (this.waitForPong) {
            this.waitForPong = false;
            this.node.setP2pVersion(msg.getNetworkId());
            if (!this.node.isConnectible(Parameter.p2pConfig.getNetworkId())) {
                this.changeState(State.DEAD);
            } else {
                this.changeState(State.ALIVE);
            }
        }
    }

    public void handleNeighbours(NeighborsMessage msg, InetSocketAddress sender) {
        if (!this.waitForNeighbors) {
            log.warn("Receive neighbors from {} without send find nodes", (Object)sender);
            return;
        }
        this.waitForNeighbors = false;
        for (Node n : msg.getNodes()) {
            if (this.kadService.getPublicHomeNode().getHexId().equals(n.getHexId())) continue;
            this.kadService.getNodeHandler(n);
        }
    }

    public void handleFindNode(FindNodeMessage msg) {
        List<Node> closest = this.kadService.getTable().getClosestNodes(msg.getTargetId());
        this.sendNeighbours(closest, msg.getTimestamp());
    }

    public void handleTimedOut() {
        this.waitForPong = false;
        if (this.pingTrials.getAndDecrement() > 0) {
            this.sendPing();
        } else if (this.state == State.DISCOVERED || this.state == State.EVICTCANDIDATE) {
            this.changeState(State.DEAD);
        }
    }

    public void sendPing() {
        PingMessage msg = new PingMessage(this.kadService.getPublicHomeNode(), this.getNode());
        this.waitForPong = true;
        this.sendMessage(msg);
        if (this.kadService.getPongTimer().isShutdown()) {
            return;
        }
        this.kadService.getPongTimer().schedule(() -> {
            try {
                if (this.waitForPong) {
                    this.waitForPong = false;
                    this.handleTimedOut();
                }
            }
            catch (Exception e) {
                log.error("Unhandled exception in pong timer schedule", (Throwable)e);
            }
        }, KadService.getPingTimeout(), TimeUnit.MILLISECONDS);
    }

    public void sendPong() {
        PongMessage pong = new PongMessage(this.kadService.getPublicHomeNode());
        this.sendMessage(pong);
    }

    public void sendFindNode(byte[] target) {
        this.waitForNeighbors = true;
        FindNodeMessage msg = new FindNodeMessage(this.kadService.getPublicHomeNode(), target);
        this.sendMessage(msg);
    }

    public void sendNeighbours(List<Node> neighbours, long sequence) {
        NeighborsMessage msg = new NeighborsMessage(this.kadService.getPublicHomeNode(), neighbours, sequence);
        this.sendMessage(msg);
    }

    private void sendMessage(Message msg) {
        this.kadService.sendOutbound(new UdpEvent(msg, this.node.getPreferInetSocketAddress()));
    }

    public String toString() {
        return "NodeHandler[state: " + (Object)((Object)this.state) + ", node: " + this.node.getHostKey() + ":" + this.node.getPort() + "]";
    }

    public static enum State {
        DISCOVERED,
        DEAD,
        ALIVE,
        ACTIVE,
        EVICTCANDIDATE;

    }
}

