/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.discover.message.kad;

import com.google.protobuf.ByteString;
import org.tron.p2p.discover.Node;
import org.tron.p2p.discover.message.MessageType;
import org.tron.p2p.discover.message.kad.KadMessage;
import org.tron.p2p.protos.Discover;
import org.tron.p2p.utils.NetUtil;

public class FindNodeMessage
extends KadMessage {
    private Discover.FindNeighbours findNeighbours;

    public FindNodeMessage(byte[] data) throws Exception {
        super(MessageType.KAD_FIND_NODE, data);
        this.findNeighbours = Discover.FindNeighbours.parseFrom(data);
    }

    public FindNodeMessage(Node from, byte[] targetId) {
        super(MessageType.KAD_FIND_NODE, null);
        Discover.Endpoint fromEndpoint = FindNodeMessage.getEndpointFromNode(from);
        this.findNeighbours = Discover.FindNeighbours.newBuilder().setFrom(fromEndpoint).setTargetId(ByteString.copyFrom((byte[])targetId)).setTimestamp(System.currentTimeMillis()).build();
        this.data = this.findNeighbours.toByteArray();
    }

    public byte[] getTargetId() {
        return this.findNeighbours.getTargetId().toByteArray();
    }

    @Override
    public long getTimestamp() {
        return this.findNeighbours.getTimestamp();
    }

    @Override
    public Node getFrom() {
        return NetUtil.getNode(this.findNeighbours.getFrom());
    }

    @Override
    public String toString() {
        return "[findNeighbours: " + this.findNeighbours;
    }

    @Override
    public boolean valid() {
        return NetUtil.validNode(this.getFrom()) && this.getTargetId().length == 64;
    }
}

