/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.discover;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.base.Parameter;
import org.tron.p2p.utils.NetUtil;

public class Node
implements Serializable,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private static final long serialVersionUID = -4267600517925770636L;
    private byte[] id;
    protected String hostV4;
    protected String hostV6;
    protected int port;
    private int bindPort;
    private int p2pVersion;
    private long updateTime;

    public Node(InetSocketAddress address) {
        this.id = NetUtil.getNodeId();
        if (address.getAddress() instanceof Inet4Address) {
            this.hostV4 = address.getAddress().getHostAddress();
        } else {
            this.hostV6 = address.getAddress().getHostAddress();
        }
        this.bindPort = this.port = address.getPort();
        this.updateTime = System.currentTimeMillis();
        this.formatHostV6();
    }

    public Node(byte[] id, String hostV4, String hostV6, int port) {
        this.id = id;
        this.hostV4 = hostV4;
        this.hostV6 = hostV6;
        this.port = port;
        this.bindPort = port;
        this.updateTime = System.currentTimeMillis();
        this.formatHostV6();
    }

    public Node(byte[] id, String hostV4, String hostV6, int port, int bindPort) {
        this.id = id;
        this.hostV4 = hostV4;
        this.hostV6 = hostV6;
        this.port = port;
        this.bindPort = bindPort;
        this.updateTime = System.currentTimeMillis();
        this.formatHostV6();
    }

    public void updateHostV4(String hostV4) {
        if (StringUtils.isEmpty((CharSequence)this.hostV4) && StringUtils.isNotEmpty((CharSequence)hostV4)) {
            log.info("update hostV4:{} with hostV6:{}", (Object)hostV4, (Object)this.hostV6);
            this.hostV4 = hostV4;
        }
    }

    public void updateHostV6(String hostV6) {
        if (StringUtils.isEmpty((CharSequence)this.hostV6) && StringUtils.isNotEmpty((CharSequence)hostV6)) {
            log.info("update hostV6:{} with hostV4:{}", (Object)hostV6, (Object)this.hostV4);
            this.hostV6 = hostV6;
        }
    }

    private void formatHostV6() {
        if (StringUtils.isNotEmpty((CharSequence)this.hostV6)) {
            this.hostV6 = new InetSocketAddress(this.hostV6, this.port).getAddress().getHostAddress();
        }
    }

    public boolean isConnectible(int argsP2PVersion) {
        return this.port == this.bindPort && this.p2pVersion == argsP2PVersion;
    }

    public InetSocketAddress getPreferInetSocketAddress() {
        if (StringUtils.isNotEmpty((CharSequence)this.hostV4) && StringUtils.isNotEmpty((CharSequence)Parameter.p2pConfig.getIp())) {
            return this.getInetSocketAddressV4();
        }
        if (StringUtils.isNotEmpty((CharSequence)this.hostV6) && StringUtils.isNotEmpty((CharSequence)Parameter.p2pConfig.getIpv6())) {
            return this.getInetSocketAddressV6();
        }
        return null;
    }

    public String getHexId() {
        return this.id == null ? null : Hex.toHexString((byte[])this.id);
    }

    public String getHexIdShort() {
        return this.getIdShort(this.getHexId());
    }

    public byte[] getId() {
        return this.id;
    }

    public void setId(byte[] id) {
        this.id = id;
    }

    public String getHostKey() {
        return this.getPreferInetSocketAddress().getAddress().getHostAddress();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getIdString() {
        if (this.id == null) {
            return null;
        }
        return new String(this.id);
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void touch() {
        this.updateTime = System.currentTimeMillis();
    }

    public String toString() {
        return "Node{ hostV4='" + this.hostV4 + '\'' + ", hostV6='" + this.hostV6 + '\'' + ", port=" + this.port + ", id='" + (this.id == null ? "null" : Hex.toHexString((byte[])this.id)) + "'}";
    }

    public String format() {
        return "Node{ hostV4='" + this.hostV4 + '\'' + ", hostV6='" + this.hostV6 + '\'' + ", port=" + this.port + '}';
    }

    public int hashCode() {
        return this.format().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() == this.getClass()) {
            return StringUtils.equals((CharSequence)this.getIdString(), (CharSequence)((Node)o).getIdString());
        }
        return false;
    }

    private String getIdShort(String Id) {
        return Id == null ? "<null>" : Id.substring(0, 8);
    }

    public InetSocketAddress getInetSocketAddressV4() {
        return StringUtils.isNotEmpty((CharSequence)this.hostV4) ? new InetSocketAddress(this.hostV4, this.port) : null;
    }

    public InetSocketAddress getInetSocketAddressV6() {
        return StringUtils.isNotEmpty((CharSequence)this.hostV6) ? new InetSocketAddress(this.hostV6, this.port) : null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getHostV4() {
        return this.hostV4;
    }

    public String getHostV6() {
        return this.hostV6;
    }

    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
    }

    public void setP2pVersion(int p2pVersion) {
        this.p2pVersion = p2pVersion;
    }
}

