/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.connection.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultMessageSizeEstimator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.connection.ChannelManager;
import org.tron.p2p.connection.socket.P2pChannelInitializer;
import org.tron.p2p.discover.Node;
import org.tron.p2p.utils.NetUtil;

public class PeerClient {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private EventLoopGroup workerGroup;

    public void init() {
        this.workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("peerClient-%d").build());
    }

    public void close() {
        this.workerGroup.shutdownGracefully();
        this.workerGroup.terminationFuture().syncUninterruptibly();
    }

    public void connect(String host, int port, String remoteId) {
        try {
            ChannelFuture f = this.connectAsync(host, port, remoteId, false, false);
            if (f != null) {
                f.sync().channel().closeFuture().sync();
            }
        }
        catch (Exception e) {
            log.warn("PeerClient can't connect to {}:{} ({})", new Object[]{host, port, e.getMessage()});
        }
    }

    public ChannelFuture connect(Node node, ChannelFutureListener future) {
        ChannelFuture channelFuture = this.connectAsync(node.getPreferInetSocketAddress().getAddress().getHostAddress(), node.getPort(), node.getId() == null ? Hex.toHexString((byte[])NetUtil.getNodeId()) : node.getHexId(), false, false);
        if (ChannelManager.isShutdown) {
            return null;
        }
        if (channelFuture != null && future != null) {
            channelFuture.addListener((GenericFutureListener)future);
        }
        return channelFuture;
    }

    public ChannelFuture connectAsync(Node node, boolean discoveryMode) {
        ChannelFuture channelFuture = this.connectAsync(node.getPreferInetSocketAddress().getAddress().getHostAddress(), node.getPort(), node.getId() == null ? Hex.toHexString((byte[])NetUtil.getNodeId()) : node.getHexId(), discoveryMode, true);
        if (ChannelManager.isShutdown) {
            return null;
        }
        if (channelFuture != null) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    log.warn("Connect to peer {} fail, cause:{}", (Object)node.getPreferInetSocketAddress(), (Object)future.cause().getMessage());
                    future.channel().close();
                    if (!discoveryMode) {
                        ChannelManager.triggerConnect(node.getPreferInetSocketAddress());
                    }
                }
            }));
        }
        return channelFuture;
    }

    private ChannelFuture connectAsync(String host, int port, String remoteId, boolean discoveryMode, boolean trigger) {
        P2pChannelInitializer p2pChannelInitializer = new P2pChannelInitializer(remoteId, discoveryMode, trigger);
        Bootstrap b = new Bootstrap();
        b.group(this.workerGroup);
        b.channel(NioSocketChannel.class);
        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.option(ChannelOption.MESSAGE_SIZE_ESTIMATOR, (Object)DefaultMessageSizeEstimator.DEFAULT);
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)2000);
        b.remoteAddress(host, port);
        b.handler((ChannelHandler)p2pChannelInitializer);
        if (ChannelManager.isShutdown) {
            return null;
        }
        return b.connect();
    }
}

