/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.connection.socket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.connection.Channel;
import org.tron.p2p.connection.ChannelManager;
import org.tron.p2p.connection.business.upgrade.UpgradeController;
import org.tron.p2p.connection.message.base.P2pDisconnectMessage;
import org.tron.p2p.connection.message.detect.StatusMessage;
import org.tron.p2p.exception.P2pException;
import org.tron.p2p.protos.Connect;
import org.tron.p2p.utils.ByteArray;

public class MessageHandler
extends ByteToMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private final Channel channel;

    public MessageHandler(Channel channel) {
        this.channel = channel;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
    }

    public void channelActive(ChannelHandlerContext ctx) {
        log.debug("Channel active, {}", (Object)ctx.channel().remoteAddress());
        this.channel.setChannelHandlerContext(ctx);
        if (this.channel.isActive()) {
            if (this.channel.isDiscoveryMode()) {
                this.channel.send(new StatusMessage());
            } else {
                ChannelManager.getHandshakeService().startHandshake(this.channel);
            }
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) {
        byte[] data = new byte[buffer.readableBytes()];
        buffer.readBytes(data);
        try {
            if (this.channel.isFinishHandshake()) {
                data = UpgradeController.decodeReceiveData(this.channel.getVersion(), data);
            }
            ChannelManager.processMessage(this.channel, data);
        }
        catch (Exception e) {
            if (e instanceof P2pException) {
                Connect.DisconnectReason disconnectReason;
                P2pException pe = (P2pException)e;
                switch (pe.getType()) {
                    case EMPTY_MESSAGE: {
                        disconnectReason = Connect.DisconnectReason.EMPTY_MESSAGE;
                        break;
                    }
                    case BAD_PROTOCOL: {
                        disconnectReason = Connect.DisconnectReason.BAD_PROTOCOL;
                        break;
                    }
                    case NO_SUCH_MESSAGE: {
                        disconnectReason = Connect.DisconnectReason.NO_SUCH_MESSAGE;
                        break;
                    }
                    case BAD_MESSAGE: 
                    case PARSE_MESSAGE_FAILED: 
                    case MESSAGE_WITH_WRONG_LENGTH: 
                    case TYPE_ALREADY_REGISTERED: {
                        disconnectReason = Connect.DisconnectReason.BAD_MESSAGE;
                        break;
                    }
                    default: {
                        disconnectReason = Connect.DisconnectReason.UNKNOWN;
                    }
                }
                this.channel.send(new P2pDisconnectMessage(disconnectReason));
            }
            this.channel.processException(e);
        }
        catch (Throwable t) {
            log.error("Decode message from {} failed, message:{}", (Object)this.channel.getInetSocketAddress(), (Object)ByteArray.toHexString(data));
            throw t;
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.channel.processException(cause);
    }
}

