/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.connection.business.detect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.base.Parameter;
import org.tron.p2p.connection.Channel;
import org.tron.p2p.connection.business.MessageProcess;
import org.tron.p2p.connection.business.detect.NodeStat;
import org.tron.p2p.connection.message.Message;
import org.tron.p2p.connection.message.detect.StatusMessage;
import org.tron.p2p.connection.socket.PeerClient;
import org.tron.p2p.discover.Node;
import org.tron.p2p.discover.NodeManager;

public class NodeDetectService
implements MessageProcess {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private PeerClient peerClient;
    private Map<InetSocketAddress, NodeStat> nodeStatMap = new ConcurrentHashMap<InetSocketAddress, NodeStat>();
    private static final Cache<InetAddress, Long> badNodesCache = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("nodeDetectService").build());
    private final long NODE_DETECT_THRESHOLD = 300000L;
    private final long NODE_DETECT_MIN_THRESHOLD = 30000L;
    private final long NODE_DETECT_TIMEOUT = 2000L;
    private final int MAX_NODE_SLOW_DETECT = 3;
    private final int MAX_NODE_NORMAL_DETECT = 10;
    private final int MAX_NODE_FAST_DETECT = 100;
    private final int MAX_NODES = 300;
    private final int MIN_NODES = 200;

    public void init(PeerClient peerClient) {
        if (!Parameter.p2pConfig.isNodeDetectEnable()) {
            return;
        }
        this.peerClient = peerClient;
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                this.work();
            }
            catch (Exception t) {
                log.warn("Exception in node detect worker, {}", (Object)t.getMessage());
            }
        }, 1L, 5L, TimeUnit.SECONDS);
    }

    public void close() {
        this.executor.shutdown();
    }

    public void work() {
        List<NodeStat> nodeStats;
        this.trimNodeMap();
        if (this.nodeStatMap.size() < 200) {
            this.loadNodes();
        }
        if ((nodeStats = this.getSortedNodeStats()).size() == 0) {
            return;
        }
        NodeStat nodeStat = nodeStats.get(0);
        if (nodeStat.getLastDetectTime() > System.currentTimeMillis() - 30000L) {
            return;
        }
        int n = 10;
        if (nodeStat.getLastDetectTime() > System.currentTimeMillis() - 300000L) {
            n = 3;
        }
        n = Math.min(n, nodeStats.size());
        for (int i = 0; i < n; ++i) {
            this.detect(nodeStats.get(i));
        }
    }

    public void trimNodeMap() {
        long now = System.currentTimeMillis();
        this.nodeStatMap.forEach((k, v) -> {
            if (!v.finishDetect() && v.getLastDetectTime() < now - 2000L) {
                this.nodeStatMap.remove(k);
                badNodesCache.put((Object)k.getAddress(), (Object)System.currentTimeMillis());
            }
        });
    }

    private void loadNodes() {
        int size = this.nodeStatMap.size();
        int count = 0;
        List<Node> nodes = NodeManager.getConnectableNodes();
        for (Node node : nodes) {
            InetSocketAddress socketAddress = node.getPreferInetSocketAddress();
            if (socketAddress == null || this.nodeStatMap.containsKey(socketAddress) || badNodesCache.getIfPresent((Object)socketAddress.getAddress()) != null) continue;
            NodeStat nodeStat = new NodeStat(node);
            this.nodeStatMap.put(socketAddress, nodeStat);
            this.detect(nodeStat);
            if (++count < 100 && count + size < 300) continue;
            break;
        }
    }

    private void detect(NodeStat stat) {
        try {
            stat.setTotalCount(stat.getTotalCount() + 1);
            this.setLastDetectTime(stat);
            this.peerClient.connectAsync(stat.getNode(), true);
        }
        catch (Exception e) {
            log.warn("Detect node {} failed, {}", (Object)stat.getNode().getPreferInetSocketAddress(), (Object)e.getMessage());
            this.nodeStatMap.remove(stat.getSocketAddress());
        }
    }

    @Override
    public synchronized void processMessage(Channel channel, Message message) {
        StatusMessage statusMessage = (StatusMessage)message;
        if (!channel.isActive()) {
            channel.setDiscoveryMode(true);
            channel.send(new StatusMessage());
            channel.getCtx().close();
            return;
        }
        InetSocketAddress socketAddress = channel.getInetSocketAddress();
        NodeStat nodeStat = this.nodeStatMap.get(socketAddress);
        if (nodeStat == null) {
            return;
        }
        long cost = System.currentTimeMillis() - nodeStat.getLastDetectTime();
        if (cost > 2000L || statusMessage.getRemainConnections() == 0) {
            badNodesCache.put((Object)socketAddress.getAddress(), (Object)cost);
            this.nodeStatMap.remove(socketAddress);
        }
        nodeStat.setLastSuccessDetectTime(nodeStat.getLastDetectTime());
        this.setStatusMessage(nodeStat, statusMessage);
        channel.getCtx().close();
    }

    public void notifyDisconnect(Channel channel) {
        if (!channel.isActive()) {
            return;
        }
        InetSocketAddress socketAddress = channel.getInetSocketAddress();
        if (socketAddress == null) {
            return;
        }
        NodeStat nodeStat = this.nodeStatMap.get(socketAddress);
        if (nodeStat == null) {
            return;
        }
        if (nodeStat.getLastDetectTime() != nodeStat.getLastSuccessDetectTime()) {
            badNodesCache.put((Object)socketAddress.getAddress(), (Object)System.currentTimeMillis());
            this.nodeStatMap.remove(socketAddress);
        }
    }

    private synchronized List<NodeStat> getSortedNodeStats() {
        ArrayList<NodeStat> nodeStats = new ArrayList<NodeStat>(this.nodeStatMap.values());
        nodeStats.sort(Comparator.comparingLong(o -> o.getLastDetectTime()));
        return nodeStats;
    }

    private synchronized void setLastDetectTime(NodeStat nodeStat) {
        nodeStat.setLastDetectTime(System.currentTimeMillis());
    }

    private synchronized void setStatusMessage(NodeStat nodeStat, StatusMessage message) {
        nodeStat.setStatusMessage(message);
    }

    public synchronized List<Node> getConnectableNodes() {
        ArrayList<NodeStat> stats = new ArrayList<NodeStat>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.nodeStatMap.values().forEach(stat -> {
            if (stat.getStatusMessage() != null) {
                stats.add((NodeStat)stat);
            }
        });
        if (stats.isEmpty()) {
            return nodes;
        }
        stats.sort(Comparator.comparingInt(o -> -o.getStatusMessage().getRemainConnections()));
        stats.forEach(stat -> nodes.add(stat.getNode()));
        return nodes;
    }

    public static Cache<InetAddress, Long> getBadNodesCache() {
        return badNodesCache;
    }
}

