/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.connection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.P2pEventHandler;
import org.tron.p2p.base.Parameter;
import org.tron.p2p.connection.Channel;
import org.tron.p2p.connection.business.detect.NodeDetectService;
import org.tron.p2p.connection.business.handshake.DisconnectCode;
import org.tron.p2p.connection.business.handshake.HandshakeService;
import org.tron.p2p.connection.business.keepalive.KeepAliveService;
import org.tron.p2p.connection.business.pool.ConnPoolService;
import org.tron.p2p.connection.message.Message;
import org.tron.p2p.connection.message.base.P2pDisconnectMessage;
import org.tron.p2p.connection.socket.PeerClient;
import org.tron.p2p.connection.socket.PeerServer;
import org.tron.p2p.discover.Node;
import org.tron.p2p.exception.P2pException;
import org.tron.p2p.protos.Connect;
import org.tron.p2p.utils.ByteArray;
import org.tron.p2p.utils.NetUtil;

public class ChannelManager {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private static NodeDetectService nodeDetectService;
    private static PeerServer peerServer;
    private static PeerClient peerClient;
    private static ConnPoolService connPoolService;
    private static KeepAliveService keepAliveService;
    private static HandshakeService handshakeService;
    private static final Map<InetSocketAddress, Channel> channels;
    private static final Cache<InetAddress, Long> bannedNodes;
    private static boolean isInit;
    public static volatile boolean isShutdown;

    public static void init() {
        isInit = true;
        peerServer = new PeerServer();
        peerClient = new PeerClient();
        keepAliveService = new KeepAliveService();
        connPoolService = new ConnPoolService();
        handshakeService = new HandshakeService();
        nodeDetectService = new NodeDetectService();
        peerServer.init();
        peerClient.init();
        keepAliveService.init();
        connPoolService.init(peerClient);
        nodeDetectService.init(peerClient);
    }

    public static void connect(InetSocketAddress address) {
        peerClient.connect(address.getAddress().getHostAddress(), address.getPort(), ByteArray.toHexString(NetUtil.getNodeId()));
    }

    public static ChannelFuture connect(Node node, ChannelFutureListener future) {
        return peerClient.connect(node, future);
    }

    public static void notifyDisconnect(Channel channel) {
        if (channel.getInetSocketAddress() == null) {
            log.warn("Notify Disconnect peer has no address.");
            return;
        }
        channels.remove(channel.getInetSocketAddress());
        Parameter.handlerList.forEach(h -> h.onDisconnect(channel));
        InetAddress inetAddress = channel.getInetAddress();
        if (inetAddress != null) {
            ChannelManager.banNode(inetAddress, 60000L);
        }
    }

    public static int getConnectionNum(InetAddress inetAddress) {
        int cnt = 0;
        for (Channel channel : channels.values()) {
            if (!channel.getInetAddress().equals(inetAddress)) continue;
            ++cnt;
        }
        return cnt;
    }

    public static synchronized DisconnectCode processPeer(Channel channel) {
        if (!channel.isActive() && !channel.isTrustPeer()) {
            InetAddress inetAddress = channel.getInetAddress();
            if (bannedNodes.getIfPresent((Object)inetAddress) != null && (Long)bannedNodes.getIfPresent((Object)inetAddress) > System.currentTimeMillis()) {
                log.info("Peer {} recently disconnected", (Object)channel);
                return DisconnectCode.TIME_BANNED;
            }
            if (channels.size() >= Parameter.p2pConfig.getMaxConnections()) {
                log.info("Too many peers, disconnected with {}", (Object)channel);
                return DisconnectCode.TOO_MANY_PEERS;
            }
            int num = ChannelManager.getConnectionNum(channel.getInetAddress());
            if (num >= Parameter.p2pConfig.getMaxConnectionsWithSameIp()) {
                log.info("Max connection with same ip {}", (Object)channel);
                return DisconnectCode.MAX_CONNECTION_WITH_SAME_IP;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)channel.getNodeId())) {
            for (Channel c : channels.values()) {
                if (!channel.getNodeId().equals(c.getNodeId())) continue;
                if (c.getStartTime() > channel.getStartTime()) {
                    c.close();
                    continue;
                }
                log.info("Duplicate peer {}, exist peer {}", (Object)channel, (Object)c);
                return DisconnectCode.DUPLICATE_PEER;
            }
        }
        channels.put(channel.getInetSocketAddress(), channel);
        log.info("Add peer {}, total channels: {}", (Object)channel.getInetSocketAddress(), (Object)channels.size());
        return DisconnectCode.NORMAL;
    }

    public static Connect.DisconnectReason getDisconnectReason(DisconnectCode code) {
        Connect.DisconnectReason disconnectReason;
        switch (code) {
            case DIFFERENT_VERSION: {
                disconnectReason = Connect.DisconnectReason.DIFFERENT_VERSION;
                break;
            }
            case TIME_BANNED: {
                disconnectReason = Connect.DisconnectReason.RECENT_DISCONNECT;
                break;
            }
            case DUPLICATE_PEER: {
                disconnectReason = Connect.DisconnectReason.DUPLICATE_PEER;
                break;
            }
            case TOO_MANY_PEERS: {
                disconnectReason = Connect.DisconnectReason.TOO_MANY_PEERS;
                break;
            }
            case MAX_CONNECTION_WITH_SAME_IP: {
                disconnectReason = Connect.DisconnectReason.TOO_MANY_PEERS_WITH_SAME_IP;
                break;
            }
            default: {
                disconnectReason = Connect.DisconnectReason.UNKNOWN;
            }
        }
        return disconnectReason;
    }

    public static void logDisconnectReason(Channel channel, Connect.DisconnectReason reason) {
        log.info("Try to close channel: {}, reason: {}", (Object)channel.getInetSocketAddress(), (Object)reason.name());
    }

    public static void banNode(InetAddress inetAddress, Long banTime) {
        long now = System.currentTimeMillis();
        if (bannedNodes.getIfPresent((Object)inetAddress) == null || (Long)bannedNodes.getIfPresent((Object)inetAddress) < now) {
            bannedNodes.put((Object)inetAddress, (Object)(now + banTime));
        }
    }

    public static void close() {
        if (!isInit || isShutdown) {
            return;
        }
        isShutdown = true;
        connPoolService.close();
        keepAliveService.close();
        peerServer.close();
        peerClient.close();
        nodeDetectService.close();
    }

    public static void processMessage(Channel channel, byte[] data) throws P2pException {
        if (data == null || data.length == 0) {
            throw new P2pException(P2pException.TypeEnum.EMPTY_MESSAGE, "");
        }
        if (data[0] >= 0) {
            ChannelManager.handMessage(channel, data);
            return;
        }
        Message message = Message.parse(data);
        if (message.needToLog()) {
            log.info("Receive message from channel: {}, {}", (Object)channel.getInetSocketAddress(), (Object)message);
        } else {
            log.debug("Receive message from channel {}, {}", (Object)channel.getInetSocketAddress(), (Object)message);
        }
        switch (message.getType()) {
            case KEEP_ALIVE_PING: 
            case KEEP_ALIVE_PONG: {
                keepAliveService.processMessage(channel, message);
                break;
            }
            case HANDSHAKE_HELLO: {
                handshakeService.processMessage(channel, message);
                break;
            }
            case STATUS: {
                nodeDetectService.processMessage(channel, message);
                break;
            }
            case DISCONNECT: {
                channel.close();
                break;
            }
            default: {
                throw new P2pException(P2pException.TypeEnum.NO_SUCH_MESSAGE, "type:" + data[0]);
            }
        }
    }

    private static void handMessage(Channel channel, byte[] data) throws P2pException {
        P2pEventHandler handler = Parameter.handlerMap.get(data[0]);
        if (handler == null) {
            throw new P2pException(P2pException.TypeEnum.NO_SUCH_MESSAGE, "type:" + data[0]);
        }
        if (channel.isDiscoveryMode()) {
            channel.send(new P2pDisconnectMessage(Connect.DisconnectReason.DISCOVER_MODE));
            channel.getCtx().close();
            return;
        }
        if (!channel.isFinishHandshake()) {
            channel.setFinishHandshake(true);
            DisconnectCode code = ChannelManager.processPeer(channel);
            if (!DisconnectCode.NORMAL.equals((Object)code)) {
                Connect.DisconnectReason disconnectReason = ChannelManager.getDisconnectReason(code);
                channel.send(new P2pDisconnectMessage(disconnectReason));
                channel.getCtx().close();
                return;
            }
            Parameter.handlerList.forEach(h -> h.onConnect(channel));
        }
        handler.onMessage(channel, data);
    }

    public static synchronized void updateNodeId(Channel channel, String nodeId) {
        channel.setNodeId(nodeId);
        if (nodeId.equals(Hex.toHexString((byte[])Parameter.p2pConfig.getNodeID()))) {
            log.warn("Channel {} is myself", (Object)channel.getInetSocketAddress());
            channel.send(new P2pDisconnectMessage(Connect.DisconnectReason.DUPLICATE_PEER));
            channel.close();
            return;
        }
        ArrayList list = new ArrayList();
        channels.values().forEach(c -> {
            if (nodeId.equals(c.getNodeId())) {
                list.add(c);
            }
        });
        if (list.size() <= 1) {
            return;
        }
        Channel c1 = (Channel)list.get(0);
        Channel c2 = (Channel)list.get(1);
        if (c1.getStartTime() > c2.getStartTime()) {
            log.info("Close channel {}, other channel {} is earlier", (Object)c1, (Object)c2);
            c1.send(new P2pDisconnectMessage(Connect.DisconnectReason.DUPLICATE_PEER));
            c1.close();
        } else {
            log.info("Close channel {}, other channel {} is earlier", (Object)c2, (Object)c1);
            c2.send(new P2pDisconnectMessage(Connect.DisconnectReason.DUPLICATE_PEER));
            c2.close();
        }
    }

    public static void triggerConnect(InetSocketAddress address) {
        connPoolService.triggerConnect(address);
    }

    public static NodeDetectService getNodeDetectService() {
        return nodeDetectService;
    }

    public static PeerClient getPeerClient() {
        return peerClient;
    }

    public static ConnPoolService getConnPoolService() {
        return connPoolService;
    }

    public static HandshakeService getHandshakeService() {
        return handshakeService;
    }

    public static Map<InetSocketAddress, Channel> getChannels() {
        return channels;
    }

    public static Cache<InetAddress, Long> getBannedNodes() {
        return bannedNodes;
    }

    static {
        channels = new ConcurrentHashMap<InetSocketAddress, Channel>();
        bannedNodes = CacheBuilder.newBuilder().maximumSize(2000L).build();
        isInit = false;
        isShutdown = false;
    }
}

