/*
 * Decompiled with CFR 0.152.
 */
package org.tron.plugins.comparator;

import java.nio.ByteBuffer;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.DirectSlice;
import org.rocksdb.util.DirectBytewiseComparator;
import org.tron.plugins.utils.MarketUtils;

public class MarketOrderPriceComparatorForRockDB
extends DirectBytewiseComparator {
    public MarketOrderPriceComparatorForRockDB(ComparatorOptions copt) {
        super(copt);
    }

    public String name() {
        return "MarketOrderPriceComparator";
    }

    public int compare(DirectSlice a, DirectSlice b) {
        return MarketUtils.comparePriceKey(this.convertDataToBytes(a), this.convertDataToBytes(b));
    }

    public byte[] convertDataToBytes(DirectSlice directSlice) {
        int capacity = ((ByteBuffer)directSlice.data()).capacity();
        byte[] bytes = new byte[capacity];
        for (int i = 0; i < capacity; ++i) {
            bytes[i] = directSlice.get(i);
        }
        return bytes;
    }
}

