/*
 * Decompiled with CFR 0.152.
 */
package org.tron.plugins;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.tongfei.progressbar.ProgressBar;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Status;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.plugins.utils.DBUtils;
import org.tron.plugins.utils.FileUtils;
import picocli.CommandLine;

@CommandLine.Command(name="convert", description={"Covert leveldb to rocksdb."}, exitCodeListHeading="Exit Codes:%n", exitCodeList={"0:Successful", "n:Internal error: exception occurred,please check toolkit.log"})
public class DbConvert
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger((String)"convert");
    private static final int BATCH = 256;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(index="0", defaultValue="output-directory/database", description={" Input path for leveldb. Default: ${DEFAULT-VALUE}"})
    private File src;
    @CommandLine.Parameters(index="1", defaultValue="output-directory-dst/database", description={"Output path for rocksdb. Default: ${DEFAULT-VALUE}"})
    private File dest;
    @CommandLine.Option(names={"--safe"}, description={"In safe mode, read data from leveldb then put rocksdb.If not, just change engine.properties from leveldb to rocksdb,rocksdb is compatible with leveldb for current version.This may not be the case in the future.Default: ${DEFAULT-VALUE}"})
    private boolean safe;
    @CommandLine.Option(names={"-h", "--help"})
    private boolean help;

    @Override
    public Integer call() throws Exception {
        if (this.help) {
            this.spec.commandLine().usage(System.out);
            return 0;
        }
        if (!this.src.exists()) {
            logger.info(" {} does not exist.", (Object)this.src);
            this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(String.format("%s does not exist.", this.src)));
            return 404;
        }
        List<File> files = Arrays.stream((Object[])Objects.requireNonNull(this.src.listFiles())).filter(File::isDirectory).filter(e -> !"checkpoint".equals(e.getName())).collect(Collectors.toList());
        File cpV2Dir = new File(Paths.get(this.src.toString(), "checkpoint").toString());
        List<Object> cpList = new ArrayList();
        if (cpV2Dir.exists()) {
            cpList = Arrays.stream((Object[])Objects.requireNonNull(cpV2Dir.listFiles())).filter(File::isDirectory).collect(Collectors.toList());
        }
        if (files.isEmpty()) {
            logger.info("{} does not contain any database.", (Object)this.src);
            this.spec.commandLine().getOut().format("%s does not contain any database.", this.src).println();
            return 0;
        }
        long time = System.currentTimeMillis();
        ArrayList services = new ArrayList();
        files.forEach(f -> services.add(new DbConverter(this.src.getPath(), this.dest.getPath(), f.getName(), this.safe)));
        cpList.forEach(f -> services.add(new DbConverter(Paths.get(this.src.getPath(), "checkpoint").toString(), Paths.get(this.dest.getPath(), "checkpoint").toString(), f.getName(), this.safe)));
        List fails = ((Stream)ProgressBar.wrap(services.stream(), (String)"convert task").parallel()).map(dbConverter -> {
            try {
                return dbConverter.doConvert() ? null : dbConverter.name();
            }
            catch (Exception e) {
                logger.error("{}", (Throwable)e);
                this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(e.getMessage()));
                return dbConverter.name();
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        long during = (System.currentTimeMillis() - time) / 1000L;
        this.spec.commandLine().getOut().format("convert db done, fails: %s, take %d s.", fails, during).println();
        logger.info("database convert use {} seconds total, fails: {}.", (Object)during, fails);
        return fails.size();
    }

    private static boolean createEngine(String dir) {
        String enginePath = dir + File.separator + "engine.properties";
        if (!FileUtils.createFileIfNotExists(enginePath)) {
            return false;
        }
        return FileUtils.writeProperty(enginePath, "ENGINE", "ROCKSDB");
    }

    private static boolean checkDone(String dir) {
        String enginePath = dir + File.separator + "engine.properties";
        return FileUtils.isExists(enginePath);
    }

    private static long byteArrayToIntWithOne(long sum, byte[] b) {
        for (byte oneByte : b) {
            sum += (long)oneByte;
        }
        return sum;
    }

    static {
        RocksDB.loadLibrary();
    }

    static class DbConverter
    implements Converter {
        private final String srcDir;
        private final String dstDir;
        private final String dbName;
        private final Path srcDbPath;
        private final Path dstDbPath;
        private long srcDbKeyCount = 0L;
        private long dstDbKeyCount = 0L;
        private long srcDbKeySum = 0L;
        private long dstDbKeySum = 0L;
        private long srcDbValueSum = 0L;
        private long dstDbValueSum = 0L;
        private boolean safe;

        public DbConverter(String srcDir, String dstDir, String name, boolean safe) {
            this.srcDir = srcDir;
            this.dstDir = dstDir;
            this.dbName = name;
            this.srcDbPath = Paths.get(this.srcDir, name);
            this.dstDbPath = Paths.get(this.dstDir, name);
            this.safe = safe;
        }

        @Override
        public boolean doConvert() throws Exception {
            if (DbConvert.checkDone(this.dstDbPath.toString())) {
                logger.info(" {} is done, skip it.", (Object)this.dbName);
                return true;
            }
            File levelDbFile = this.srcDbPath.toFile();
            if (!levelDbFile.exists()) {
                logger.info(" {} does not exist.", (Object)this.srcDbPath);
                return true;
            }
            if (!FileUtils.isLevelDBEngine(this.srcDbPath)) {
                logger.info("Db {},not leveldb, ignored.", (Object)this.dbName);
                return true;
            }
            long startTime = System.currentTimeMillis();
            if (this.dstDbPath.toFile().exists()) {
                logger.info(" {} begin to clear exist database directory", (Object)this.dbName);
                FileUtils.deleteDir(this.dstDbPath.toFile());
                logger.info(" {} clear exist database directory done.", (Object)this.dbName);
            }
            FileUtils.createDirIfNotExists(this.dstDir);
            logger.info("Convert database {} start", (Object)this.dbName);
            if (this.safe) {
                this.convertLevelToRocks();
                this.compact();
            } else {
                FileUtils.copyDir(Paths.get(this.srcDir, new String[0]), Paths.get(this.dstDir, new String[0]), this.dbName);
            }
            boolean result = this.check() && DbConvert.createEngine(this.dstDbPath.toString());
            long etime = System.currentTimeMillis();
            if (result) {
                if (this.safe) {
                    logger.info("Convert database {} successful end with {} key-value {} minutes", new Object[]{this.dbName, this.srcDbKeyCount, (double)(etime - startTime) / 1000.0 / 60.0});
                } else {
                    logger.info("Convert database {} successful end  {} minutes", (Object)this.dbName, (Object)((double)(etime - startTime) / 1000.0 / 60.0));
                }
            } else {
                logger.info("Convert database {} failure", (Object)this.dbName);
                if (this.dstDbPath.toFile().exists()) {
                    logger.info(" {} begin to clear exist database directory", (Object)this.dbName);
                    FileUtils.deleteDir(this.dstDbPath.toFile());
                    logger.info(" {} clear exist database directory done.", (Object)this.dbName);
                }
            }
            return result;
        }

        @Override
        public String name() {
            return this.dbName;
        }

        private void batchInsert(RocksDB rocks, List<byte[]> keys, List<byte[]> values) throws Exception {
            try (WriteBatch batch = new WriteBatch();){
                for (int i = 0; i < keys.size(); ++i) {
                    byte[] k = keys.get(i);
                    byte[] v = values.get(i);
                    batch.put(k, v);
                }
                this.write(rocks, batch);
            }
            keys.clear();
            values.clear();
        }

        private void write(RocksDB rocks, WriteBatch batch) throws Exception {
            try {
                rocks.write(new WriteOptions(), batch);
            }
            catch (RocksDBException e) {
                if (this.maybeRetry(e)) {
                    TimeUnit.MILLISECONDS.sleep(1L);
                    this.write(rocks, batch);
                }
                throw e;
            }
        }

        private boolean maybeRetry(RocksDBException e) {
            boolean retry = false;
            if (e.getStatus() != null) {
                retry = e.getStatus().getCode() == Status.Code.TryAgain || e.getStatus().getCode() == Status.Code.Busy || e.getStatus().getCode() == Status.Code.Incomplete;
            }
            return retry || e.getMessage() != null && ("Write stall".equalsIgnoreCase(e.getMessage()) || "Incomplete".equalsIgnoreCase(e.getMessage()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void convertLevelToRocks() throws Exception {
            ArrayList<byte[]> keys = new ArrayList<byte[]>(256);
            ArrayList<byte[]> values = new ArrayList<byte[]>(256);
            JniDBFactory.pushMemoryPool((int)0x100000);
            try (DB level = DBUtils.newLevelDb(this.srcDbPath);
                 RocksDB rocks = DBUtils.newRocksDbForBulkLoad(this.dstDbPath);
                 DBIterator levelIterator = level.iterator(new ReadOptions().fillCache(false));){
                levelIterator.seekToFirst();
                while (levelIterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)levelIterator.next();
                    byte[] key = (byte[])entry.getKey();
                    byte[] value = (byte[])entry.getValue();
                    ++this.srcDbKeyCount;
                    this.srcDbKeySum = DbConvert.byteArrayToIntWithOne(this.srcDbKeySum, key);
                    this.srcDbValueSum = DbConvert.byteArrayToIntWithOne(this.srcDbValueSum, value);
                    keys.add(key);
                    values.add(value);
                    if (keys.size() < 256) continue;
                    this.batchInsert(rocks, keys, values);
                }
                if (!keys.isEmpty()) {
                    this.batchInsert(rocks, keys, values);
                }
            }
            finally {
                JniDBFactory.popMemoryPool();
            }
        }

        private void compact() throws RocksDBException {
            if ("market_pair_price_to_order".equalsIgnoreCase(this.dbName)) {
                return;
            }
            try (RocksDB rocks = DBUtils.newRocksDb(this.dstDbPath);){
                logger.info("compact database {} start", (Object)this.dbName);
                rocks.compactRange();
                logger.info("compact database {} end", (Object)this.dbName);
            }
        }

        /*
         * Exception decompiling
         */
        private boolean check() throws RocksDBException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static interface Converter {
        public boolean doConvert() throws Exception;

        public String name();
    }
}

