/*
 * Decompiled with CFR 0.152.
 */
package org.tron.tool.litefullnode;

import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.FileUtil;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger((String)"tool");

    public static void copyDatabases(Path src, Path dest, List<String> subDirs) throws IOException {
        subDirs.forEach(dir -> {
            if (FileUtil.isExists((String)Paths.get(src.toString(), dir).toString())) {
                try {
                    Files.walk(Paths.get(src.toString(), dir), FileVisitOption.FOLLOW_LINKS).forEach(source -> Util.copy(source, dest.resolve(src.relativize((Path)source))));
                }
                catch (IOException e) {
                    logger.error("copy database failed, src: {}, dest: {}, error: {}", new Object[]{Paths.get(src.toString(), dir), Paths.get(dest.toString(), dir), e.getMessage()});
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void copy(Path source, Path dest) {
        try {
            if (source.toString().endsWith(".sst")) {
                try {
                    Files.createLink(dest, source);
                }
                catch (FileSystemException e) {
                    Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
                }
            } else {
                Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

