/*
 * Decompiled with CFR 0.152.
 */
package org.tron.program;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBComparator;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.rocksdb.AbstractComparator;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.Filter;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Status;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.FileUtil;
import org.tron.common.utils.MarketOrderPriceComparatorForLevelDB;
import org.tron.common.utils.MarketOrderPriceComparatorForRockDB;
import org.tron.common.utils.PropUtil;

public class DBConvert
implements Callable<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(DBConvert.class);
    private final String srcDir;
    private final String dstDir;
    private final String dbName;
    private final Path srcDbPath;
    private final Path dstDbPath;
    private long srcDbKeyCount = 0L;
    private long dstDbKeyCount = 0L;
    private long srcDbKeySum = 0L;
    private long dstDbKeySum = 0L;
    private long srcDbValueSum = 0L;
    private long dstDbValueSum = 0L;
    private final long startTime;
    private static final int CPUS;
    private static final int BATCH = 256;
    private static final String CHECKPOINT_V2_DIR_NAME = "checkpoint";

    @Override
    public Boolean call() throws Exception {
        return this.doConvert();
    }

    public DBConvert(String src, String dst, String name) {
        this.srcDir = src;
        this.dstDir = dst;
        this.dbName = name;
        this.srcDbPath = Paths.get(this.srcDir, name);
        this.dstDbPath = Paths.get(this.dstDir, name);
        this.startTime = System.currentTimeMillis();
    }

    public static Options newDefaultLevelDbOptions() {
        Options dbOptions = new Options();
        dbOptions.createIfMissing(true);
        dbOptions.paranoidChecks(true);
        dbOptions.verifyChecksums(true);
        dbOptions.compressionType(CompressionType.SNAPPY);
        dbOptions.blockSize(4096);
        dbOptions.writeBufferSize(0xA00000);
        dbOptions.cacheSize(0xA00000L);
        dbOptions.maxOpenFiles(1000);
        return dbOptions;
    }

    public static void main(String[] args) {
        int code2 = DBConvert.run(args);
        logger.info("exit code {}.", (Object)code2);
        System.out.printf("exit code %d.\n", code2);
        System.exit(code2);
    }

    public static int run(String[] args) {
        String dbDst;
        String dbSrc;
        if (args.length < 2) {
            dbSrc = "output-directory/database";
            dbDst = "output-directory-dst/database";
        } else {
            dbSrc = args[0];
            dbDst = args[1];
        }
        File dbDirectory = new File(dbSrc);
        if (!dbDirectory.exists()) {
            logger.info(" {} does not exist.", (Object)dbSrc);
            return 404;
        }
        List<File> files = Arrays.stream((Object[])Objects.requireNonNull(dbDirectory.listFiles())).filter(File::isDirectory).filter(e -> !CHECKPOINT_V2_DIR_NAME.equals(e.getName())).collect(Collectors.toList());
        File cpV2Dir = new File(Paths.get(dbSrc, CHECKPOINT_V2_DIR_NAME).toString());
        List<File> cpList = null;
        if (cpV2Dir.exists()) {
            cpList = Arrays.stream((Object[])Objects.requireNonNull(cpV2Dir.listFiles())).filter(File::isDirectory).collect(Collectors.toList());
        }
        if (files.isEmpty()) {
            logger.info("{} does not contain any database.", (Object)dbSrc);
            return 0;
        }
        long time = System.currentTimeMillis();
        ArrayList res = new ArrayList();
        ThreadPoolExecutor esDb = new ThreadPoolExecutor(CPUS, 16 * CPUS, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(CPUS, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        esDb.allowCoreThreadTimeOut(true);
        files.forEach(f -> res.add(esDb.submit(new DBConvert(dbSrc, dbDst, f.getName()))));
        if (cpList != null) {
            cpList.forEach(f -> res.add(esDb.submit(new DBConvert(dbSrc + "/" + CHECKPOINT_V2_DIR_NAME, dbDst + "/" + CHECKPOINT_V2_DIR_NAME, f.getName()))));
        }
        int fails = res.size();
        for (Future re : res) {
            try {
                if (!((Boolean)re.get()).booleanValue()) continue;
                --fails;
            }
            catch (InterruptedException e2) {
                logger.error("{}", (Throwable)e2);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e3) {
                logger.error("{}", (Throwable)e3);
            }
        }
        esDb.shutdown();
        logger.info("database convert use {} seconds total.", (Object)((System.currentTimeMillis() - time) / 1000L));
        if (fails > 0) {
            logger.error("failed!!!!!!!!!!!!!!!!!!!!!!!! size:{}", (Object)fails);
        }
        return fails;
    }

    public DB newLevelDb(Path db) throws Exception {
        File file = db.toFile();
        Options dbOptions = DBConvert.newDefaultLevelDbOptions();
        if ("market_pair_price_to_order".equalsIgnoreCase(this.dbName)) {
            dbOptions.comparator((DBComparator)new MarketOrderPriceComparatorForLevelDB());
        }
        DB database = JniDBFactory.factory.open(file, dbOptions);
        return database;
    }

    private org.rocksdb.Options newDefaultRocksDbOptions() {
        org.rocksdb.Options options = new org.rocksdb.Options();
        options.setCreateIfMissing(true);
        options.setIncreaseParallelism(1);
        options.setNumLevels(7);
        options.setMaxOpenFiles(5000);
        options.setTargetFileSizeBase(0x4000000L);
        options.setTargetFileSizeMultiplier(1);
        options.setMaxBytesForLevelBase(0x20000000L);
        options.setMaxBackgroundCompactions(Math.max(1, Runtime.getRuntime().availableProcessors()));
        options.setLevel0FileNumCompactionTrigger(4);
        options.setLevelCompactionDynamicLevelBytes(true);
        if ("market_pair_price_to_order".equalsIgnoreCase(this.dbName)) {
            options.setComparator((AbstractComparator)new MarketOrderPriceComparatorForRockDB(new ComparatorOptions()));
        }
        BlockBasedTableConfig tableCfg = new BlockBasedTableConfig();
        options.setTableFormatConfig((TableFormatConfig)tableCfg);
        tableCfg.setBlockSize(65536L);
        tableCfg.setBlockCacheSize(0x2000000L);
        tableCfg.setCacheIndexAndFilterBlocks(true);
        tableCfg.setPinL0FilterAndIndexBlocksInCache(true);
        tableCfg.setFilter((Filter)new BloomFilter(10, false));
        options.prepareForBulkLoad();
        return options;
    }

    public RocksDB newRocksDb(Path db) {
        RocksDB database = null;
        try (org.rocksdb.Options options = this.newDefaultRocksDbOptions();){
            database = RocksDB.open((org.rocksdb.Options)options, (String)db.toString());
        }
        catch (Exception e) {
            logger.error("{}", (Throwable)e);
        }
        return database;
    }

    private void batchInsert(RocksDB rocks, List<byte[]> keys, List<byte[]> values) throws Exception {
        try (WriteBatch batch = new WriteBatch();){
            for (int i = 0; i < keys.size(); ++i) {
                byte[] k = keys.get(i);
                byte[] v = values.get(i);
                batch.put(k, v);
            }
            this.write(rocks, batch);
        }
        keys.clear();
        values.clear();
    }

    private void write(RocksDB rocks, WriteBatch batch) throws Exception {
        try {
            rocks.write(new WriteOptions(), batch);
        }
        catch (RocksDBException e) {
            if (this.maybeRetry(e)) {
                TimeUnit.MILLISECONDS.sleep(1L);
                this.write(rocks, batch);
            }
            throw e;
        }
    }

    private boolean maybeRetry(RocksDBException e) {
        boolean retry = false;
        if (e.getStatus() != null) {
            retry = e.getStatus().getCode() == Status.Code.TryAgain || e.getStatus().getCode() == Status.Code.Busy || e.getStatus().getCode() == Status.Code.Incomplete;
        }
        return retry || e.getMessage() != null && ("Write stall".equalsIgnoreCase(e.getMessage()) || "Incomplete".equalsIgnoreCase(e.getMessage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean convertLevelToRocksBatchIterator(DB level, RocksDB rocks) {
        ArrayList<byte[]> keys = new ArrayList<byte[]>(256);
        ArrayList<byte[]> values = new ArrayList<byte[]>(256);
        try (DBIterator levelIterator = level.iterator(new org.iq80.leveldb.ReadOptions().fillCache(false));){
            JniDBFactory.pushMemoryPool((int)0x100000);
            levelIterator.seekToFirst();
            while (levelIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)levelIterator.next();
                byte[] key = (byte[])entry.getKey();
                byte[] value = (byte[])entry.getValue();
                ++this.srcDbKeyCount;
                this.srcDbKeySum = this.byteArrayToIntWithOne(this.srcDbKeySum, key);
                this.srcDbValueSum = this.byteArrayToIntWithOne(this.srcDbValueSum, value);
                keys.add(key);
                values.add(value);
                if (keys.size() < 256) continue;
                try {
                    this.batchInsert(rocks, keys, values);
                }
                catch (Exception e) {
                    logger.error("{}", (Throwable)e);
                    boolean bl = false;
                    if (levelIterator != null) {
                        if (var6_8 != null) {
                            try {
                                levelIterator.close();
                            }
                            catch (Throwable throwable) {
                                var6_8.addSuppressed(throwable);
                            }
                        } else {
                            levelIterator.close();
                        }
                    }
                    try {
                        level.close();
                        rocks.close();
                        JniDBFactory.popMemoryPool();
                    }
                    catch (Exception e1) {
                        logger.error("{}", (Throwable)e1);
                    }
                    return bl;
                }
            }
            if (!keys.isEmpty()) {
                try {
                    this.batchInsert(rocks, keys, values);
                }
                catch (Exception e) {
                    logger.error("{}", (Throwable)e);
                    boolean bl = false;
                    if (levelIterator != null) {
                        if (var6_8 != null) {
                            try {
                                levelIterator.close();
                            }
                            catch (Throwable value) {
                                var6_8.addSuppressed(value);
                            }
                        } else {
                            levelIterator.close();
                        }
                    }
                    try {
                        level.close();
                        rocks.close();
                        JniDBFactory.popMemoryPool();
                    }
                    catch (Exception e1) {
                        logger.error("{}", (Throwable)e1);
                    }
                    return bl;
                }
            }
            this.check(rocks);
        }
        catch (Exception e) {
            logger.error("{}", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                level.close();
                rocks.close();
                JniDBFactory.popMemoryPool();
            }
            catch (Exception e1) {
                logger.error("{}", (Throwable)e1);
            }
        }
        return this.dstDbKeyCount == this.srcDbKeyCount && this.dstDbKeySum == this.srcDbKeySum && this.dstDbValueSum == this.srcDbValueSum;
    }

    private void check(RocksDB rocks) throws RocksDBException {
        logger.info("check database {} start", (Object)this.dbName);
        logger.info("compact database {} start", (Object)this.dbName);
        rocks.compactRange();
        logger.info("compact database {} end", (Object)this.dbName);
        try (ReadOptions r = new ReadOptions().setFillCache(false);
             RocksIterator rocksIterator = rocks.newIterator(r);){
            rocksIterator.seekToFirst();
            while (rocksIterator.isValid()) {
                byte[] key = rocksIterator.key();
                byte[] value = rocksIterator.value();
                ++this.dstDbKeyCount;
                this.dstDbKeySum = this.byteArrayToIntWithOne(this.dstDbKeySum, key);
                this.dstDbValueSum = this.byteArrayToIntWithOne(this.dstDbValueSum, value);
                rocksIterator.next();
            }
        }
        logger.info("check database {} end", (Object)this.dbName);
    }

    public boolean createEngine(String dir) {
        String enginePath = dir + File.separator + "engine.properties";
        if (!FileUtil.createFileIfNotExists((String)enginePath)) {
            return false;
        }
        return PropUtil.writeProperty((String)enginePath, (String)"ENGINE", (String)"ROCKSDB");
    }

    public boolean checkDone(String dir) {
        String enginePath = dir + File.separator + "engine.properties";
        return FileUtil.isExists((String)enginePath);
    }

    public boolean doConvert() throws Exception {
        if (this.checkDone(this.dstDbPath.toString())) {
            logger.info(" {} is done, skip it.", (Object)this.dbName);
            return true;
        }
        File levelDbFile = this.srcDbPath.toFile();
        if (!levelDbFile.exists()) {
            logger.info(" {} does not exist.", (Object)this.srcDbPath.toString());
            return false;
        }
        DB level = this.newLevelDb(this.srcDbPath);
        if (this.dstDbPath.toFile().exists()) {
            logger.info(" {} begin to clear exist database directory", (Object)this.dbName);
            FileUtil.deleteDir((File)this.dstDbPath.toFile());
            logger.info(" {} clear exist database directory done.", (Object)this.dbName);
        }
        FileUtil.createDirIfNotExists((String)this.dstDir);
        RocksDB rocks = this.newRocksDb(this.dstDbPath);
        logger.info("Convert database {} start", (Object)this.dbName);
        boolean result = this.convertLevelToRocksBatchIterator(level, rocks) && this.createEngine(this.dstDbPath.toString());
        long etime = System.currentTimeMillis();
        if (result) {
            logger.info("Convert database {} successful end with {} key-value {} minutes", new Object[]{this.dbName, this.srcDbKeyCount, (double)(etime - this.startTime) / 1000.0 / 60.0});
        } else {
            logger.info("Convert database {} failure", (Object)this.dbName);
            if (this.dstDbPath.toFile().exists()) {
                logger.info(" {} begin to clear exist database directory", (Object)this.dbName);
                FileUtil.deleteDir((File)this.dstDbPath.toFile());
                logger.info(" {} clear exist database directory done.", (Object)this.dbName);
            }
        }
        return result;
    }

    public long byteArrayToIntWithOne(long sum, byte[] b) {
        for (byte oneByte : b) {
            sum += (long)oneByte;
        }
        return sum;
    }

    static {
        RocksDB.loadLibrary();
        CPUS = Runtime.getRuntime().availableProcessors();
    }
}

