/*
 * Decompiled with CFR 0.152.
 */
package org.tron.keystore;

import java.util.Objects;
import org.tron.common.crypto.SignInterface;
import org.tron.common.crypto.sm2.SM2;
import org.tron.common.utils.StringUtil;

public class Credentials {
    private final SignInterface cryptoEngine;
    private final String address;

    private Credentials(SignInterface cryptoEngine, String address) {
        this.cryptoEngine = cryptoEngine;
        this.address = address;
    }

    public static Credentials create(SignInterface cryptoEngine) {
        String address = StringUtil.encode58Check((byte[])cryptoEngine.getAddress());
        return new Credentials(cryptoEngine, address);
    }

    public static Credentials create(SM2 sm2Pair) {
        String address = StringUtil.encode58Check((byte[])sm2Pair.getAddress());
        return new Credentials((SignInterface)sm2Pair, address);
    }

    public SignInterface getSignInterface() {
        return this.cryptoEngine;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credentials that = (Credentials)o;
        if (!Objects.equals(this.cryptoEngine, that.cryptoEngine)) {
            return false;
        }
        return Objects.equals(this.address, that.address);
    }

    public int hashCode() {
        int result = this.cryptoEngine != null ? this.cryptoEngine.hashCode() : 0;
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        return result;
    }
}

