/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.zen.note;

import java.util.Optional;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.zen.note.NoteEncryption;

public class OutgoingPlaintext {
    private byte[] pkD;
    private byte[] esk;

    private static OutgoingPlaintext decode(NoteEncryption.Encryption.OutPlaintext outPlaintext) {
        byte[] data = outPlaintext.getData();
        OutgoingPlaintext ret = new OutgoingPlaintext(new byte[32], new byte[32]);
        System.arraycopy(data, 0, ret.pkD, 0, 32);
        System.arraycopy(data, 32, ret.esk, 0, 32);
        return ret;
    }

    public static Optional<OutgoingPlaintext> decrypt(NoteEncryption.Encryption.OutCiphertext ciphertext, byte[] ovk, byte[] cv, byte[] cm, byte[] epk) throws ZksnarkException {
        Optional<NoteEncryption.Encryption.OutPlaintext> pt = NoteEncryption.Encryption.attemptOutDecryption(ciphertext, ovk, cv, cm, epk);
        if (!pt.isPresent()) {
            return Optional.empty();
        }
        OutgoingPlaintext ret = OutgoingPlaintext.decode(pt.get());
        return Optional.of(ret);
    }

    private NoteEncryption.Encryption.OutPlaintext encode() {
        NoteEncryption.Encryption.OutPlaintext ret = new NoteEncryption.Encryption.OutPlaintext();
        ret.setData(new byte[64]);
        System.arraycopy(this.pkD, 0, ret.getData(), 0, 32);
        System.arraycopy(this.esk, 0, ret.getData(), 32, 32);
        return ret;
    }

    public NoteEncryption.Encryption.OutCiphertext encrypt(byte[] ovk, byte[] cv, byte[] cm, NoteEncryption enc) throws ZksnarkException {
        NoteEncryption.Encryption.OutPlaintext pt = this.encode();
        return enc.encryptToOurselves(ovk, cv, cm, pt);
    }

    public OutgoingPlaintext(byte[] pkD, byte[] esk) {
        this.pkD = pkD;
        this.esk = esk;
    }

    public byte[] getPkD() {
        return this.pkD;
    }

    public void setPkD(byte[] pkD) {
        this.pkD = pkD;
    }

    public byte[] getEsk() {
        return this.esk;
    }

    public void setEsk(byte[] esk) {
        this.esk = esk;
    }
}

