/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.zen.address;

import java.security.SecureRandom;
import java.util.Optional;
import org.tron.common.utils.ByteArray;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.common.zksnark.JLibsodium;
import org.tron.common.zksnark.JLibsodiumParam;
import org.tron.core.Constant;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.zen.address.DiversifierT;
import org.tron.core.zen.address.ExpandedSpendingKey;
import org.tron.core.zen.address.FullViewingKey;
import org.tron.core.zen.address.PaymentAddress;

public class SpendingKey {
    public byte[] value;
    private static SecureRandom random = new SecureRandom();

    public static SpendingKey random() throws ZksnarkException {
        SpendingKey sk;
        while (!(sk = new SpendingKey(SpendingKey.randomUint256())).fullViewingKey().isValid()) {
        }
        return sk;
    }

    public static SpendingKey decode(String hex) {
        return new SpendingKey(ByteArray.fromHexString((String)hex));
    }

    private static byte[] randomUint256() {
        byte[] result = new byte[32];
        random.nextBytes(result);
        Integer i = result[0] & 0xF;
        result[0] = i.byteValue();
        return result;
    }

    public String encode() {
        return ByteArray.toHexString((byte[])this.value);
    }

    public ExpandedSpendingKey expandedSpendingKey() throws ZksnarkException {
        return new ExpandedSpendingKey(PRF.prfAsk(this.value), PRF.prfNsk(this.value), PRF.prfOvk(this.value));
    }

    public FullViewingKey fullViewingKey() throws ZksnarkException {
        return this.expandedSpendingKey().fullViewingKey();
    }

    public PaymentAddress defaultAddress() throws BadItemException, ZksnarkException {
        Optional<PaymentAddress> addrOpt = this.fullViewingKey().inViewingKey().address(this.defaultDiversifier());
        if (addrOpt.isPresent()) {
            return addrOpt.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiversifierT defaultDiversifier() throws BadItemException, ZksnarkException {
        byte[] res = new byte[11];
        byte[] blob = new byte[34];
        System.arraycopy(this.value, 0, blob, 0, 32);
        blob[32] = 3;
        blob[33] = 0;
        while (true) {
            long state = JLibsodium.initState();
            try {
                JLibsodium.cryptoGenerichashBlake2bInitSaltPersonal((JLibsodiumParam.Blake2bInitSaltPersonalParams)new JLibsodiumParam.Blake2bInitSaltPersonalParams(state, null, 0, 64, null, Constant.ZTRON_EXPANDSEED_PERSONALIZATION));
                JLibsodium.cryptoGenerichashBlake2bUpdate((JLibsodiumParam.Blake2bUpdateParams)new JLibsodiumParam.Blake2bUpdateParams(state, blob, 34L));
                JLibsodium.cryptoGenerichashBlake2bFinal((JLibsodiumParam.Blake2bFinalParams)new JLibsodiumParam.Blake2bFinalParams(state, res, 11));
                if (JLibrustzcash.librustzcashCheckDiversifier((byte[])res)) break;
                if (blob[33] == -1) {
                    throw new BadItemException("librustzcash_check_diversifier does not return valid diversifier");
                }
                blob[33] = (byte)(blob[33] + 1);
                continue;
            }
            finally {
                JLibsodium.freeState((long)state);
                continue;
            }
            break;
        }
        DiversifierT diversifierT = new DiversifierT();
        diversifierT.setData(res);
        return diversifierT;
    }

    public SpendingKey(byte[] value) {
        this.value = value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    private static class PRF {
        private PRF() {
        }

        public static byte[] prfAsk(byte[] sk) throws ZksnarkException {
            byte[] ask = new byte[32];
            byte t = 0;
            byte[] tmp = PRF.prfExpand(sk, t);
            JLibrustzcash.librustzcashToScalar((byte[])tmp, (byte[])ask);
            return ask;
        }

        public static byte[] prfNsk(byte[] sk) throws ZksnarkException {
            byte[] nsk = new byte[32];
            byte t = 1;
            byte[] tmp = PRF.prfExpand(sk, t);
            JLibrustzcash.librustzcashToScalar((byte[])tmp, (byte[])nsk);
            return nsk;
        }

        public static byte[] prfOvk(byte[] sk) throws ZksnarkException {
            byte[] ovk = new byte[32];
            byte t = 2;
            byte[] tmp = PRF.prfExpand(sk, t);
            System.arraycopy(tmp, 0, ovk, 0, 32);
            return ovk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static byte[] prfExpand(byte[] sk, byte t) throws ZksnarkException {
            byte[] res = new byte[64];
            byte[] blob = new byte[33];
            System.arraycopy(sk, 0, blob, 0, 32);
            blob[32] = t;
            long state = JLibsodium.initState();
            try {
                JLibsodium.cryptoGenerichashBlake2bInitSaltPersonal((JLibsodiumParam.Blake2bInitSaltPersonalParams)new JLibsodiumParam.Blake2bInitSaltPersonalParams(state, null, 0, 64, null, Constant.ZTRON_EXPANDSEED_PERSONALIZATION));
                JLibsodium.cryptoGenerichashBlake2bUpdate((JLibsodiumParam.Blake2bUpdateParams)new JLibsodiumParam.Blake2bUpdateParams(state, blob, 33L));
                JLibsodium.cryptoGenerichashBlake2bFinal((JLibsodiumParam.Blake2bFinalParams)new JLibsodiumParam.Blake2bFinalParams(state, res, 64));
            }
            finally {
                JLibsodium.freeState((long)state);
            }
            return res;
        }
    }
}

