/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.zen.address;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.tron.common.utils.Bech32;
import org.tron.core.zen.address.PaymentAddress;

public class KeyIo {
    private static int CONVERTED_SAPLING_PAYMENT_ADDRESS_SIZE = 69;
    private static String SAPLING_PAYMENT_ADDRESS = "ztron";

    public static PaymentAddress decodePaymentAddress(String str) {
        Bech32.Bech32Data bech = Bech32.decode((String)str);
        if (bech.hrp.equals(SAPLING_PAYMENT_ADDRESS) && bech.data.length == CONVERTED_SAPLING_PAYMENT_ADDRESS_SIZE) {
            byte[] data = KeyIo.convertBits(bech.data, 0, CONVERTED_SAPLING_PAYMENT_ADDRESS_SIZE, 5, 8, false);
            return PaymentAddress.decode(data);
        }
        return null;
    }

    public static String encodePaymentAddress(PaymentAddress zaddr) {
        byte[] serAddr = zaddr.encode();
        ArrayList<Byte> progBytes = new ArrayList<Byte>();
        for (int i = 0; i < serAddr.length; ++i) {
            progBytes.add(serAddr[i]);
        }
        byte[] prog = KeyIo.convertBits(progBytes, 8, 5, true);
        return Bech32.encode((String)SAPLING_PAYMENT_ADDRESS, (byte[])prog);
    }

    private static byte[] convertBits(byte[] in, int inStart, int inLen, int fromBits, int toBits, boolean pad) throws IllegalArgumentException {
        int acc = 0;
        int bits = 0;
        int size = inLen;
        ByteArrayOutputStream out = new ByteArrayOutputStream(size);
        int maxv = (1 << toBits) - 1;
        int maxAcc = (1 << fromBits + toBits - 1) - 1;
        for (int i = 0; i < inLen; ++i) {
            int value = in[i + inStart] & 0xFF;
            if (value >>> fromBits != 0) {
                throw new IllegalArgumentException(String.format("Input value '%X' exceeds '%d' bit size", value, fromBits));
            }
            acc = (acc << fromBits | value) & maxAcc;
            bits += fromBits;
            while (bits >= toBits) {
                out.write(acc >>> (bits -= toBits) & maxv);
            }
        }
        if (pad) {
            if (bits > 0) {
                out.write(acc << toBits - bits & maxv);
            }
        } else if (bits >= fromBits || (acc << toBits - bits & maxv) != 0) {
            throw new IllegalArgumentException("Could not convert bits, invalid padding");
        }
        return out.toByteArray();
    }

    private static byte[] convertBits(List<Byte> data, int fromBits, int toBits, boolean pad) {
        int acc = 0;
        int bits = 0;
        int maxv = (1 << toBits) - 1;
        ArrayList<Byte> ret = new ArrayList<Byte>();
        for (Byte value : data) {
            short b = (short)(value & 0xFF);
            if (b < 0) {
                throw new IllegalArgumentException();
            }
            if (b >> fromBits > 0) {
                throw new IllegalArgumentException();
            }
            acc = acc << fromBits | b;
            bits += fromBits;
            while (bits >= toBits) {
                ret.add((byte)(acc >> (bits -= toBits) & maxv));
            }
        }
        if (pad && bits > 0) {
            ret.add((byte)(acc << toBits - bits & maxv));
        } else if (bits >= fromBits || (byte)(acc << toBits - bits & maxv) != 0) {
            return null;
        }
        byte[] buf = new byte[ret.size()];
        for (int i = 0; i < ret.size(); ++i) {
            buf[i] = (Byte)ret.get(i);
        }
        return buf;
    }
}

