/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.zen.address;

import java.util.Arrays;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.common.zksnark.LibrustzcashParam;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.zen.address.IncomingViewingKey;

public class FullViewingKey {
    private byte[] ak;
    private byte[] nk;
    private byte[] ovk;

    public static FullViewingKey decode(byte[] data) {
        byte[] ak = new byte[32];
        byte[] nk = new byte[32];
        byte[] ovk = new byte[32];
        System.arraycopy(data, 0, ak, 0, 32);
        System.arraycopy(data, 32, nk, 0, 32);
        System.arraycopy(data, 64, ovk, 0, 32);
        return new FullViewingKey(ak, nk, ovk);
    }

    public IncomingViewingKey inViewingKey() throws ZksnarkException {
        byte[] ivk = new byte[32];
        JLibrustzcash.librustzcashCrhIvk((LibrustzcashParam.CrhIvkParams)new LibrustzcashParam.CrhIvkParams(this.ak, this.nk, ivk));
        return new IncomingViewingKey(ivk);
    }

    public boolean isValid() throws ZksnarkException {
        byte[] ivk = new byte[32];
        JLibrustzcash.librustzcashCrhIvk((LibrustzcashParam.CrhIvkParams)new LibrustzcashParam.CrhIvkParams(this.ak, this.nk, ivk));
        return !Arrays.equals(ivk, new byte[32]);
    }

    public byte[] encode() {
        byte[] m_bytes = new byte[96];
        System.arraycopy(this.ak, 0, m_bytes, 0, 32);
        System.arraycopy(this.nk, 0, m_bytes, 32, 32);
        System.arraycopy(this.ovk, 0, m_bytes, 64, 32);
        return m_bytes;
    }

    public FullViewingKey(byte[] ak, byte[] nk, byte[] ovk) {
        this.ak = ak;
        this.nk = nk;
        this.ovk = ovk;
    }

    public byte[] getAk() {
        return this.ak;
    }

    public void setAk(byte[] ak) {
        this.ak = ak;
    }

    public byte[] getNk() {
        return this.nk;
    }

    public void setNk(byte[] nk) {
        this.nk = nk;
    }

    public byte[] getOvk() {
        return this.ovk;
    }

    public void setOvk(byte[] ovk) {
        this.ovk = ovk;
    }
}

