/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.zen;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.zksnark.IncrementalMerkleVoucherContainer;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.common.zksnark.LibrustzcashParam;
import org.tron.core.Wallet;
import org.tron.core.capsule.ReceiveDescriptionCapsule;
import org.tron.core.capsule.SpendDescriptionCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.zen.address.DiversifierT;
import org.tron.core.zen.address.ExpandedSpendingKey;
import org.tron.core.zen.address.PaymentAddress;
import org.tron.core.zen.note.Note;
import org.tron.core.zen.note.NoteEncryption;
import org.tron.core.zen.note.OutgoingPlaintext;
import org.tron.protos.Protocol;
import org.tron.protos.contract.ShieldContract;

public class ZenTransactionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ZenTransactionBuilder.class);
    private String from;
    private List<SpendDescriptionInfo> spends = new ArrayList<SpendDescriptionInfo>();
    private List<ReceiveDescriptionInfo> receives = new ArrayList<ReceiveDescriptionInfo>();
    private Wallet wallet;
    private long valueBalance = 0L;
    private long timeout = 0L;
    private ShieldContract.ShieldedTransferContract.Builder contractBuilder = ShieldContract.ShieldedTransferContract.newBuilder();

    public ZenTransactionBuilder(Wallet wallet) {
        this.wallet = wallet;
    }

    public ZenTransactionBuilder() {
    }

    public void addSpend(SpendDescriptionInfo spendDescriptionInfo) {
        this.spends.add(spendDescriptionInfo);
        this.valueBalance += spendDescriptionInfo.note.getValue();
    }

    public void addSpend(ExpandedSpendingKey expsk, Note note, byte[] anchor, IncrementalMerkleVoucherContainer voucher) throws ZksnarkException {
        this.spends.add(new SpendDescriptionInfo(expsk, note, anchor, voucher));
        this.valueBalance += note.getValue();
    }

    public void addSpend(ExpandedSpendingKey expsk, Note note, byte[] alpha, byte[] anchor, IncrementalMerkleVoucherContainer voucher) {
        this.spends.add(new SpendDescriptionInfo(expsk, note, alpha, anchor, voucher));
        this.valueBalance += note.getValue();
    }

    public void addSpend(byte[] ak, byte[] nsk, byte[] ovk, Note note, byte[] alpha, byte[] anchor, IncrementalMerkleVoucherContainer voucher) {
        this.spends.add(new SpendDescriptionInfo(ak, nsk, ovk, note, alpha, anchor, voucher));
        this.valueBalance += note.getValue();
    }

    public void addOutput(byte[] ovk, PaymentAddress to, long value, byte[] memo) throws ZksnarkException {
        Note note = new Note(to, value);
        note.setMemo(memo);
        this.receives.add(new ReceiveDescriptionInfo(ovk, note));
        this.valueBalance -= value;
    }

    public void addOutput(byte[] ovk, DiversifierT d, byte[] pkD, long value, byte[] r, byte[] memo) {
        Note note = new Note(d, pkD, value, r);
        note.setMemo(memo);
        this.receives.add(new ReceiveDescriptionInfo(ovk, note));
        this.valueBalance -= value;
    }

    public void setTransparentInput(byte[] address, long value) {
        this.contractBuilder.setTransparentFromAddress(ByteString.copyFrom((byte[])address)).setFromAmount(value);
    }

    public void setTransparentOutput(byte[] address, long value) {
        this.contractBuilder.setTransparentToAddress(ByteString.copyFrom((byte[])address)).setToAmount(value);
    }

    public TransactionCapsule buildWithoutAsk() throws ZksnarkException {
        return this.build(false);
    }

    public TransactionCapsule build() throws ZksnarkException {
        return this.build(true);
    }

    public TransactionCapsule build(boolean withAsk) throws ZksnarkException {
        TransactionCapsule transactionCapsule;
        long ctx = JLibrustzcash.librustzcashSaplingProvingCtxInit();
        try {
            for (SpendDescriptionInfo spend : this.spends) {
                SpendDescriptionCapsule spendDescriptionCapsule = this.generateSpendProof(spend, ctx);
                this.contractBuilder.addSpendDescription(spendDescriptionCapsule.getInstance());
            }
            for (ReceiveDescriptionInfo receive : this.receives) {
                ReceiveDescriptionCapsule receiveDescriptionCapsule = this.generateOutputProof(receive, ctx);
                this.contractBuilder.addReceiveDescription(receiveDescriptionCapsule.getInstance());
            }
            transactionCapsule = this.wallet.createTransactionCapsuleWithoutValidate((Message)this.contractBuilder.build(), Protocol.Transaction.Contract.ContractType.ShieldedTransferContract, this.timeout);
            byte[] dataHashToBeSigned = TransactionCapsule.getShieldTransactionHashIgnoreTypeException((Protocol.Transaction)transactionCapsule.getInstance());
            if (dataHashToBeSigned == null) {
                throw new ZksnarkException("cal transaction hash failed");
            }
            if (withAsk) {
                this.createSpendAuth(dataHashToBeSigned);
            }
            byte[] bindingSig = new byte[64];
            JLibrustzcash.librustzcashSaplingBindingSig((LibrustzcashParam.BindingSigParams)new LibrustzcashParam.BindingSigParams(ctx, this.valueBalance, dataHashToBeSigned, bindingSig));
            this.contractBuilder.setBindingSignature(ByteString.copyFrom((byte[])bindingSig));
        }
        catch (ZksnarkException e) {
            throw e;
        }
        finally {
            JLibrustzcash.librustzcashSaplingProvingCtxFree((long)ctx);
        }
        Protocol.Transaction.raw.Builder rawBuilder = transactionCapsule.getInstance().toBuilder().getRawDataBuilder().clearContract().addContract(Protocol.Transaction.Contract.newBuilder().setType(Protocol.Transaction.Contract.ContractType.ShieldedTransferContract).setParameter(Any.pack((Message)this.contractBuilder.build())).build());
        Protocol.Transaction transaction = transactionCapsule.getInstance().toBuilder().clearRawData().setRawData(rawBuilder).build();
        return new TransactionCapsule(transaction);
    }

    public void createSpendAuth(byte[] dataToBeSigned) throws ZksnarkException {
        for (int i = 0; i < this.spends.size(); ++i) {
            byte[] result = new byte[64];
            JLibrustzcash.librustzcashSaplingSpendSig((LibrustzcashParam.SpendSigParams)new LibrustzcashParam.SpendSigParams(this.spends.get(i).expsk.getAsk(), this.spends.get(i).alpha, dataToBeSigned, result));
            this.contractBuilder.getSpendDescriptionBuilder(i).setSpendAuthoritySignature(ByteString.copyFrom((byte[])result));
        }
    }

    public SpendDescriptionCapsule generateSpendProof(SpendDescriptionInfo spend, long ctx) throws ZksnarkException {
        byte[] nsk;
        byte[] nf;
        byte[] ak;
        byte[] cm = spend.note.cm();
        if (!ArrayUtils.isEmpty((byte[])spend.ak)) {
            ak = spend.ak;
            nf = spend.note.nullifier(ak, JLibrustzcash.librustzcashNskToNk((byte[])spend.nsk), spend.voucher.position());
            nsk = spend.nsk;
        } else {
            ak = spend.expsk.fullViewingKey().getAk();
            nf = spend.note.nullifier(spend.expsk.fullViewingKey(), spend.voucher.position());
            nsk = spend.expsk.getNsk();
        }
        if (ByteArray.isEmpty((byte[])cm) || ByteArray.isEmpty((byte[])nf)) {
            throw new ZksnarkException("Spend is invalid");
        }
        byte[] voucherPath = spend.voucher.path().encode();
        byte[] cv = new byte[32];
        byte[] rk = new byte[32];
        byte[] zkproof = new byte[192];
        if (!JLibrustzcash.librustzcashSaplingSpendProof((LibrustzcashParam.SpendProofParams)new LibrustzcashParam.SpendProofParams(ctx, ak, nsk, spend.note.getD().getData(), spend.note.getRcm(), spend.alpha, spend.note.getValue(), spend.anchor, voucherPath, cv, rk, zkproof))) {
            throw new ZksnarkException("Spend proof failed");
        }
        SpendDescriptionCapsule spendDescriptionCapsule = new SpendDescriptionCapsule();
        spendDescriptionCapsule.setValueCommitment(cv);
        spendDescriptionCapsule.setRk(rk);
        spendDescriptionCapsule.setZkproof(zkproof);
        spendDescriptionCapsule.setAnchor(spend.anchor);
        spendDescriptionCapsule.setNullifier(nf);
        return spendDescriptionCapsule;
    }

    public ReceiveDescriptionCapsule generateOutputProof(ReceiveDescriptionInfo output, long ctx) throws ZksnarkException {
        byte[] cm = output.getNote().cm();
        if (ByteArray.isEmpty((byte[])cm)) {
            throw new ZksnarkException("Output is invalid");
        }
        Optional<Note.NotePlaintextEncryptionResult> res = output.getNote().encrypt(output.getNote().getPkD());
        if (!res.isPresent()) {
            throw new ZksnarkException("Failed to encrypt note");
        }
        Note.NotePlaintextEncryptionResult enc = res.get();
        NoteEncryption encryptor = enc.getNoteEncryption();
        byte[] cv = new byte[32];
        byte[] zkProof = new byte[192];
        if (!JLibrustzcash.librustzcashSaplingOutputProof((LibrustzcashParam.OutputProofParams)new LibrustzcashParam.OutputProofParams(ctx, encryptor.getEsk(), output.getNote().getD().getData(), output.getNote().getPkD(), output.getNote().getRcm(), output.getNote().getValue(), cv, zkProof))) {
            throw new ZksnarkException("Output proof failed");
        }
        if (ArrayUtils.isEmpty((byte[])output.ovk) || output.ovk.length != 32) {
            throw new ZksnarkException("ovk is null or invalid and ovk should be 32 bytes (256 bit)");
        }
        ReceiveDescriptionCapsule receiveDescriptionCapsule = new ReceiveDescriptionCapsule();
        receiveDescriptionCapsule.setValueCommitment(cv);
        receiveDescriptionCapsule.setNoteCommitment(cm);
        receiveDescriptionCapsule.setEpk(encryptor.getEpk());
        receiveDescriptionCapsule.setCEnc(enc.getEncCiphertext());
        receiveDescriptionCapsule.setZkproof(zkProof);
        OutgoingPlaintext outPlaintext = new OutgoingPlaintext(output.getNote().getPkD(), encryptor.getEsk());
        receiveDescriptionCapsule.setCOut(outPlaintext.encrypt(output.ovk, receiveDescriptionCapsule.getValueCommitment().toByteArray(), receiveDescriptionCapsule.getCm().toByteArray(), encryptor).getData());
        return receiveDescriptionCapsule;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public void setSpends(List<SpendDescriptionInfo> spends) {
        this.spends = spends;
    }

    public List<SpendDescriptionInfo> getSpends() {
        return this.spends;
    }

    public void setReceives(List<ReceiveDescriptionInfo> receives) {
        this.receives = receives;
    }

    public List<ReceiveDescriptionInfo> getReceives() {
        return this.receives;
    }

    public long getValueBalance() {
        return this.valueBalance;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public ShieldContract.ShieldedTransferContract.Builder getContractBuilder() {
        return this.contractBuilder;
    }

    public class ReceiveDescriptionInfo {
        private byte[] ovk;
        private Note note;

        public ReceiveDescriptionInfo(byte[] ovk, Note note) {
            this.ovk = ovk;
            this.note = note;
        }

        public byte[] getOvk() {
            return this.ovk;
        }

        public Note getNote() {
            return this.note;
        }
    }

    public static class SpendDescriptionInfo {
        private ExpandedSpendingKey expsk;
        private Note note;
        private byte[] alpha;
        private byte[] anchor;
        private IncrementalMerkleVoucherContainer voucher;
        private byte[] ak;
        private byte[] nsk;
        private byte[] ovk;

        public SpendDescriptionInfo(ExpandedSpendingKey expsk, Note note, byte[] anchor, IncrementalMerkleVoucherContainer voucher) throws ZksnarkException {
            this.expsk = expsk;
            this.note = note;
            this.anchor = anchor;
            this.voucher = voucher;
            this.alpha = new byte[32];
            JLibrustzcash.librustzcashSaplingGenerateR((byte[])this.alpha);
        }

        public SpendDescriptionInfo(ExpandedSpendingKey expsk, Note note, byte[] alpha, byte[] anchor, IncrementalMerkleVoucherContainer voucher) {
            this.expsk = expsk;
            this.note = note;
            this.anchor = anchor;
            this.voucher = voucher;
            this.alpha = alpha;
        }

        public SpendDescriptionInfo(byte[] ak, byte[] nsk, byte[] ovk, Note note, byte[] alpha, byte[] anchor, IncrementalMerkleVoucherContainer voucher) {
            this.ak = ak;
            this.nsk = nsk;
            this.note = note;
            this.anchor = anchor;
            this.voucher = voucher;
            this.alpha = alpha;
            this.ovk = ovk;
        }

        public ExpandedSpendingKey getExpsk() {
            return this.expsk;
        }

        public void setExpsk(ExpandedSpendingKey expsk) {
            this.expsk = expsk;
        }

        public Note getNote() {
            return this.note;
        }

        public void setNote(Note note) {
            this.note = note;
        }

        public byte[] getAlpha() {
            return this.alpha;
        }

        public void setAlpha(byte[] alpha) {
            this.alpha = alpha;
        }

        public byte[] getAnchor() {
            return this.anchor;
        }

        public void setAnchor(byte[] anchor) {
            this.anchor = anchor;
        }

        public IncrementalMerkleVoucherContainer getVoucher() {
            return this.voucher;
        }

        public void setVoucher(IncrementalMerkleVoucherContainer voucher) {
            this.voucher = voucher;
        }

        public byte[] getAk() {
            return this.ak;
        }

        public void setAk(byte[] ak) {
            this.ak = ak;
        }

        public byte[] getNsk() {
            return this.nsk;
        }

        public void setNsk(byte[] nsk) {
            this.nsk = nsk;
        }

        public byte[] getOvk() {
            return this.ovk;
        }

        public void setOvk(byte[] ovk) {
            this.ovk = ovk;
        }
    }
}

