/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.zen;

import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.common.zksnark.LibrustzcashParam;
import org.tron.common.zksnark.ZksnarkUtils;
import org.tron.core.Wallet;
import org.tron.core.capsule.ReceiveDescriptionCapsule;
import org.tron.core.capsule.SpendDescriptionCapsule;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.zen.address.DiversifierT;
import org.tron.core.zen.address.ExpandedSpendingKey;
import org.tron.core.zen.address.PaymentAddress;
import org.tron.core.zen.note.Note;
import org.tron.core.zen.note.NoteEncryption;
import org.tron.core.zen.note.OutgoingPlaintext;
import org.tron.protos.contract.ShieldContract;

public class ShieldedTRC20ParametersBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ShieldedTRC20ParametersBuilder.class);
    private static final int MERKLE_TREE_PATH_LENGTH = 1024;
    private static final String MERKLE_TREE_PATH_LENGTH_ERROR = "Merkle tree path format is wrong";
    private List<SpendDescriptionInfo> spends = new ArrayList<SpendDescriptionInfo>();
    private List<ReceiveDescriptionInfo> receives = new ArrayList<ReceiveDescriptionInfo>();
    private GrpcAPI.ShieldedTRC20Parameters.Builder builder = GrpcAPI.ShieldedTRC20Parameters.newBuilder();
    private long valueBalance = 0L;
    private ShieldedTRC20ParametersType shieldedTRC20ParametersType;
    private byte[] shieldedTRC20Address;
    private BigInteger transparentFromAmount;
    private byte[] transparentToAddress;
    private BigInteger transparentToAmount;
    private byte[] burnCiphertext = new byte[80];

    public ShieldedTRC20ParametersBuilder() {
    }

    public ShieldedTRC20ParametersBuilder(String type) throws ZksnarkException {
        switch (type) {
            case "mint": {
                this.shieldedTRC20ParametersType = ShieldedTRC20ParametersType.MINT;
                break;
            }
            case "transfer": {
                this.shieldedTRC20ParametersType = ShieldedTRC20ParametersType.TRANSFER;
                break;
            }
            case "burn": {
                this.shieldedTRC20ParametersType = ShieldedTRC20ParametersType.BURN;
                break;
            }
            default: {
                throw new ZksnarkException("invalid shielded TRC-20 parameters type");
            }
        }
    }

    private byte[] formatPath(byte[] path, long position) throws ZksnarkException {
        if (path.length != 1024) {
            throw new ZksnarkException(MERKLE_TREE_PATH_LENGTH_ERROR);
        }
        byte[] result = new byte[1065];
        result[0] = 32;
        for (int i = 0; i < 32; ++i) {
            result[1 + i * 33] = 32;
            System.arraycopy(path, i * 32, result, 2 + i * 33, 32);
        }
        byte[] positionBytes = ByteArray.fromLong((long)position);
        ZksnarkUtils.sort((byte[])positionBytes);
        System.arraycopy(positionBytes, 0, result, 1057, 8);
        return result;
    }

    private SpendDescriptionCapsule generateSpendProof(SpendDescriptionInfo spend, long ctx) throws ZksnarkException {
        byte[] nsk;
        byte[] nf;
        byte[] ak;
        byte[] cm = spend.note.cm();
        byte[] path = this.formatPath(spend.path, spend.position);
        if (!ArrayUtils.isEmpty((byte[])spend.ak)) {
            ak = spend.ak;
            nf = spend.note.nullifier(ak, JLibrustzcash.librustzcashNskToNk((byte[])spend.nsk), spend.position);
            nsk = spend.nsk;
        } else {
            ak = spend.expsk.fullViewingKey().getAk();
            nf = spend.note.nullifier(spend.expsk.fullViewingKey(), spend.position);
            nsk = spend.expsk.getNsk();
        }
        if (ByteArray.isEmpty((byte[])cm) || ByteArray.isEmpty((byte[])nf)) {
            throw new ZksnarkException("Spend is invalid");
        }
        byte[] cv = new byte[32];
        byte[] rk = new byte[32];
        byte[] zkproof = new byte[192];
        if (!JLibrustzcash.librustzcashSaplingSpendProof((LibrustzcashParam.SpendProofParams)new LibrustzcashParam.SpendProofParams(ctx, ak, nsk, spend.note.getD().getData(), spend.note.getRcm(), spend.alpha, spend.note.getValue(), spend.anchor, path, cv, rk, zkproof))) {
            throw new ZksnarkException("Spend proof failed");
        }
        SpendDescriptionCapsule spendDescriptionCapsule = new SpendDescriptionCapsule();
        spendDescriptionCapsule.setValueCommitment(cv);
        spendDescriptionCapsule.setRk(rk);
        spendDescriptionCapsule.setZkproof(zkproof);
        spendDescriptionCapsule.setAnchor(spend.anchor);
        spendDescriptionCapsule.setNullifier(nf);
        return spendDescriptionCapsule;
    }

    private ReceiveDescriptionCapsule generateOutputProof(ReceiveDescriptionInfo output, long ctx) throws ZksnarkException {
        byte[] cm = output.getNote().cm();
        byte[] pkD = output.getNote().getPkD();
        if (ByteArray.isEmpty((byte[])cm) || ByteArray.isEmpty((byte[])pkD)) {
            throw new ZksnarkException("Output is invalid");
        }
        Optional<Note.NotePlaintextEncryptionResult> res = output.getNote().encrypt(pkD);
        if (!res.isPresent()) {
            throw new ZksnarkException("Failed to encrypt note");
        }
        Note.NotePlaintextEncryptionResult enc = res.get();
        NoteEncryption encryptor = enc.getNoteEncryption();
        byte[] cv = new byte[32];
        byte[] zkProof = new byte[192];
        if (!JLibrustzcash.librustzcashSaplingOutputProof((LibrustzcashParam.OutputProofParams)new LibrustzcashParam.OutputProofParams(ctx, encryptor.getEsk(), output.getNote().getD().getData(), output.getNote().getPkD(), output.getNote().getRcm(), output.getNote().getValue(), cv, zkProof))) {
            throw new ZksnarkException("Output proof failed");
        }
        if (ArrayUtils.isEmpty((byte[])output.ovk) || output.ovk.length != 32) {
            throw new ZksnarkException("ovk is null or invalid and ovk should be 32 bytes (256 bit)");
        }
        OutgoingPlaintext outPlaintext = new OutgoingPlaintext(output.getNote().getPkD(), encryptor.getEsk());
        byte[] cOut = outPlaintext.encrypt(output.ovk, cv, cm, encryptor).getData();
        ReceiveDescriptionCapsule receiveDescriptionCapsule = new ReceiveDescriptionCapsule();
        receiveDescriptionCapsule.setValueCommitment(cv);
        receiveDescriptionCapsule.setNoteCommitment(cm);
        receiveDescriptionCapsule.setEpk(encryptor.getEpk());
        receiveDescriptionCapsule.setCEnc(enc.getEncCiphertext());
        receiveDescriptionCapsule.setZkproof(zkProof);
        receiveDescriptionCapsule.setCOut(cOut);
        return receiveDescriptionCapsule;
    }

    private void createSpendAuth(byte[] dataToBeSigned) throws ZksnarkException {
        for (int i = 0; i < this.spends.size(); ++i) {
            byte[] result = new byte[64];
            JLibrustzcash.librustzcashSaplingSpendSig((LibrustzcashParam.SpendSigParams)new LibrustzcashParam.SpendSigParams(this.spends.get(i).expsk.getAsk(), this.spends.get(i).alpha, dataToBeSigned, result));
            this.builder.getSpendDescriptionBuilder(i).setSpendAuthoritySignature(ByteString.copyFrom((byte[])result));
        }
    }

    private byte[] encodeSpendDescriptionWithoutSpendAuthSig(ShieldContract.SpendDescription spendDescription) {
        return ByteUtil.merge((byte[][])new byte[][]{spendDescription.getNullifier().toByteArray(), spendDescription.getAnchor().toByteArray(), spendDescription.getValueCommitment().toByteArray(), spendDescription.getRk().toByteArray(), spendDescription.getZkproof().toByteArray()});
    }

    private byte[] encodeReceiveDescriptionWithoutC(ShieldContract.ReceiveDescription receiveDescription) {
        return ByteUtil.merge((byte[][])new byte[][]{receiveDescription.getNoteCommitment().toByteArray(), receiveDescription.getValueCommitment().toByteArray(), receiveDescription.getEpk().toByteArray(), receiveDescription.getZkproof().toByteArray()});
    }

    private byte[] encodeCencCout(ShieldContract.ReceiveDescription receiveDescription) {
        byte[] padding = new byte[12];
        return ByteUtil.merge((byte[][])new byte[][]{receiveDescription.getCEnc().toByteArray(), receiveDescription.getCOut().toByteArray(), padding});
    }

    public GrpcAPI.ShieldedTRC20Parameters build(boolean withAsk) throws ZksnarkException {
        BigInteger value = BigInteger.ZERO;
        long ctx = JLibrustzcash.librustzcashSaplingProvingCtxInit();
        try {
            byte[] mergedBytes;
            switch (this.shieldedTRC20ParametersType) {
                case MINT: {
                    ReceiveDescriptionInfo receive = this.receives.get(0);
                    ShieldContract.ReceiveDescription receiveDescription = this.generateOutputProof(receive, ctx).getInstance();
                    this.builder.addReceiveDescription(receiveDescription);
                    mergedBytes = ByteUtil.merge((byte[][])new byte[][]{this.shieldedTRC20Address, ByteArray.fromLong((long)receive.getNote().getValue()), this.encodeReceiveDescriptionWithoutC(receiveDescription), this.encodeCencCout(receiveDescription)});
                    value = this.transparentFromAmount;
                    this.builder.setParameterType("mint");
                    break;
                }
                case TRANSFER: {
                    mergedBytes = this.shieldedTRC20Address;
                    for (SpendDescriptionInfo spendDescriptionInfo : this.spends) {
                        ShieldContract.SpendDescription spendDescription = this.generateSpendProof(spendDescriptionInfo, ctx).getInstance();
                        this.builder.addSpendDescription(spendDescription);
                        mergedBytes = ByteUtil.merge((byte[][])new byte[][]{mergedBytes, this.encodeSpendDescriptionWithoutSpendAuthSig(spendDescription)});
                    }
                    byte[] cencCout = new byte[]{};
                    for (ReceiveDescriptionInfo receiveD : this.receives) {
                        ShieldContract.ReceiveDescription receiveDescription = this.generateOutputProof(receiveD, ctx).getInstance();
                        this.builder.addReceiveDescription(receiveDescription);
                        mergedBytes = ByteUtil.merge((byte[][])new byte[][]{mergedBytes, this.encodeReceiveDescriptionWithoutC(receiveDescription)});
                        cencCout = ByteUtil.merge((byte[][])new byte[][]{cencCout, this.encodeCencCout(receiveDescription)});
                    }
                    mergedBytes = ByteUtil.merge((byte[][])new byte[][]{mergedBytes, cencCout});
                    this.builder.setParameterType("transfer");
                    break;
                }
                case BURN: {
                    SpendDescriptionInfo spendDescriptionInfo = this.spends.get(0);
                    ShieldContract.SpendDescription spendDescription = this.generateSpendProof(spendDescriptionInfo, ctx).getInstance();
                    this.builder.addSpendDescription(spendDescription);
                    mergedBytes = ByteUtil.merge((byte[][])new byte[][]{this.shieldedTRC20Address, this.encodeSpendDescriptionWithoutSpendAuthSig(spendDescription)});
                    if (this.receives.size() == 1) {
                        ShieldContract.ReceiveDescription receiveDescription = this.generateOutputProof(this.receives.get(0), ctx).getInstance();
                        this.builder.addReceiveDescription(receiveDescription);
                        mergedBytes = ByteUtil.merge((byte[][])new byte[][]{mergedBytes, this.encodeReceiveDescriptionWithoutC(receiveDescription), this.encodeCencCout(receiveDescription)});
                    }
                    mergedBytes = ByteUtil.merge((byte[][])new byte[][]{mergedBytes, this.transparentToAddress, ByteArray.fromLong((long)this.valueBalance)});
                    value = this.transparentToAmount;
                    this.builder.setParameterType("burn");
                    break;
                }
                default: {
                    throw new ZksnarkException("unknown parameters type");
                }
            }
            byte[] dataHashToBeSigned = Sha256Hash.of((boolean)true, (byte[])mergedBytes).getBytes();
            if (dataHashToBeSigned == null) {
                throw new ZksnarkException("calculate transaction hash failed");
            }
            if (withAsk) {
                this.createSpendAuth(dataHashToBeSigned);
            }
            this.builder.setMessageHash(ByteString.copyFrom((byte[])dataHashToBeSigned));
            byte[] bindingSig = new byte[64];
            JLibrustzcash.librustzcashSaplingBindingSig((LibrustzcashParam.BindingSigParams)new LibrustzcashParam.BindingSigParams(ctx, this.valueBalance, dataHashToBeSigned, bindingSig));
            this.builder.setBindingSignature(ByteString.copyFrom((byte[])bindingSig));
        }
        catch (Exception e) {
            throw new ZksnarkException("build the shielded TRC-20 parameters error: " + e.getMessage());
        }
        finally {
            JLibrustzcash.librustzcashSaplingProvingCtxFree((long)ctx);
        }
        if (withAsk || this.shieldedTRC20ParametersType == ShieldedTRC20ParametersType.MINT) {
            GrpcAPI.ShieldedTRC20Parameters shieldedTRC20Parameters = this.builder.build();
            this.builder.setTriggerContractInput(this.getTriggerContractInput(shieldedTRC20Parameters, null, value, true, this.transparentToAddress));
        }
        if (!withAsk && this.shieldedTRC20ParametersType == ShieldedTRC20ParametersType.BURN) {
            this.builder.setTriggerContractInput(Hex.toHexString((byte[])this.burnCiphertext));
        }
        return this.builder.build();
    }

    public String getTriggerContractInput(GrpcAPI.ShieldedTRC20Parameters shieldedTRC20Parameters, List<GrpcAPI.BytesMessage> spendAuthoritySignature, BigInteger value, boolean withAsk, byte[] transparentToAddress) {
        switch (this.shieldedTRC20ParametersType) {
            case MINT: {
                return this.mintParamsToHexString(shieldedTRC20Parameters, value);
            }
            case TRANSFER: {
                return this.transferParamsToHexString(shieldedTRC20Parameters, spendAuthoritySignature, withAsk);
            }
            case BURN: {
                return this.burnParamsToHexString(shieldedTRC20Parameters, spendAuthoritySignature, value, transparentToAddress, withAsk);
            }
        }
        return null;
    }

    private String mintParamsToHexString(GrpcAPI.ShieldedTRC20Parameters mintParams, BigInteger value) {
        if (value.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("require the value be positive");
        }
        ShieldContract.ReceiveDescription revDesc = mintParams.getReceiveDescription(0);
        byte[] zeros = new byte[12];
        byte[] mergedBytes = ByteUtil.merge((byte[][])new byte[][]{ByteUtil.bigIntegerToBytes((BigInteger)value, (int)32), revDesc.getNoteCommitment().toByteArray(), revDesc.getValueCommitment().toByteArray(), revDesc.getEpk().toByteArray(), revDesc.getZkproof().toByteArray(), mintParams.getBindingSignature().toByteArray(), revDesc.getCEnc().toByteArray(), revDesc.getCOut().toByteArray(), zeros});
        return Hex.toHexString((byte[])mergedBytes);
    }

    private String transferParamsToHexString(GrpcAPI.ShieldedTRC20Parameters transferParams, List<GrpcAPI.BytesMessage> spendAuthoritySignature, boolean withAsk) {
        byte[] input = new byte[]{};
        byte[] spendAuthSig = new byte[]{};
        byte[] output = new byte[]{};
        byte[] c = new byte[]{};
        List spendDescs = transferParams.getSpendDescriptionList();
        for (ShieldContract.SpendDescription spendDesc : spendDescs) {
            input = ByteUtil.merge((byte[][])new byte[][]{input, spendDesc.getNullifier().toByteArray(), spendDesc.getAnchor().toByteArray(), spendDesc.getValueCommitment().toByteArray(), spendDesc.getRk().toByteArray(), spendDesc.getZkproof().toByteArray()});
            if (!withAsk) continue;
            spendAuthSig = ByteUtil.merge((byte[][])new byte[][]{spendAuthSig, spendDesc.getSpendAuthoritySignature().toByteArray()});
        }
        long spendCount = spendDescs.size();
        if (spendCount < 1L || spendCount > 2L) {
            throw new IllegalArgumentException("invalid transfer input number");
        }
        if (!withAsk) {
            spendAuthSig = spendCount == 1L ? spendAuthoritySignature.get(0).getValue().toByteArray() : ByteUtil.merge((byte[][])new byte[][]{spendAuthoritySignature.get(0).getValue().toByteArray(), spendAuthoritySignature.get(1).getValue().toByteArray()});
        }
        byte[] inputOffsetbytes = ByteUtil.longTo32Bytes((long)192L);
        byte[] spendCountBytes = ByteUtil.longTo32Bytes((long)spendCount);
        byte[] authOffsetBytes = ByteUtil.longTo32Bytes((long)(224L + 320L * spendCount));
        List recvDescs = transferParams.getReceiveDescriptionList();
        for (ShieldContract.ReceiveDescription recvDesc : recvDescs) {
            output = ByteUtil.merge((byte[][])new byte[][]{output, recvDesc.getNoteCommitment().toByteArray(), recvDesc.getValueCommitment().toByteArray(), recvDesc.getEpk().toByteArray(), recvDesc.getZkproof().toByteArray()});
            byte[] zeros = new byte[12];
            c = ByteUtil.merge((byte[][])new byte[][]{c, recvDesc.getCEnc().toByteArray(), recvDesc.getCOut().toByteArray(), zeros});
        }
        long recvCount = recvDescs.size();
        byte[] recvCountBytes = ByteUtil.longTo32Bytes((long)recvCount);
        byte[] outputOffsetbytes = ByteUtil.longTo32Bytes((long)(224L + 320L * spendCount + 32L + 64L * spendCount));
        byte[] coffsetBytes = ByteUtil.longTo32Bytes((long)(224L + 320L * spendCount + 32L + 64L * spendCount + 32L + 288L * recvCount));
        byte[] bindingSig = transferParams.getBindingSignature().toByteArray();
        return Hex.toHexString((byte[])ByteUtil.merge((byte[][])new byte[][]{inputOffsetbytes, authOffsetBytes, outputOffsetbytes, bindingSig, coffsetBytes, spendCountBytes, input, spendCountBytes, spendAuthSig, recvCountBytes, output, recvCountBytes, c}));
    }

    private String burnParamsToHexString(GrpcAPI.ShieldedTRC20Parameters burnParams, List<GrpcAPI.BytesMessage> spendAuthoritySignature, BigInteger value, byte[] transparentToAddress, boolean withAsk) {
        byte[] payTo = new byte[32];
        if (value.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("the value must be positive");
        }
        if (ArrayUtils.isEmpty((byte[])transparentToAddress)) {
            throw new IllegalArgumentException("the transparent payTo address is null");
        }
        payTo[11] = Wallet.getAddressPreFixByte();
        System.arraycopy(transparentToAddress, 0, payTo, 12, 20);
        ShieldContract.SpendDescription spendDesc = burnParams.getSpendDescription(0);
        byte[] spendAuthSign = withAsk ? spendDesc.getSpendAuthoritySignature().toByteArray() : spendAuthoritySignature.get(0).getValue().toByteArray();
        byte[] zeros = new byte[16];
        byte[] mergedBytes = ByteUtil.merge((byte[][])new byte[][]{spendDesc.getNullifier().toByteArray(), spendDesc.getAnchor().toByteArray(), spendDesc.getValueCommitment().toByteArray(), spendDesc.getRk().toByteArray(), spendDesc.getZkproof().toByteArray(), spendAuthSign, ByteUtil.bigIntegerToBytes((BigInteger)value, (int)32), burnParams.getBindingSignature().toByteArray(), payTo, this.burnCiphertext, zeros});
        if (burnParams.getReceiveDescriptionList().size() == 0) {
            byte[] outputOffsetBytes = ByteUtil.longTo32Bytes((long)((long)mergedBytes.length + 64L));
            byte[] outputCountBytes = ByteUtil.longTo32Bytes((long)0L);
            byte[] coffsetBytes = ByteUtil.longTo32Bytes((long)((long)mergedBytes.length + 96L));
            byte[] countBytes = ByteUtil.longTo32Bytes((long)0L);
            mergedBytes = ByteUtil.merge((byte[][])new byte[][]{mergedBytes, outputOffsetBytes, coffsetBytes, outputCountBytes, countBytes});
        } else {
            byte[] outputOffsetBytes = ByteUtil.longTo32Bytes((long)((long)mergedBytes.length + 64L));
            byte[] outputCountBytes = ByteUtil.longTo32Bytes((long)1L);
            byte[] coffsetBytes = ByteUtil.longTo32Bytes((long)((long)(mergedBytes.length + 96) + 288L));
            byte[] countBytes = ByteUtil.longTo32Bytes((long)1L);
            ShieldContract.ReceiveDescription recvDesc = burnParams.getReceiveDescription(0);
            zeros = new byte[12];
            mergedBytes = ByteUtil.merge((byte[][])new byte[][]{mergedBytes, outputOffsetBytes, coffsetBytes, outputCountBytes, recvDesc.getNoteCommitment().toByteArray(), recvDesc.getValueCommitment().toByteArray(), recvDesc.getEpk().toByteArray(), recvDesc.getZkproof().toByteArray(), countBytes, recvDesc.getCEnc().toByteArray(), recvDesc.getCOut().toByteArray(), zeros});
        }
        return Hex.toHexString((byte[])mergedBytes);
    }

    public void addSpend(ExpandedSpendingKey expsk, Note note, byte[] anchor, byte[] path, long position) throws ZksnarkException {
        this.spends.add(new SpendDescriptionInfo(expsk, note, anchor, path, position));
        this.valueBalance += note.getValue();
    }

    public void addSpend(ExpandedSpendingKey expsk, Note note, byte[] alpha, byte[] anchor, byte[] path, long position) {
        this.spends.add(new SpendDescriptionInfo(expsk, note, alpha, anchor, path, position));
        this.valueBalance += note.getValue();
    }

    public void addSpend(byte[] ak, byte[] nsk, Note note, byte[] alpha, byte[] anchor, byte[] path, long position) {
        this.spends.add(new SpendDescriptionInfo(ak, nsk, note, alpha, anchor, path, position));
        this.valueBalance += note.getValue();
    }

    public void addOutput(byte[] ovk, PaymentAddress to, long value, byte[] memo) throws ZksnarkException {
        Note note = new Note(to, value);
        note.setMemo(memo);
        this.receives.add(new ReceiveDescriptionInfo(ovk, note));
        this.valueBalance -= value;
    }

    public void addOutput(byte[] ovk, DiversifierT d, byte[] pkD, long value, byte[] r, byte[] memo) {
        Note note = new Note(d, pkD, value, r);
        note.setMemo(memo);
        this.receives.add(new ReceiveDescriptionInfo(ovk, note));
        this.valueBalance -= value;
    }

    public void setSpends(List<SpendDescriptionInfo> spends) {
        this.spends = spends;
    }

    public void setReceives(List<ReceiveDescriptionInfo> receives) {
        this.receives = receives;
    }

    public GrpcAPI.ShieldedTRC20Parameters.Builder getBuilder() {
        return this.builder;
    }

    public long getValueBalance() {
        return this.valueBalance;
    }

    public ShieldedTRC20ParametersType getShieldedTRC20ParametersType() {
        return this.shieldedTRC20ParametersType;
    }

    public void setShieldedTRC20ParametersType(ShieldedTRC20ParametersType shieldedTRC20ParametersType) {
        this.shieldedTRC20ParametersType = shieldedTRC20ParametersType;
    }

    public void setShieldedTRC20Address(byte[] shieldedTRC20Address) {
        this.shieldedTRC20Address = shieldedTRC20Address;
    }

    public void setTransparentFromAmount(BigInteger transparentFromAmount) {
        this.transparentFromAmount = transparentFromAmount;
    }

    public void setTransparentToAddress(byte[] transparentToAddress) {
        this.transparentToAddress = transparentToAddress;
    }

    public void setTransparentToAmount(BigInteger transparentToAmount) {
        this.transparentToAmount = transparentToAmount;
    }

    public void setBurnCiphertext(byte[] burnCiphertext) {
        this.burnCiphertext = burnCiphertext;
    }

    public static enum ShieldedTRC20ParametersType {
        MINT,
        TRANSFER,
        BURN;

    }

    private class ReceiveDescriptionInfo {
        private byte[] ovk;
        private Note note;

        public ReceiveDescriptionInfo(byte[] ovk, Note note) {
            this.ovk = ovk;
            this.note = note;
        }

        public Note getNote() {
            return this.note;
        }
    }

    public static class SpendDescriptionInfo {
        private ExpandedSpendingKey expsk;
        private Note note;
        private byte[] alpha;
        private byte[] anchor;
        private byte[] path;
        private long position;
        private byte[] ak;
        private byte[] nsk;

        private SpendDescriptionInfo(ExpandedSpendingKey expsk, Note note, byte[] anchor, byte[] path, long position) throws ZksnarkException {
            this.expsk = expsk;
            this.note = note;
            this.anchor = anchor;
            this.path = path;
            this.position = position;
            this.alpha = new byte[32];
            JLibrustzcash.librustzcashSaplingGenerateR((byte[])this.alpha);
        }

        private SpendDescriptionInfo(ExpandedSpendingKey expsk, Note note, byte[] alpha, byte[] anchor, byte[] path, long position) {
            this.expsk = expsk;
            this.note = note;
            this.anchor = anchor;
            this.path = path;
            this.position = position;
            this.alpha = alpha;
        }

        private SpendDescriptionInfo(byte[] ak, byte[] nsk, Note note, byte[] alpha, byte[] anchor, byte[] path, long position) {
            this.ak = ak;
            this.nsk = nsk;
            this.note = note;
            this.anchor = anchor;
            this.path = path;
            this.position = position;
            this.alpha = alpha;
        }
    }
}

