/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.ratelimiter.strategy;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.RateLimiter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.tron.core.services.ratelimiter.strategy.Strategy;

public class IPQpsStrategy
extends Strategy {
    public static final String STRATEGY_PARAM_IPQPS = "qps";
    public static final Double DEFAULT_IPQPS = 2.0;
    private Cache<String, RateLimiter> ipLimiter = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(600L, TimeUnit.SECONDS).recordStats().build();

    public IPQpsStrategy(String paramString) {
        super(paramString);
    }

    public boolean acquire(String ip) {
        RateLimiter limiter = (RateLimiter)this.ipLimiter.getIfPresent((Object)ip);
        if (limiter == null) {
            limiter = this.newRateLimiter();
            this.ipLimiter.put((Object)ip, (Object)limiter);
        }
        limiter.acquire();
        return true;
    }

    private RateLimiter newRateLimiter() {
        return RateLimiter.create((double)((Double)((Strategy.ParamItem)this.mapParams.get((Object)STRATEGY_PARAM_IPQPS)).value));
    }

    @Override
    protected Map<String, Strategy.ParamItem> defaultParam() {
        HashMap<String, Strategy.ParamItem> map = new HashMap<String, Strategy.ParamItem>();
        map.put(STRATEGY_PARAM_IPQPS, new Strategy.ParamItem<Double>(this, Double.class, DEFAULT_IPQPS));
        return map;
    }
}

