/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.ratelimiter.strategy;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.services.ratelimiter.strategy.Strategy;

public class GlobalPreemptibleStrategy
extends Strategy {
    private static final Logger logger = LoggerFactory.getLogger(GlobalPreemptibleStrategy.class);
    public static final String STRATEGY_PARAM_PERMIT = "permit";
    public static final int DEFAULT_PERMIT_NUM = 1;
    public static final int DEFAULT_ACQUIRE_TIMEOUT = 2;
    private Semaphore sp;

    public GlobalPreemptibleStrategy(String paramString) {
        super(paramString);
        this.sp = new Semaphore((Integer)((Strategy.ParamItem)this.mapParams.get((Object)STRATEGY_PARAM_PERMIT)).value);
    }

    @Override
    protected Map<String, Strategy.ParamItem> defaultParam() {
        HashMap<String, Strategy.ParamItem> map = new HashMap<String, Strategy.ParamItem>();
        map.put(STRATEGY_PARAM_PERMIT, new Strategy.ParamItem<Integer>(this, Integer.class, 1));
        return map;
    }

    public boolean acquire() {
        try {
            if (!this.sp.tryAcquire(2L, TimeUnit.SECONDS)) {
                throw new RuntimeException();
            }
        }
        catch (InterruptedException e) {
            logger.error("acquire permit with error: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException e1) {
            return false;
        }
        return true;
    }

    public void release() {
        this.sp.release();
    }
}

