/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.ratelimiter;

import io.grpc.Grpc;
import io.grpc.ServerCall;
import java.net.InetSocketAddress;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeData {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeData.class);
    private String address = "";

    public RuntimeData(Object o) {
        if (o instanceof HttpServletRequest) {
            this.address = ((HttpServletRequest)o).getRemoteAddr();
        } else if (o instanceof ServerCall) {
            try {
                InetSocketAddress s = (InetSocketAddress)((ServerCall)o).getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
                this.address = s.getAddress().getHostAddress();
            }
            catch (Exception npe) {
                logger.warn("the address get from the runtime data is a null value unexpected.");
            }
        }
        if (this.address == null) {
            logger.warn("assign the address with an empty string.");
            this.address = "";
        }
    }

    public String getRemoteAddr() {
        return this.address;
    }
}

