/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.ratelimiter;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.prometheus.client.Histogram;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.prometheus.Metrics;

@Component
public class RpcApiAccessInterceptor
implements ServerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(RpcApiAccessInterceptor.class);

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        String endpoint = call.getMethodDescriptor().getFullMethodName();
        try {
            if (this.isDisabled(endpoint)) {
                call.close(Status.UNAVAILABLE.withDescription("this API is unavailable due to config"), headers);
                return new ServerCall.Listener<ReqT>(){};
            }
            Histogram.Timer requestTimer = Metrics.histogramStartTimer((String)"tron:grpc_service_latency_seconds", (String[])new String[]{endpoint});
            ServerCall.Listener res = next.startCall(call, headers);
            Metrics.histogramObserve((Histogram.Timer)requestTimer);
            return res;
        }
        catch (Exception e) {
            logger.error("check rpc api access Error: {}", (Object)e.getMessage());
            return next.startCall(call, headers);
        }
    }

    private boolean isDisabled(String endpoint) {
        boolean disabled = false;
        try {
            List disabledApiList = CommonParameter.getInstance().getDisabledApiList();
            if (!disabledApiList.isEmpty()) {
                disabled = disabledApiList.contains(endpoint.split("/")[1].toLowerCase());
            }
        }
        catch (Exception e) {
            logger.error("check isDisabled except, endpoint={}, error is {}", (Object)endpoint, (Object)e.getMessage());
        }
        return disabled;
    }
}

