/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.ratelimiter;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import org.tron.core.config.args.Args;
import org.tron.core.services.ratelimiter.RuntimeData;

public class GlobalRateLimiter {
    private static double QPS = Args.getInstance().getRateLimiterGlobalQps();
    private static double IP_QPS = Args.getInstance().getRateLimiterGlobalIpQps();
    private static Cache<String, RateLimiter> cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static RateLimiter rateLimiter = RateLimiter.create((double)QPS);

    public static void acquire(RuntimeData runtimeData) {
        rateLimiter.acquire();
        String ip = runtimeData.getRemoteAddr();
        if (Strings.isNullOrEmpty((String)ip)) {
            return;
        }
        RateLimiter r = (RateLimiter)cache.getIfPresent((Object)ip);
        if (r == null) {
            r = RateLimiter.create((double)IP_QPS);
            cache.put((Object)ip, (Object)r);
        }
        r.acquire();
    }
}

