/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.services.jsonrpc.JsonRpcApiUtil;
import org.tron.protos.Protocol;

@JsonPropertyOrder(alphabetic=true)
public class TransactionReceipt {
    private String blockHash;
    private String blockNumber;
    private String transactionIndex;
    private String transactionHash;
    private String from;
    private String to;
    private String cumulativeGasUsed;
    private String effectiveGasPrice;
    private String gasUsed;
    private String contractAddress;
    private TransactionLog[] logs;
    private String logsBloom;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String root;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String status;
    private String type = "0x0";

    public TransactionReceipt(Protocol.Block block, Protocol.TransactionInfo txInfo, Wallet wallet) {
        BlockCapsule blockCapsule = new BlockCapsule(block);
        String txid = ByteArray.toHexString((byte[])txInfo.getId().toByteArray());
        long blockNum = blockCapsule.getNum();
        Protocol.Transaction transaction = null;
        long cumulativeGas = 0L;
        long cumulativeLogCount = 0L;
        GrpcAPI.TransactionInfoList infoList = wallet.getTransactionInfoByBlockNum(blockNum);
        for (int index = 0; index < infoList.getTransactionInfoCount(); ++index) {
            Protocol.TransactionInfo info = infoList.getTransactionInfo(index);
            Protocol.ResourceReceipt resourceReceipt = info.getReceipt();
            long energyUsage = resourceReceipt.getEnergyUsageTotal();
            cumulativeGas += energyUsage;
            if (ByteArray.toHexString((byte[])info.getId().toByteArray()).equals(txid)) {
                this.transactionIndex = ByteArray.toJsonHex((int)index);
                this.cumulativeGasUsed = ByteArray.toJsonHex((Long)cumulativeGas);
                this.gasUsed = ByteArray.toJsonHex((Long)energyUsage);
                this.status = resourceReceipt.getResultValue() <= 1 ? "0x1" : "0x0";
                transaction = block.getTransactions(index);
                break;
            }
            cumulativeLogCount += (long)info.getLogCount();
        }
        this.blockHash = ByteArray.toJsonHex((byte[])blockCapsule.getBlockId().getBytes());
        this.blockNumber = ByteArray.toJsonHex((Long)blockCapsule.getNum());
        this.transactionHash = ByteArray.toJsonHex((byte[])txInfo.getId().toByteArray());
        this.effectiveGasPrice = ByteArray.toJsonHex((Long)wallet.getEnergyFee(blockCapsule.getTimeStamp()));
        this.from = null;
        this.to = null;
        this.contractAddress = null;
        if (transaction != null && !transaction.getRawData().getContractList().isEmpty()) {
            Protocol.Transaction.Contract contract = transaction.getRawData().getContract(0);
            byte[] fromByte = TransactionCapsule.getOwner((Protocol.Transaction.Contract)contract);
            byte[] toByte = JsonRpcApiUtil.getToAddress(transaction);
            this.from = ByteArray.toJsonHexAddress((byte[])fromByte);
            this.to = ByteArray.toJsonHexAddress((byte[])toByte);
            if (contract.getType() == Protocol.Transaction.Contract.ContractType.CreateSmartContract) {
                this.contractAddress = ByteArray.toJsonHexAddress((byte[])txInfo.getContractAddress().toByteArray());
            }
        }
        ArrayList<TransactionLog> logList = new ArrayList<TransactionLog>();
        for (int index = 0; index < txInfo.getLogCount(); ++index) {
            Protocol.TransactionInfo.Log log = (Protocol.TransactionInfo.Log)txInfo.getLogList().get(index);
            TransactionLog transactionLog = new TransactionLog();
            transactionLog.logIndex = ByteArray.toJsonHex((Long)((long)index + cumulativeLogCount));
            transactionLog.transactionHash = this.transactionHash;
            transactionLog.transactionIndex = this.transactionIndex;
            transactionLog.blockHash = this.blockHash;
            transactionLog.blockNumber = this.blockNumber;
            byte[] addressByte = JsonRpcApiUtil.convertToTronAddress(log.getAddress().toByteArray());
            transactionLog.address = ByteArray.toJsonHexAddress((byte[])addressByte);
            transactionLog.data = ByteArray.toJsonHex((byte[])log.getData().toByteArray());
            String[] topics = new String[log.getTopicsCount()];
            for (int i = 0; i < log.getTopicsCount(); ++i) {
                topics[i] = ByteArray.toJsonHex((byte[])log.getTopics(i).toByteArray());
            }
            TransactionLog.access$702(transactionLog, topics);
            logList.add(transactionLog);
        }
        this.logs = logList.toArray(new TransactionLog[logList.size()]);
        this.logsBloom = ByteArray.toJsonHex((byte[])new byte[256]);
        this.root = null;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public String getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
    }

    public String getTransactionIndex() {
        return this.transactionIndex;
    }

    public void setTransactionIndex(String transactionIndex) {
        this.transactionIndex = transactionIndex;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getCumulativeGasUsed() {
        return this.cumulativeGasUsed;
    }

    public void setCumulativeGasUsed(String cumulativeGasUsed) {
        this.cumulativeGasUsed = cumulativeGasUsed;
    }

    public String getEffectiveGasPrice() {
        return this.effectiveGasPrice;
    }

    public void setEffectiveGasPrice(String effectiveGasPrice) {
        this.effectiveGasPrice = effectiveGasPrice;
    }

    public String getGasUsed() {
        return this.gasUsed;
    }

    public void setGasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public TransactionLog[] getLogs() {
        return this.logs;
    }

    public void setLogs(TransactionLog[] logs) {
        this.logs = logs;
    }

    public String getLogsBloom() {
        return this.logsBloom;
    }

    public void setLogsBloom(String logsBloom) {
        this.logsBloom = logsBloom;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonPropertyOrder(alphabetic=true)
    public static class TransactionLog {
        private String logIndex;
        private String blockHash;
        private String blockNumber;
        private String transactionIndex;
        private String transactionHash;
        private String address;
        private String data;
        private String[] topics;
        private boolean removed = false;

        public String getLogIndex() {
            return this.logIndex;
        }

        public void setLogIndex(String logIndex) {
            this.logIndex = logIndex;
        }

        public String getBlockHash() {
            return this.blockHash;
        }

        public void setBlockHash(String blockHash) {
            this.blockHash = blockHash;
        }

        public String getBlockNumber() {
            return this.blockNumber;
        }

        public void setBlockNumber(String blockNumber) {
            this.blockNumber = blockNumber;
        }

        public String getTransactionIndex() {
            return this.transactionIndex;
        }

        public void setTransactionIndex(String transactionIndex) {
            this.transactionIndex = transactionIndex;
        }

        public String getTransactionHash() {
            return this.transactionHash;
        }

        public void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String[] getTopics() {
            return this.topics;
        }

        public void setTopics(String[] topics) {
            this.topics = topics;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void setRemoved(boolean removed) {
            this.removed = removed;
        }

        static /* synthetic */ String[] access$702(TransactionLog x0, String[] x1) {
            x0.topics = x1;
            return x1;
        }
    }
}

